/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.JaxBsonTransient;
import org.qnixyz.jbson.annotations.cfg.JaxBsonTransientImpl;
import org.qnixyz.jbson.annotations.cfg.Utils;

public class JaxBsonTransientFieldMap {
    private Map<Field, JaxBsonTransient> map;

    public boolean containsKey(Field key) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(key);
    }

    public JaxBsonTransient get(Field field) {
        Objects.requireNonNull(field);
        if (this.map == null) {
            return null;
        }
        return this.map.get(field);
    }

    public Set<Field> getKeySet() {
        if (this.map == null) {
            return Collections.emptySet();
        }
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public void put(Field field, JaxBsonTransient jaxBsonTransient) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(jaxBsonTransient);
        if (this.map == null) {
            this.map = new HashMap<Field, JaxBsonTransient>();
        }
        this.map.put(field, jaxBsonTransient);
    }

    public JaxBsonTransient remove(Field field) {
        if (this.map == null) {
            return null;
        }
        return this.map.remove(field);
    }

    public static class XmlAdapter
    extends javax.xml.bind.annotation.adapters.XmlAdapter<JaxBsonTransientFieldMapType, JaxBsonTransientFieldMap> {
        public JaxBsonTransientFieldMapType marshal(JaxBsonTransientFieldMap v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonTransientFieldMapType ret = new JaxBsonTransientFieldMapType();
            for (Map.Entry e : v.map.entrySet()) {
                ret.add(new JaxBsonTransientFieldMapEntry((Field)e.getKey(), (JaxBsonTransient)e.getValue()));
            }
            return ret;
        }

        public JaxBsonTransientFieldMap unmarshal(JaxBsonTransientFieldMapType v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonTransientFieldMap ret = new JaxBsonTransientFieldMap();
            for (JaxBsonTransientFieldMapEntry e : v.set) {
                Field field = Utils.declaredFieldByName(e.fieldClass, e.fieldName);
                if (ret.containsKey(field)) {
                    throw new IllegalStateException("Multiple definitions of JaxBsonTransientMap field: " + e.fieldClass + "." + e.fieldName);
                }
                ret.put(field, e.jaxBsonTransient);
            }
            return ret;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class JaxBsonTransientFieldMapType {
        @JaxBsonName(name="entries")
        @XmlElement(name="entry")
        private SortedSet<JaxBsonTransientFieldMapEntry> set;

        private JaxBsonTransientFieldMapType() {
        }

        private void add(JaxBsonTransientFieldMapEntry e) {
            Objects.requireNonNull(e);
            if (this.set == null) {
                this.set = new TreeSet<JaxBsonTransientFieldMapEntry>();
            }
            this.set.add(e);
        }

        private boolean isEmpty() {
            return this.set == null || this.set.isEmpty();
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class JaxBsonTransientFieldMapEntry
    implements Comparable<JaxBsonTransientFieldMapEntry> {
        @XmlAttribute(required=true)
        private String fieldClass;
        @XmlAttribute(required=true)
        private String fieldName;
        @XmlElement(required=true)
        private JaxBsonTransientImpl jaxBsonTransient;

        private JaxBsonTransientFieldMapEntry() {
        }

        private JaxBsonTransientFieldMapEntry(Field field, JaxBsonTransient jaxBsonTransient) {
            this.fieldClass = field.getDeclaringClass().getName();
            this.fieldName = field.getName();
            if (jaxBsonTransient != null) {
                this.jaxBsonTransient = jaxBsonTransient instanceof JaxBsonTransientImpl ? (JaxBsonTransientImpl)jaxBsonTransient : new JaxBsonTransientImpl(jaxBsonTransient);
            }
        }

        @Override
        public int compareTo(JaxBsonTransientFieldMapEntry o) {
            if (o == null) {
                return 1;
            }
            int ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldClass, o.fieldClass);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldName, o.fieldName);
            if (ret != 0) {
                return ret;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxBsonTransientFieldMapEntry other = (JaxBsonTransientFieldMapEntry)obj;
            if (this.fieldClass == null ? other.fieldClass != null : !this.fieldClass.equals(other.fieldClass)) {
                return false;
            }
            return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldClass == null ? 0 : this.fieldClass.hashCode());
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            return result;
        }
    }
}

