/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.qnixyz.jbson.JaxBsonContext;
import org.qnixyz.jbson.JaxBsonException;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.JaxBsonToBsonPost;
import org.qnixyz.jbson.annotations.JaxBsonToBsonPre;
import org.qnixyz.jbson.annotations.JaxBsonToObjectPost;
import org.qnixyz.jbson.annotations.JaxBsonToObjectPre;
import org.qnixyz.jbson.impl.FieldDescriptor;
import org.qnixyz.jbson.impl.FieldSubDescriptor;
import org.qnixyz.jbson.impl.JaxBsonContextImpl;
import org.qnixyz.jbson.impl.Utils;

class ClassDescriptor {
    private final SortedMap<String, FieldDescriptor> bsonFieldNameMap = new TreeMap<String, FieldDescriptor>();
    private final Constructor<?> constructor;
    private final JaxBsonContextImpl ctx;
    private FieldDescriptor fdXmlAnyAttribute;
    private JaxBsonName jaxBsonName;
    private JaxBsonName jaxBsonNameCfg;
    private final Set<Class<?>> referredTypes = new HashSet();
    private final Set<Method> toBsonPostMethods = new HashSet<Method>();
    private final Set<Method> toBsonPreMethods = new HashSet<Method>();
    private final Set<Method> toObjectPostMethods = new HashSet<Method>();
    private final Set<Method> toObjectPreMethods = new HashSet<Method>();
    private final Class<?> type;
    private String typeName;
    private XmlAccessorType xmlAccessorType;
    private XmlSeeAlso xmlSeeAlso;
    private XmlType xmlType;

    protected ClassDescriptor(JaxBsonContextImpl ctx, Class<?> cls) {
        this.ctx = Objects.requireNonNull(ctx, "Supplied parameter 'ctx' is null");
        this.type = Objects.requireNonNull(cls, "Supplied parameter 'cls' is null");
        this.constructor = this.makeConstructor();
        this.setXmlAnnotations();
        this.checkXmlAnnotations();
        this.setTypeName();
        this.xmlSeeAlsoToReferredTypes();
        this.index();
    }

    private void add(Collection<Method> collection, Method method) {
        this.check(method);
        method.setAccessible(true);
        collection.add(method);
    }

    private void add(FieldSubDescriptor fds) {
        if (fds.getName().equals(this.ctx.getConfiguration().getTypeFieldName())) {
            throw new IllegalStateException("Field with Bson name '" + fds.getName() + "' in class " + this.type.getName() + " is reserved for type. See JaxBsonContext.getConfiguration().getTypeFieldName()");
        }
        this.checkDuplicateNames(fds);
        this.bsonFieldNameMap.put(fds.getName(), fds.getFd());
    }

    private void check(Method method) {
        StringBuilder err = new StringBuilder();
        if (method.getParameterCount() != 0) {
            if (method.getParameterCount() == 1) {
                Class<?> parameterType = method.getParameterTypes()[0];
                if (!JaxBsonContext.class.isAssignableFrom(parameterType)) {
                    err.append("Has 1 paramter not of type ");
                    err.append(JaxBsonContext.class.getName());
                    err.append(" but of type ");
                    err.append(parameterType.getName());
                    err.append(". ");
                }
            } else {
                err.append("Has more than 1 paramter ");
                err.append(method.getParameterCount());
                err.append(". 0 or 1 parameter of type ");
                err.append(JaxBsonContext.class.getName());
                err.append(" allowed. ");
            }
        }
        if (err.length() > 0) {
            err.insert(0, "': ");
            err.insert(0, method.toString());
            err.insert(0, "Error in method '");
            throw new IllegalStateException(err.toString());
        }
    }

    private void checkDuplicateNames(FieldSubDescriptor fds) {
        FieldDescriptor dup = (FieldDescriptor)this.bsonFieldNameMap.get(fds.getName());
        if (dup != null) {
            throw new IllegalStateException("Multiple fields with Bson name '" + fds.getName() + "' in class " + this.type.getName() + ". E.g. '" + dup + "' and '" + fds + "'");
        }
    }

    private void checkXmlAnnotations() {
        if (this.xmlAccessorType == null) {
            throw new IllegalStateException("No XmlAccessorType annotation on " + this.type);
        }
        if (this.xmlAccessorType.value() != XmlAccessType.FIELD) {
            throw new IllegalStateException("No XmlAccessType isn't set to '" + XmlAccessType.FIELD + "' but to '" + this.xmlAccessorType.value() + "' in XmlAccessorType annotation on " + this.type);
        }
    }

    protected Set<Class<?>> getReferredTypes() {
        return this.referredTypes;
    }

    protected Class<?> getType() {
        return this.type;
    }

    protected String getTypeName() {
        return this.typeName;
    }

    private void index() {
        Class<?> cls = this.type;
        while (!cls.equals(Object.class)) {
            this.indexFields(cls);
            this.indexMethods(cls);
            cls = cls.getSuperclass();
        }
    }

    private void indexFields(Class<?> cls) {
        for (Field field : cls.getDeclaredFields()) {
            FieldDescriptor fd = new FieldDescriptor(this.ctx, field);
            if (!fd.getReferredTypes().isEmpty()) {
                this.referredTypes.addAll(fd.getReferredTypes());
            }
            if (fd.isXmlAnyAttribute()) {
                this.fdXmlAnyAttribute = fd;
                continue;
            }
            fd.getFieldSubDescriptors().forEach(e -> this.add((FieldSubDescriptor)e));
        }
    }

    private void indexMethods(Class<?> cls) {
        for (Method method : cls.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (this.ctx.getConfiguration().getJaxBsonToBsonPost(method) != null) {
                this.add(this.toBsonPostMethods, method);
            } else if (method.getAnnotation(JaxBsonToBsonPost.class) != null) {
                this.add(this.toBsonPostMethods, method);
            }
            if (this.ctx.getConfiguration().getJaxBsonToBsonPre(method) != null) {
                this.add(this.toBsonPreMethods, method);
            } else if (method.getAnnotation(JaxBsonToBsonPre.class) != null) {
                this.add(this.toBsonPreMethods, method);
            }
            if (this.ctx.getConfiguration().getJaxBsonToObjectPost(method) != null) {
                this.add(this.toObjectPostMethods, method);
            } else if (method.getAnnotation(JaxBsonToObjectPost.class) != null) {
                this.add(this.toObjectPostMethods, method);
            }
            if (this.ctx.getConfiguration().getJaxBsonToObjectPre(method) != null) {
                this.add(this.toObjectPreMethods, method);
                continue;
            }
            if (method.getAnnotation(JaxBsonToObjectPre.class) == null) continue;
            this.add(this.toObjectPreMethods, method);
        }
    }

    private void invoke(Method method, Object o) {
        try {
            if (method.getParameterCount() == 0) {
                method.invoke(o, new Object[0]);
            } else {
                method.invoke(o, this.ctx);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() == null) {
                throw new IllegalStateException("Unexpexted exception: " + e.getMessage(), e);
            }
            throw new IllegalStateException("Unexpexted exception: " + e.getCause().getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpexted exception: " + e.getMessage(), e);
        }
    }

    private void invokeToBsonPostMethods(Object o) {
        for (Method method : this.toBsonPostMethods) {
            this.invoke(method, o);
        }
    }

    private void invokeToBsonPreMethods(Object o) {
        for (Method method : this.toBsonPreMethods) {
            this.invoke(method, o);
        }
    }

    private void invokeToObjectPostMethods(Object o) {
        for (Method method : this.toObjectPostMethods) {
            this.invoke(method, o);
        }
    }

    private void invokeToObjectPreMethods(Object o) {
        for (Method method : this.toObjectPreMethods) {
            this.invoke(method, o);
        }
    }

    private Constructor<?> makeConstructor() {
        try {
            Constructor<?> ret = this.type.getDeclaredConstructor(new Class[0]);
            ret.setAccessible(true);
            return ret;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No no-argument constructor for type " + this.type.getName());
        }
    }

    private Object newObjectInstance() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate object of class '" + this.type.getName() + "'.", e);
        }
    }

    private void setTypeName() {
        this.typeName = this.jaxBsonNameCfg != null && !StringUtils.isBlank((CharSequence)this.jaxBsonNameCfg.name()) && !this.jaxBsonNameCfg.name().equalsIgnoreCase("##default") ? this.jaxBsonNameCfg.name() : (this.jaxBsonName != null && !StringUtils.isBlank((CharSequence)this.jaxBsonName.name()) && !this.jaxBsonName.name().equalsIgnoreCase("##default") ? this.jaxBsonName.name() : (this.xmlType != null && !StringUtils.isBlank((CharSequence)this.xmlType.name()) && !this.xmlType.name().equalsIgnoreCase("##default") ? this.xmlType.name() : Utils.lcFirst(this.type.getSimpleName())));
    }

    private void setXmlAnnotations() {
        this.jaxBsonName = this.type.getAnnotation(JaxBsonName.class);
        this.jaxBsonNameCfg = this.ctx.getConfiguration().getJaxBsonName(this.type);
        this.xmlAccessorType = this.type.getAnnotation(XmlAccessorType.class);
        this.xmlSeeAlso = this.type.getAnnotation(XmlSeeAlso.class);
        this.xmlType = this.type.getAnnotation(XmlType.class);
    }

    protected Document toBson(Object o) {
        return this.toBson(o, true);
    }

    protected Document toBson(Object o, boolean omitType) {
        this.invokeToBsonPreMethods(o);
        Document ret = new Document();
        if (!omitType || !this.ctx.getConfiguration().isAllowSmartTypeField()) {
            ret.put(this.ctx.getConfiguration().getTypeFieldName(), (Object)this.typeName);
        }
        this.bsonFieldNameMap.values().forEach(e -> e.toBson(ret, o, omitType));
        if (this.fdXmlAnyAttribute != null) {
            this.fdXmlAnyAttribute.addXmlAnyAttributes(ret, o);
        }
        this.invokeToBsonPostMethods(o);
        return ret;
    }

    protected Object toObject(Document bson) {
        Object ret = this.newObjectInstance();
        this.invokeToObjectPreMethods(ret);
        TreeMap<String, String> xmlAttributeMap = this.fdXmlAnyAttribute == null ? null : new TreeMap<String, String>();
        bson.forEach((bsonFieldName, bsonValue) -> {
            if (bsonFieldName.equals(this.ctx.getConfiguration().getTypeFieldName())) {
                return;
            }
            FieldDescriptor fd = (FieldDescriptor)this.bsonFieldNameMap.get(bsonFieldName);
            if (fd == null) {
                if (this.fdXmlAnyAttribute == null) {
                    throw new JaxBsonException.JaxBsonMappingNotFoundException("Failed to map BSON field name '" + bsonFieldName + "' in BSON " + bson.toJson());
                }
                if (bsonValue instanceof String) {
                    xmlAttributeMap.put((String)bsonFieldName, (String)bsonValue);
                    return;
                }
                throw new JaxBsonException.JaxBsonMappingNotFoundException("Failed to map BSON field name '" + bsonFieldName + "' to XmlAnyAttribute as it's value isn't a string in BSON " + bson.toJson());
            }
            fd.toObject(ret, (String)bsonFieldName, bsonValue);
        });
        if (xmlAttributeMap != null && !xmlAttributeMap.isEmpty()) {
            this.fdXmlAnyAttribute.addXmlAnyAttributes(xmlAttributeMap, ret);
        }
        this.invokeToObjectPostMethods(ret);
        return ret;
    }

    private void xmlSeeAlsoToReferredTypes() {
        if (this.xmlSeeAlso == null) {
            return;
        }
        for (Class cls : this.xmlSeeAlso.value()) {
            this.referredTypes.add(cls);
        }
    }
}

