/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.qnixyz.jbson.DateBased;
import org.qnixyz.jbson.JaxBsonConfiguration;
import org.qnixyz.jbson.JaxBsonFieldContext;
import org.qnixyz.jbson.NumberBased;
import org.qnixyz.jbson.StringBased;
import org.qnixyz.jbson.impl.FieldSubDescriptor;
import org.qnixyz.jbson.impl.JaxBsonFieldContextImpl;

class SimpleTypes {
    private static final FuncMap FUNC_MAP = new FuncMap();
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Boolean.TYPE, Binary.class, Byte.class, Byte.TYPE, Character.class, Character.TYPE, ObjectId.class));

    protected static boolean isSimpleType(JaxBsonConfiguration cfg, Class<?> type) {
        return SIMPLE_TYPES.contains(type) || Enum.class.isAssignableFrom(type) || cfg.getDateBased().getChecker().check(type) || cfg.getNumberBased().getChecker().check(type) || cfg.getStringBased().getChecker().check(type);
    }

    protected SimpleTypes() {
    }

    private String classInfo(Object o) {
        String array = o.getClass().isArray() ? "[]" : "";
        String collectionPre = Collection.class.isAssignableFrom(o.getClass()) ? "Collection<" : "";
        String collectionPost = Collection.class.isAssignableFrom(o.getClass()) ? ">" : "";
        Class<?> elementType = this.elementType(o);
        return collectionPre + elementType.getSimpleName() + collectionPost + array;
    }

    private Collection<?> createToObjectCollection(FieldSubDescriptor fds) {
        return fds.getFd().collectionInstance();
    }

    private Class<?> elementType(Object o) {
        Class<?> ret = o.getClass();
        if (ret.isArray()) {
            return ret.getComponentType();
        }
        if (Collection.class.isAssignableFrom(ret)) {
            for (Object e : (Collection)o) {
                if (e == null) continue;
                return e.getClass();
            }
            return null;
        }
        return ret;
    }

    private Class<?> getGenericType(Collection<?> o) {
        for (Object e : o) {
            if (e == null) continue;
            return e.getClass();
        }
        return null;
    }

    protected Object toBson(JaxBsonFieldContext fieldCtx, Object o) {
        if (o == null) {
            return null;
        }
        Class<?> cls = o.getClass();
        if (cls.isArray()) {
            Class<?> mainType = cls.getComponentType();
            FuncMap.FuncToBson func = SimpleTypes.FUNC_MAP.getArrayToBson(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("Failed to convert array of " + mainType.getName() + " to Bson: " + o);
        }
        if (Collection.class.isAssignableFrom(cls)) {
            Class<?> mainType = this.getGenericType((Collection)o);
            if (mainType == null) {
                return Collections.EMPTY_LIST;
            }
            FuncMap.FuncToBson func = SimpleTypes.FUNC_MAP.getCollectionToBson(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("Failed to convert collection of " + mainType.getName() + " to Bson.");
        }
        Class<?> mainType = cls;
        FuncMap.FuncToBson func = SimpleTypes.FUNC_MAP.getToBson(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("Failed to convert object of " + mainType.getName() + " to Bson.");
    }

    protected Object toObject(FieldSubDescriptor fds, Object o) {
        Objects.requireNonNull(fds, "Supplied parameter 'fds' is null");
        if (o == null) {
            return null;
        }
        if (!fds.isSimpleType()) {
            throw new IllegalArgumentException("Supplied parameter 'fds' is not of a simple type: " + fds);
        }
        Class<?> srcClass = o.getClass();
        Class<?> elementType = this.elementType(o);
        if (elementType == null) {
            return null;
        }
        if (Binary.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectBinary(fds, (Collection)o);
            }
            return this.toObjectBinary(fds, (Binary)o);
        }
        if (Boolean.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectBoolean(fds, (Collection)o);
            }
            return this.toObjectBoolean(fds, (Boolean)o);
        }
        if (Date.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectDate(fds, (Collection)o);
            }
            return this.toObjectDate(fds, (Date)o);
        }
        if (!Byte.class.isAssignableFrom(elementType) && Number.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectNumber(fds, (Collection)o);
            }
            return this.toObjectNumber(fds, (Number)o);
        }
        if (ObjectId.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectObjectId(fds, (Collection)o);
            }
            return this.toObjectObjectId(fds, (ObjectId)o);
        }
        if (String.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectString(fds, (Collection)o);
            }
            return this.toObjectString(fds, (String)o);
        }
        throw new IllegalStateException("Unsupperted conversion from " + this.classInfo(o) + " to field " + fds);
    }

    private Object toObjectBinary(FieldSubDescriptor fds, Binary o) {
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        Class<?> mainType = fds.getMainType();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getBinaryToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getBinaryToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getBinaryToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectBinary(FieldSubDescriptor fds, Collection<Binary> o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getBinaryCollectionToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of binary to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getBinaryCollectionToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of binary to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getBinaryCollectionToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert collection of binary to " + mainType.getName());
    }

    private Object toObjectBoolean(FieldSubDescriptor fds, Boolean o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getBooleanToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert boolean to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getBooleanToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert boolean to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getBooleanToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert boolean to " + mainType.getName());
    }

    private Object toObjectBoolean(FieldSubDescriptor fds, Collection<Boolean> o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getBooleanCollectionToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of boolean to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getBooleanCollectionToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of boolean to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getBooleanCollectionToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert collection of boolean to " + mainType.getName());
    }

    private Object toObjectDate(FieldSubDescriptor fds, Collection<Date> o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getDateCollectionToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of date to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getDateCollectionToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of date to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getDateCollectionToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert collection of date to " + mainType.getName());
    }

    private Object toObjectDate(FieldSubDescriptor fds, Date o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getDateToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert date to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getDateToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert date to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getDateToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert date to " + mainType.getName());
    }

    private Object toObjectNumber(FieldSubDescriptor fds, Collection<Number> o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getNumberCollectionToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of number to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getNumberCollectionToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of number to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getNumberCollectionToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert collection of number to " + mainType.getName());
    }

    private Object toObjectNumber(FieldSubDescriptor fds, Number o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getNumberToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert number to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getNumberToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert number to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getNumberToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert number to " + mainType.getName());
    }

    private Object toObjectObjectId(FieldSubDescriptor fds, Collection<ObjectId> o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getObjectIdCollectionToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of object-id to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getObjectIdCollectionToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of object-id to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getObjectIdCollectionToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert collection of object-id to " + mainType.getName());
    }

    private Object toObjectObjectId(FieldSubDescriptor fds, ObjectId o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getObjectIdToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert object-id to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getObjectIdToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert object-id to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getObjectIdToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert object-id to " + mainType.getName());
    }

    private Object toObjectString(FieldSubDescriptor fds, Collection<String> o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getStringCollectionToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of string to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getStringCollectionToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert collection of string to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getStringCollectionToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert collection of string to " + mainType.getName());
    }

    private Object toObjectString(FieldSubDescriptor fds, String o) {
        Class<?> mainType = fds.getMainType();
        JaxBsonFieldContextImpl fieldCtx = fds.getFd().getFieldCtx();
        if (fds.isArray()) {
            FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getStringToObjectArray(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o);
            }
            throw new IllegalStateException("This is a bug. No function found to convert string to array of " + mainType.getName());
        }
        if (fds.isCollection()) {
            FuncMap.FuncToObjectCollection func = SimpleTypes.FUNC_MAP.getStringToObjectCollection(mainType);
            if (func != null) {
                return func.convert(fieldCtx, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug. No function found to convert string to collection of " + mainType.getName());
        }
        FuncMap.FuncToObject func = SimpleTypes.FUNC_MAP.getStringToObject(mainType);
        if (func != null) {
            return func.convert(fieldCtx, mainType, o);
        }
        throw new IllegalStateException("This is a bug. No function found to convert string to " + mainType.getName());
    }

    private static class FuncMap {
        private final Map<Class<?>, FuncToBson> arrayToBsonMap = new HashMap();
        private final Map<Class<?>, FuncToObject> binaryCollectionToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> binaryCollectionToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> binaryCollectionToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToObject> binaryToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> binaryToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> binaryToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToObject> booleanCollectionToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> booleanCollectionToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> booleanCollectionToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToObject> booleanToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> booleanToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> booleanToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToBson> collectionToBsonMap = new HashMap();
        private final Map<Class<?>, FuncToObject> dateCollectionToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> dateCollectionToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> dateCollectionToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToObject> dateToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> dateToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> dateToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToObject> numberCollectionToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> numberCollectionToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> numberCollectionToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToObject> numberToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> numberToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> numberToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToObject> objectIdCollectionToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> objectIdCollectionToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> objectIdCollectionToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToObject> objectIdToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> objectIdToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> objectIdToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToObject> stringCollectionToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> stringCollectionToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> stringCollectionToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToObject> stringToObjectArrayMap = new HashMap();
        private final Map<Class<?>, FuncToObjectCollection> stringToObjectCollectionMap = new HashMap();
        private final Map<Class<?>, FuncToObject> stringToObjectMap = new HashMap();
        private final Map<Class<?>, FuncToBson> toBsonMap = new HashMap();

        private FuncMap() {
            this.putToBsonMap();
            this.putArrayToBsonMap();
            this.putCollectionToBsonMap();
            this.putBinaryToObjectMap();
            this.putBinaryToObjectArrayMap();
            this.putBinaryToObjectCollectionMap();
            this.putBinaryCollectionToObjectMap();
            this.putBinaryCollectionToObjectArrayMap();
            this.putBinaryCollectionToObjectCollectionMap();
            this.putBooleanToObjectMap();
            this.putBooleanToObjectArrayMap();
            this.putBooleanToObjectCollectionMap();
            this.putBooleanCollectionToObjectMap();
            this.putBooleanCollectionToObjectArrayMap();
            this.putBooleanCollectionToObjectCollectionMap();
            this.putDateToObjectMap();
            this.putDateToObjectArrayMap();
            this.putDateToObjectCollectionMap();
            this.putDateCollectionToObjectMap();
            this.putDateCollectionToObjectArrayMap();
            this.putDateCollectionToObjectCollectionMap();
            this.putNumberToObjectMap();
            this.putNumberToObjectArrayMap();
            this.putNumberToObjectCollectionMap();
            this.putNumberCollectionToObjectMap();
            this.putNumberCollectionToObjectArrayMap();
            this.putNumberCollectionToObjectCollectionMap();
            this.putObjectIdToObjectMap();
            this.putObjectIdToObjectArrayMap();
            this.putObjectIdToObjectCollectionMap();
            this.putObjectIdCollectionToObjectMap();
            this.putObjectIdCollectionToObjectArrayMap();
            this.putObjectIdCollectionToObjectCollectionMap();
            this.putStringToObjectMap();
            this.putStringToObjectArrayMap();
            this.putStringToObjectCollectionMap();
            this.putStringCollectionToObjectMap();
            this.putStringCollectionToObjectArrayMap();
            this.putStringCollectionToObjectCollectionMap();
        }

        private FuncToBson getArrayToBson(Class<?> type) {
            FuncToBson ret = this.arrayToBsonMap.get(type);
            if (ret != null) {
                return ret;
            }
            ret = this.getArrayToBsonDateBased(type);
            if (ret != null) {
                return ret;
            }
            ret = this.getArrayToBsonStringBased(type);
            if (ret != null) {
                return ret;
            }
            return this.getArrayToBsonEnum(type);
        }

        private synchronized FuncToBson getArrayToBsonDateBased(Class<?> type) {
            for (Class<?> dateBasedType : DateBased.TYPES_SET) {
                if (!dateBasedType.isAssignableFrom(type)) continue;
                FuncToBson ret = this.arrayToBsonMap.get(dateBasedType);
                this.arrayToBsonMap.put(type, ret);
                return ret;
            }
            return null;
        }

        private synchronized FuncToBson getArrayToBsonEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToBson ret = this.arrayToBsonMap.get(Enum.class);
            this.arrayToBsonMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToBson getArrayToBsonStringBased(Class<?> type) {
            for (Class<?> stringBasedType : StringBased.TYPES_SET) {
                if (!stringBasedType.isAssignableFrom(type)) continue;
                FuncToBson ret = this.arrayToBsonMap.get(stringBasedType);
                this.arrayToBsonMap.put(type, ret);
                return ret;
            }
            return null;
        }

        private FuncToObject getBinaryCollectionToObject(Class<?> type) {
            FuncToObject ret = this.binaryCollectionToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBinaryCollectionToObjectEnum(type);
        }

        private FuncToObject getBinaryCollectionToObjectArray(Class<?> type) {
            FuncToObject ret = this.binaryCollectionToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBinaryCollectionToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getBinaryCollectionToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.binaryCollectionToObjectArrayMap.get(Enum.class);
            this.binaryCollectionToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getBinaryCollectionToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.binaryCollectionToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBinaryCollectionToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getBinaryCollectionToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.binaryCollectionToObjectCollectionMap.get(Enum.class);
            this.binaryCollectionToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getBinaryCollectionToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.binaryCollectionToObjectMap.get(Enum.class);
            this.binaryCollectionToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToObject getBinaryToObject(Class<?> type) {
            FuncToObject ret = this.binaryToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBinaryToObjectEnum(type);
        }

        private FuncToObject getBinaryToObjectArray(Class<?> type) {
            FuncToObject ret = this.binaryToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBinaryToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getBinaryToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.binaryToObjectArrayMap.get(Enum.class);
            this.binaryToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getBinaryToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.binaryToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBinaryToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getBinaryToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.binaryToObjectCollectionMap.get(Enum.class);
            this.binaryToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getBinaryToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.binaryToObjectMap.get(Enum.class);
            this.binaryToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToObject getBooleanCollectionToObject(Class<?> type) {
            FuncToObject ret = this.booleanCollectionToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBooleanCollectionToObjectEnum(type);
        }

        private FuncToObject getBooleanCollectionToObjectArray(Class<?> type) {
            FuncToObject ret = this.booleanCollectionToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBooleanCollectionToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getBooleanCollectionToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.booleanCollectionToObjectArrayMap.get(Enum.class);
            this.booleanCollectionToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getBooleanCollectionToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.booleanCollectionToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBooleanCollectionToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getBooleanCollectionToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.booleanCollectionToObjectCollectionMap.get(Enum.class);
            this.booleanCollectionToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getBooleanCollectionToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.booleanCollectionToObjectMap.get(Enum.class);
            this.booleanCollectionToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToObject getBooleanToObject(Class<?> type) {
            FuncToObject ret = this.booleanToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBooleanToObjectEnum(type);
        }

        private FuncToObject getBooleanToObjectArray(Class<?> type) {
            FuncToObject ret = this.dateToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBooleanToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getBooleanToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.dateToObjectArrayMap.get(Enum.class);
            this.dateToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getBooleanToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.booleanToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getBooleanToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getBooleanToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.booleanToObjectCollectionMap.get(Enum.class);
            this.booleanToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getBooleanToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.booleanToObjectMap.get(Enum.class);
            this.booleanToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToBson getCollectionToBson(Class<?> type) {
            FuncToBson ret = this.collectionToBsonMap.get(type);
            if (ret != null) {
                return ret;
            }
            ret = this.getCollectionToBsonDateBased(type);
            if (ret != null) {
                return ret;
            }
            ret = this.getCollectionToBsonStringBased(type);
            if (ret != null) {
                return ret;
            }
            return this.getCollectionToBsonEnum(type);
        }

        private synchronized FuncToBson getCollectionToBsonDateBased(Class<?> type) {
            for (Class<?> dateBasedType : DateBased.TYPES_SET) {
                if (!dateBasedType.isAssignableFrom(type)) continue;
                FuncToBson ret = this.collectionToBsonMap.get(dateBasedType);
                this.collectionToBsonMap.put(type, ret);
                return ret;
            }
            return null;
        }

        private synchronized FuncToBson getCollectionToBsonEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToBson ret = this.collectionToBsonMap.get(Enum.class);
            this.collectionToBsonMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToBson getCollectionToBsonStringBased(Class<?> type) {
            for (Class<?> stringBasedType : StringBased.TYPES_SET) {
                if (!stringBasedType.isAssignableFrom(type)) continue;
                FuncToBson ret = this.collectionToBsonMap.get(stringBasedType);
                this.collectionToBsonMap.put(type, ret);
                return ret;
            }
            return null;
        }

        private FuncToObject getDateCollectionToObject(Class<?> type) {
            FuncToObject ret = this.dateCollectionToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getDateCollectionToObjectEnum(type);
        }

        private FuncToObject getDateCollectionToObjectArray(Class<?> type) {
            FuncToObject ret = this.dateCollectionToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getDateCollectionToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getDateCollectionToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.dateCollectionToObjectArrayMap.get(Enum.class);
            this.dateCollectionToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getDateCollectionToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.dateCollectionToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getDateCollectionToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getDateCollectionToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.dateCollectionToObjectCollectionMap.get(Enum.class);
            this.dateCollectionToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getDateCollectionToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.dateCollectionToObjectMap.get(Enum.class);
            this.dateCollectionToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToObject getDateToObject(Class<?> type) {
            FuncToObject ret = this.dateToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getDateToObjectEnum(type);
        }

        private FuncToObject getDateToObjectArray(Class<?> type) {
            FuncToObject ret = this.booleanToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getDateToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getDateToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.booleanToObjectArrayMap.get(Enum.class);
            this.booleanToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getDateToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.dateToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getDateToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getDateToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.dateToObjectCollectionMap.get(Enum.class);
            this.dateToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getDateToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.dateToObjectMap.get(Enum.class);
            this.dateToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToObject getNumberCollectionToObject(Class<?> type) {
            FuncToObject ret = this.numberCollectionToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getNumberCollectionToObjectEnum(type);
        }

        private FuncToObject getNumberCollectionToObjectArray(Class<?> type) {
            FuncToObject ret = this.numberCollectionToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getNumberCollectionToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getNumberCollectionToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.numberCollectionToObjectArrayMap.get(Enum.class);
            this.numberCollectionToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getNumberCollectionToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.numberCollectionToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getNumberCollectionToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getNumberCollectionToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.numberCollectionToObjectCollectionMap.get(Enum.class);
            this.numberCollectionToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getNumberCollectionToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.numberCollectionToObjectMap.get(Enum.class);
            this.numberCollectionToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToObject getNumberToObject(Class<?> type) {
            FuncToObject ret = this.numberToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getNumberToObjectEnum(type);
        }

        private FuncToObject getNumberToObjectArray(Class<?> type) {
            FuncToObject ret = this.numberToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getNumberToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getNumberToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.numberToObjectArrayMap.get(Enum.class);
            this.numberToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getNumberToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.numberToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getNumberToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getNumberToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.numberToObjectCollectionMap.get(Enum.class);
            this.numberToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getNumberToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.numberToObjectMap.get(Enum.class);
            this.numberToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToObject getObjectIdCollectionToObject(Class<?> type) {
            FuncToObject ret = this.objectIdCollectionToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getObjectIdCollectionToObjectEnum(type);
        }

        private FuncToObject getObjectIdCollectionToObjectArray(Class<?> type) {
            FuncToObject ret = this.objectIdCollectionToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getObjectIdCollectionToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getObjectIdCollectionToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.objectIdCollectionToObjectArrayMap.get(Enum.class);
            this.objectIdCollectionToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getObjectIdCollectionToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.objectIdCollectionToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getObjectIdCollectionToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getObjectIdCollectionToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.objectIdCollectionToObjectCollectionMap.get(Enum.class);
            this.objectIdCollectionToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getObjectIdCollectionToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.objectIdCollectionToObjectMap.get(Enum.class);
            this.objectIdCollectionToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToObject getObjectIdToObject(Class<?> type) {
            FuncToObject ret = this.objectIdToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getObjectIdToObjectEnum(type);
        }

        private FuncToObject getObjectIdToObjectArray(Class<?> type) {
            FuncToObject ret = this.objectIdToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getObjectIdToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getObjectIdToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.objectIdToObjectArrayMap.get(Enum.class);
            this.objectIdToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getObjectIdToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.objectIdToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getObjectIdToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getObjectIdToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.objectIdToObjectCollectionMap.get(Enum.class);
            this.objectIdToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getObjectIdToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.objectIdToObjectMap.get(Enum.class);
            this.objectIdToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToObject getStringCollectionToObject(Class<?> type) {
            FuncToObject ret = this.stringCollectionToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getStringCollectionToObjectEnum(type);
        }

        private FuncToObject getStringCollectionToObjectArray(Class<?> type) {
            FuncToObject ret = this.stringCollectionToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getStringCollectionToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getStringCollectionToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.stringCollectionToObjectArrayMap.get(Enum.class);
            this.stringCollectionToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getStringCollectionToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.stringCollectionToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getStringCollectionToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getStringCollectionToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.stringCollectionToObjectCollectionMap.get(Enum.class);
            this.stringCollectionToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getStringCollectionToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.stringCollectionToObjectMap.get(Enum.class);
            this.stringCollectionToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToObject getStringToObject(Class<?> type) {
            FuncToObject ret = this.stringToObjectMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getStringToObjectEnum(type);
        }

        private FuncToObject getStringToObjectArray(Class<?> type) {
            FuncToObject ret = this.stringToObjectArrayMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getStringToObjectArrayEnum(type);
        }

        private synchronized FuncToObject getStringToObjectArrayEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.stringToObjectArrayMap.get(Enum.class);
            this.stringToObjectArrayMap.put(type, ret);
            return ret;
        }

        private FuncToObjectCollection getStringToObjectCollection(Class<?> type) {
            FuncToObjectCollection ret = this.stringToObjectCollectionMap.get(type);
            if (ret != null) {
                return ret;
            }
            return this.getStringToObjectCollectionEnum(type);
        }

        private synchronized FuncToObjectCollection getStringToObjectCollectionEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObjectCollection ret = this.stringToObjectCollectionMap.get(Enum.class);
            this.stringToObjectCollectionMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToObject getStringToObjectEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToObject ret = this.stringToObjectMap.get(Enum.class);
            this.stringToObjectMap.put(type, ret);
            return ret;
        }

        private FuncToBson getToBson(Class<?> type) {
            FuncToBson ret = this.toBsonMap.get(type);
            if (ret != null) {
                return ret;
            }
            ret = this.getToBsonDateBased(type);
            if (ret != null) {
                return ret;
            }
            ret = this.getToBsonStringBased(type);
            if (ret != null) {
                return ret;
            }
            return this.getToBsonEnum(type);
        }

        private synchronized FuncToBson getToBsonDateBased(Class<?> type) {
            for (Class<?> dateBasedType : DateBased.TYPES_SET) {
                if (!dateBasedType.isAssignableFrom(type)) continue;
                FuncToBson ret = this.toBsonMap.get(dateBasedType);
                this.toBsonMap.put(type, ret);
                return ret;
            }
            return null;
        }

        private synchronized FuncToBson getToBsonEnum(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            FuncToBson ret = this.toBsonMap.get(Enum.class);
            this.toBsonMap.put(type, ret);
            return ret;
        }

        private synchronized FuncToBson getToBsonStringBased(Class<?> type) {
            for (Class<?> stringBasedType : StringBased.TYPES_SET) {
                if (!stringBasedType.isAssignableFrom(type)) continue;
                FuncToBson ret = this.toBsonMap.get(stringBasedType);
                this.toBsonMap.put(type, ret);
                return ret;
            }
            return null;
        }

        private void putArrayToBsonMap() {
            this.arrayToBsonMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getBooleanPrimArrayToBson().convert(fieldCtx, (boolean[])o));
            this.arrayToBsonMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getBooleanArrayToBson().convert(fieldCtx, (Boolean[])o));
            this.arrayToBsonMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getBytePrimArrayToBson().convert(fieldCtx, (byte[])o));
            this.arrayToBsonMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getByteArrayToBson().convert(fieldCtx, (Byte[])o));
            this.arrayToBsonMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getCharacterPrimArrayToBson().convert(fieldCtx, (char[])o));
            this.arrayToBsonMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getCharacterArrayToBson().convert(fieldCtx, (Character[])o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.arrayToBsonMap.put(type, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getDateBasedArrayToBson().convert(fieldCtx, (Object[])o));
            }
            this.arrayToBsonMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToBson().getEnumArrayToBson().convert(fieldCtx, mainType, (Enum[])o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.arrayToBsonMap.put(type, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getNumberBasedArrayToBson().convert(fieldCtx, (Object[])o));
            }
            this.arrayToBsonMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getDoublePrimArrayToBson().convert(fieldCtx, (double[])o));
            this.arrayToBsonMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getFloatPrimArrayToBson().convert(fieldCtx, (float[])o));
            this.arrayToBsonMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getIntegerPrimArrayToBson().convert(fieldCtx, (int[])o));
            this.arrayToBsonMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getLongPrimArrayToBson().convert(fieldCtx, (long[])o));
            this.arrayToBsonMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getShortPrimArrayToBson().convert(fieldCtx, (short[])o));
            this.arrayToBsonMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getObjectIdArrayToBson().convert(fieldCtx, (ObjectId[])o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.arrayToBsonMap.put(type, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getStringBasedArrayToBson().convert(fieldCtx, (Object[])o));
            }
        }

        private void putBinaryCollectionToObjectArrayMap() {
            this.binaryCollectionToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToBinaryArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToBooleanArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToBooleanPrimArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToByteArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToBytePrimArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToCharacterArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToCharacterPrimArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.binaryCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToDateBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.binaryCollectionToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToEnumArray().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.binaryCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToNumberBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.binaryCollectionToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToDoublePrimArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToFloatPrimArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToIntegerPrimArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToLongPrimArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToShortPrimArray().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToObjectIdArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.binaryCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToStringBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putBinaryCollectionToObjectCollectionMap() {
            this.binaryCollectionToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToBinaryCollection().convert(fieldCtx, (Collection)src, dst));
            this.binaryCollectionToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToBooleanCollection().convert(fieldCtx, (Collection)src, dst));
            this.binaryCollectionToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToByteCollection().convert(fieldCtx, (Collection)src, dst));
            this.binaryCollectionToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToCharacterCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.binaryCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToDateBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.binaryCollectionToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToEnumCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.binaryCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToNumberBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.binaryCollectionToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToObjectIdCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.binaryCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToStringBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
        }

        private void putBinaryCollectionToObjectMap() {
            this.binaryCollectionToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToBinary().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToBoolean().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToBooleanPrim().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToByte().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToBytePrim().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToCharacter().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getBinaryCollectionToCharacterPrim().convert(fieldCtx, (Collection)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.binaryCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToDateBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.binaryCollectionToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToEnum().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.binaryCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToNumberBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.binaryCollectionToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToDoublePrim().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getBinaryCollectionToFloatPrim().convert(fieldCtx, (Collection)o)));
            this.binaryCollectionToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToIntegerPrim().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToLongPrim().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToShortPrim().convert(fieldCtx, (Collection)o));
            this.binaryCollectionToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToObjectId().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.binaryCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryCollectionToStringBased().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putBinaryToObjectArrayMap() {
            this.binaryToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToBinaryArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToBooleanArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToBooleanPrimArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToByteArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToBytePrimArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToCharacterArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToCharacterPrimArray().convert(fieldCtx, (Binary)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.binaryToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToDateBasedArray().convert(fieldCtx, mainType, (Binary)o));
            }
            this.binaryToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToEnumArray().convert(fieldCtx, mainType, (Binary)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.binaryToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToNumberBasedArray().convert(fieldCtx, mainType, (Binary)o));
            }
            this.binaryToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToDoublePrimArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToFloatPrimArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToIntegerPrimArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToLongPrimArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToShortPrimArray().convert(fieldCtx, (Binary)o));
            this.binaryToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToObjectIdArray().convert(fieldCtx, (Binary)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.binaryToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToStringBasedArray().convert(fieldCtx, mainType, (Binary)o));
            }
        }

        private void putBinaryToObjectCollectionMap() {
            this.binaryToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryToBinaryCollection().convert(fieldCtx, (Binary)src, dst));
            this.binaryToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryToBooleanCollection().convert(fieldCtx, (Binary)src, dst));
            this.binaryToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryToByteCollection().convert(fieldCtx, (Binary)src, dst));
            this.binaryToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryToCharacterCollection().convert(fieldCtx, (Binary)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.binaryToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryToDateBasedCollection().convert(fieldCtx, mainType, (Binary)src, dst));
            }
            this.binaryToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryToEnumCollection().convert(fieldCtx, mainType, (Binary)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.binaryToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryToNumberBasedCollection().convert(fieldCtx, mainType, (Binary)src, dst));
            }
            this.binaryToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryToObjectIdCollection().convert(fieldCtx, (Binary)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.binaryToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBinaryToStringBasedCollection().convert(fieldCtx, mainType, (Binary)src, dst));
            }
        }

        private void putBinaryToObjectMap() {
            this.binaryToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToBinary().convert(fieldCtx, (Binary)o));
            this.binaryToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToBoolean().convert(fieldCtx, (Binary)o));
            this.binaryToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToBooleanPrim().convert(fieldCtx, (Binary)o));
            this.binaryToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToByte().convert(fieldCtx, (Binary)o));
            this.binaryToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToBytePrim().convert(fieldCtx, (Binary)o));
            this.binaryToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToCharacter().convert(fieldCtx, (Binary)o));
            this.binaryToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getBinaryToCharacterPrim().convert(fieldCtx, (Binary)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.binaryToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToDateBased().convert(fieldCtx, mainType, (Binary)o));
            }
            this.binaryToObjectMap.put(Enum.class, (fieldCtx, enumType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToEnum().convert(fieldCtx, enumType, (Binary)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.binaryToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToNumberBased().convert(fieldCtx, mainType, (Binary)o));
            }
            this.binaryToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToDoublePrim().convert(fieldCtx, (Binary)o));
            this.binaryToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getBinaryToFloatPrim().convert(fieldCtx, (Binary)o)));
            this.binaryToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToIntegerPrim().convert(fieldCtx, (Binary)o));
            this.binaryToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToLongPrim().convert(fieldCtx, (Binary)o));
            this.binaryToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToShortPrim().convert(fieldCtx, (Binary)o));
            this.binaryToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToObjectId().convert(fieldCtx, (Binary)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.binaryToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBinaryToStringBased().convert(fieldCtx, mainType, (Binary)o));
            }
        }

        private void putBooleanCollectionToObjectArrayMap() {
            this.booleanCollectionToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToBinaryArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToBooleanArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToBooleanPrimArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToByteArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToBytePrimArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToCharacterArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToCharacterPrimArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.booleanCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToDateBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.booleanCollectionToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToEnumArray().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.booleanCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToNumberBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.booleanCollectionToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToDoublePrimArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToFloatPrimArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToIntegerPrimArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToLongPrimArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToShortPrimArray().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToObjectIdArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.booleanCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToStringBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putBooleanCollectionToObjectCollectionMap() {
            this.booleanCollectionToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToBinaryCollection().convert(fieldCtx, (Collection)src, dst));
            this.booleanCollectionToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToBooleanCollection().convert(fieldCtx, (Collection)src, dst));
            this.booleanCollectionToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToByteCollection().convert(fieldCtx, (Collection)src, dst));
            this.booleanCollectionToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToCharacterCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.booleanCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToDateBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.booleanCollectionToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToEnumCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.booleanCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToNumberBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.booleanCollectionToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToObjectIdCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.booleanCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToStringBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
        }

        private void putBooleanCollectionToObjectMap() {
            this.booleanCollectionToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToBinary().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToBoolean().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToBooleanPrim().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToByte().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToBytePrim().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToCharacter().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getBooleanCollectionToCharacterPrim().convert(fieldCtx, (Collection)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.booleanCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToDateBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.booleanCollectionToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToEnum().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.booleanCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToNumberBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.booleanCollectionToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToDoublePrim().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getBooleanCollectionToFloatPrim().convert(fieldCtx, (Collection)o)));
            this.booleanCollectionToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToIntegerPrim().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToLongPrim().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToShortPrim().convert(fieldCtx, (Collection)o));
            this.booleanCollectionToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToObjectId().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.booleanCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanCollectionToStringBased().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putBooleanToObjectArrayMap() {
            this.dateToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToBinaryArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToBooleanArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToBooleanPrimArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToByteArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToBytePrimArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToCharacterArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToCharacterPrimArray().convert(fieldCtx, (Boolean)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.dateToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToDateBasedArray().convert(fieldCtx, mainType, (Boolean)o));
            }
            this.dateToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToEnumArray().convert(fieldCtx, mainType, (Boolean)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.dateToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToNumberBasedArray().convert(fieldCtx, mainType, (Boolean)o));
            }
            this.dateToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToDoublePrimArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToFloatPrimArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToIntegerPrimArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToLongPrimArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToShortPrimArray().convert(fieldCtx, (Boolean)o));
            this.dateToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToObjectIdArray().convert(fieldCtx, (Boolean)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.booleanToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToStringBasedArray().convert(fieldCtx, mainType, (Boolean)o));
            }
        }

        private void putBooleanToObjectCollectionMap() {
            this.booleanToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanToBinaryCollection().convert(fieldCtx, (Boolean)src, dst));
            this.booleanToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanToBooleanCollection().convert(fieldCtx, (Boolean)src, dst));
            this.booleanToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanToByteCollection().convert(fieldCtx, (Boolean)src, dst));
            this.booleanToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanToCharacterCollection().convert(fieldCtx, (Boolean)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.booleanToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanToDateBasedCollection().convert(fieldCtx, mainType, (Boolean)src, dst));
            }
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.booleanToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanToNumberBasedCollection().convert(fieldCtx, mainType, (Boolean)src, dst));
            }
            this.booleanToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanToEnumCollection().convert(fieldCtx, mainType, (Boolean)src, dst));
            this.booleanToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanToObjectIdCollection().convert(fieldCtx, (Boolean)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.booleanToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getBooleanToStringBasedCollection().convert(fieldCtx, mainType, (Boolean)src, dst));
            }
        }

        private void putBooleanToObjectMap() {
            this.booleanToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToBinary().convert(fieldCtx, (Boolean)o));
            this.booleanToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToBoolean().convert(fieldCtx, (Boolean)o));
            this.booleanToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToBooleanPrim().convert(fieldCtx, (Boolean)o));
            this.booleanToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToByte().convert(fieldCtx, (Boolean)o));
            this.booleanToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToBytePrim().convert(fieldCtx, (Boolean)o));
            this.booleanToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToCharacter().convert(fieldCtx, (Boolean)o));
            this.booleanToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getBooleanToCharacterPrim().convert(fieldCtx, (Boolean)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.booleanToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToDateBased().convert(fieldCtx, mainType, (Boolean)o));
            }
            this.booleanToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToEnum().convert(fieldCtx, mainType, (Boolean)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.booleanToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToNumberBased().convert(fieldCtx, mainType, (Boolean)o));
            }
            this.booleanToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToDoublePrim().convert(fieldCtx, (Boolean)o));
            this.booleanToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getBooleanToFloatPrim().convert(fieldCtx, (Boolean)o)));
            this.booleanToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToIntegerPrim().convert(fieldCtx, (Boolean)o));
            this.booleanToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToLongPrim().convert(fieldCtx, (Boolean)o));
            this.booleanToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToShortPrim().convert(fieldCtx, (Boolean)o));
            this.booleanToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToObjectId().convert(fieldCtx, (Boolean)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.booleanToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getBooleanToStringBased().convert(fieldCtx, mainType, (Boolean)o));
            }
        }

        private void putCollectionToBsonMap() {
            this.collectionToBsonMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getBinaryCollectionToBson().convert(fieldCtx, (Collection)o));
            this.collectionToBsonMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getBooleanCollectionToBson().convert(fieldCtx, (Collection)o));
            this.collectionToBsonMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getByteCollectionToBson().convert(fieldCtx, (Collection)o));
            this.collectionToBsonMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getCharacterCollectionToBson().convert(fieldCtx, (Collection)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.collectionToBsonMap.put(type, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getDateBasedCollectionToBson().convert(fieldCtx, (Collection)o));
            }
            this.collectionToBsonMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToBson().getEnumCollectionToBson().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.collectionToBsonMap.put(type, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getNumberBasedCollectionToBson().convert(fieldCtx, (Collection)o));
            }
            this.collectionToBsonMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getObjectIdCollectionToBson().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.collectionToBsonMap.put(type, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getStringBasedCollectionToBson().convert(fieldCtx, (Collection)o));
            }
        }

        private void putDateCollectionToObjectArrayMap() {
            this.dateCollectionToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToBinaryArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToBooleanArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToBooleanPrimArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToByteArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToBytePrimArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToCharacterArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToCharacterPrimArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.dateCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToDateBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.dateCollectionToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToEnumArray().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.dateCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToNumberBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.dateCollectionToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToDoublePrimArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToFloatPrimArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToIntegerPrimArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToLongPrimArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToShortPrimArray().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToObjectIdArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.dateCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToStringBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putDateCollectionToObjectCollectionMap() {
            this.dateCollectionToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToBinaryCollection().convert(fieldCtx, (Collection)src, dst));
            this.dateCollectionToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToBooleanCollection().convert(fieldCtx, (Collection)src, dst));
            this.dateCollectionToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToByteCollection().convert(fieldCtx, (Collection)src, dst));
            this.dateCollectionToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToCharacterCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.dateCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToDateBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.dateCollectionToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToEnumCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.dateCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToNumberBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.dateCollectionToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToObjectIdCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.dateCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToStringBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
        }

        private void putDateCollectionToObjectMap() {
            this.dateCollectionToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToBinary().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToBoolean().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToBooleanPrim().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToByte().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToBytePrim().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToCharacter().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getDateCollectionToCharacterPrim().convert(fieldCtx, (Collection)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.dateCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToDateBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.dateCollectionToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToEnum().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.dateCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToNumberBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.dateCollectionToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToDoublePrim().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getDateCollectionToFloatPrim().convert(fieldCtx, (Collection)o)));
            this.dateCollectionToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToIntegerPrim().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToLongPrim().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToShortPrim().convert(fieldCtx, (Collection)o));
            this.dateCollectionToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToObjectId().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.dateCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateCollectionToStringBased().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putDateToObjectArrayMap() {
            this.booleanToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToBinaryArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToBooleanArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToBooleanPrimArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToByteArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToBytePrimArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToCharacterArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToCharacterPrimArray().convert(fieldCtx, (Date)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.booleanToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateToDateBasedArray().convert(fieldCtx, mainType, (Date)o));
            }
            this.booleanToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateToEnumArray().convert(fieldCtx, mainType, (Date)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.booleanToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateToNumberBasedArray().convert(fieldCtx, mainType, (Date)o));
            }
            this.booleanToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToDoublePrimArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToFloatPrimArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToIntegerPrimArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToLongPrimArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToShortPrimArray().convert(fieldCtx, (Date)o));
            this.booleanToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToObjectIdArray().convert(fieldCtx, (Date)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.booleanToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateToStringBasedArray().convert(fieldCtx, mainType, (Date)o));
            }
        }

        private void putDateToObjectCollectionMap() {
            this.dateToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateToBinaryCollection().convert(fieldCtx, (Date)src, dst));
            this.dateToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateToBooleanCollection().convert(fieldCtx, (Date)src, dst));
            this.dateToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateToByteCollection().convert(fieldCtx, (Date)src, dst));
            this.dateToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateToCharacterCollection().convert(fieldCtx, (Date)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.dateToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateToDateBasedCollection().convert(fieldCtx, mainType, (Date)src, dst));
            }
            this.dateToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateToEnumCollection().convert(fieldCtx, mainType, (Date)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.dateToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateToNumberBasedCollection().convert(fieldCtx, mainType, (Date)src, dst));
            }
            this.dateToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateToObjectIdCollection().convert(fieldCtx, (Date)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.dateToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getDateToStringBasedCollection().convert(fieldCtx, mainType, (Date)src, dst));
            }
        }

        private void putDateToObjectMap() {
            this.dateToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToBinary().convert(fieldCtx, (Date)o));
            this.dateToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToBoolean().convert(fieldCtx, (Date)o));
            this.dateToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToBooleanPrim().convert(fieldCtx, (Date)o));
            this.dateToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToByte().convert(fieldCtx, (Date)o));
            this.dateToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToBytePrim().convert(fieldCtx, (Date)o));
            this.dateToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToCharacter().convert(fieldCtx, (Date)o));
            this.dateToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getDateToCharacterPrim().convert(fieldCtx, (Date)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.dateToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateToDateBased().convert(fieldCtx, mainType, (Date)o));
            }
            this.dateToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateToEnum().convert(fieldCtx, mainType, (Date)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.dateToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateToNumberBased().convert(fieldCtx, mainType, (Date)o));
            }
            this.dateToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToDoublePrim().convert(fieldCtx, (Date)o));
            this.dateToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getDateToFloatPrim().convert(fieldCtx, (Date)o)));
            this.dateToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToIntegerPrim().convert(fieldCtx, (Date)o));
            this.dateToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToLongPrim().convert(fieldCtx, (Date)o));
            this.dateToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToShortPrim().convert(fieldCtx, (Date)o));
            this.dateToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getDateToObjectId().convert(fieldCtx, (Date)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.dateToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getDateToStringBased().convert(fieldCtx, mainType, (Date)o));
            }
        }

        private void putNumberCollectionToObjectArrayMap() {
            this.numberCollectionToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToBinaryArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToBooleanArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToBooleanPrimArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToByteArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToBytePrimArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToCharacterArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToCharacterPrimArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.numberCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToDateBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.numberCollectionToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToEnumArray().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.numberCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToNumberBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.numberCollectionToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToDoublePrimArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToFloatPrimArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToIntegerPrimArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToLongPrimArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToShortPrimArray().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToObjectIdArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.numberCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToStringBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putNumberCollectionToObjectCollectionMap() {
            this.numberCollectionToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToBinaryCollection().convert(fieldCtx, (Collection)src, dst));
            this.numberCollectionToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToBooleanCollection().convert(fieldCtx, (Collection)src, dst));
            this.numberCollectionToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToByteCollection().convert(fieldCtx, (Collection)src, dst));
            this.numberCollectionToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToCharacterCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.numberCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToDateBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.numberCollectionToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToEnumCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.numberCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToNumberBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.numberCollectionToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToObjectIdCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.numberCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToStringBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
        }

        private void putNumberCollectionToObjectMap() {
            this.numberCollectionToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToBinary().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToBoolean().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToBooleanPrim().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToByte().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToBytePrim().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToCharacter().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getNumberCollectionToCharacterPrim().convert(fieldCtx, (Collection)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.numberCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToDateBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.numberCollectionToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToEnum().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.numberCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToNumberBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.numberCollectionToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToDoublePrim().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getNumberCollectionToFloatPrim().convert(fieldCtx, (Collection)o)));
            this.numberCollectionToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToIntegerPrim().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToLongPrim().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToShortPrim().convert(fieldCtx, (Collection)o));
            this.numberCollectionToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToObjectId().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.numberCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberCollectionToStringBased().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putNumberToObjectArrayMap() {
            this.numberToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToBinaryArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToBooleanArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToBooleanPrimArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToByteArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToBytePrimArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToCharacterArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToCharacterPrimArray().convert(fieldCtx, (Number)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.numberToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberToDateBasedArray().convert(fieldCtx, mainType, (Number)o));
            }
            this.numberToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberToEnumArray().convert(fieldCtx, mainType, (Number)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.numberToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberToNumberBasedArray().convert(fieldCtx, mainType, (Number)o));
            }
            this.numberToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToDoublePrimArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToFloatPrimArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToIntegerPrimArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToLongPrimArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToShortPrimArray().convert(fieldCtx, (Number)o));
            this.numberToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToObjectIdArray().convert(fieldCtx, (Number)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.numberToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberToStringBasedArray().convert(fieldCtx, mainType, (Number)o));
            }
        }

        private void putNumberToObjectCollectionMap() {
            this.numberToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberToBinaryCollection().convert(fieldCtx, (Number)src, dst));
            this.numberToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberToBooleanCollection().convert(fieldCtx, (Number)src, dst));
            this.numberToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberToByteCollection().convert(fieldCtx, (Number)src, dst));
            this.numberToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberToCharacterCollection().convert(fieldCtx, (Number)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.numberToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberToDateBasedCollection().convert(fieldCtx, mainType, (Number)src, dst));
            }
            this.numberToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberToEnumCollection().convert(fieldCtx, mainType, (Number)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.numberToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberToNumberBasedCollection().convert(fieldCtx, mainType, (Number)src, dst));
            }
            this.numberToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberToObjectIdCollection().convert(fieldCtx, (Number)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.numberToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getNumberToStringBasedCollection().convert(fieldCtx, mainType, (Number)src, dst));
            }
        }

        private void putNumberToObjectMap() {
            this.numberToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToBinary().convert(fieldCtx, (Number)o));
            this.numberToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToBoolean().convert(fieldCtx, (Number)o));
            this.numberToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToBooleanPrim().convert(fieldCtx, (Number)o));
            this.numberToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToByte().convert(fieldCtx, (Number)o));
            this.numberToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToBytePrim().convert(fieldCtx, (Number)o));
            this.numberToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToCharacter().convert(fieldCtx, (Number)o));
            this.numberToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getNumberToCharacterPrim().convert(fieldCtx, (Number)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.numberToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberToDateBased().convert(fieldCtx, mainType, (Number)o));
            }
            this.numberToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberToEnum().convert(fieldCtx, mainType, (Number)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.numberToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberToNumberBased().convert(fieldCtx, mainType, (Number)o));
            }
            this.numberToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToDoublePrim().convert(fieldCtx, (Number)o));
            this.numberToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getNumberToFloatPrim().convert(fieldCtx, (Number)o)));
            this.numberToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToIntegerPrim().convert(fieldCtx, (Number)o));
            this.numberToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToLongPrim().convert(fieldCtx, (Number)o));
            this.numberToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToShortPrim().convert(fieldCtx, (Number)o));
            this.numberToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getNumberToObjectId().convert(fieldCtx, (Number)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.numberToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getNumberToStringBased().convert(fieldCtx, mainType, (Number)o));
            }
        }

        private void putObjectIdCollectionToObjectArrayMap() {
            this.objectIdCollectionToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToBinaryArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToBooleanArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToBooleanPrimArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToByteArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToBytePrimArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToCharacterArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToCharacterPrimArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.objectIdCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToDateBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.objectIdCollectionToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToEnumArray().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.objectIdCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToNumberBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.objectIdCollectionToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToDoublePrimArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToFloatPrimArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToIntegerPrimArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToLongPrimArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToShortPrimArray().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToObjectIdArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.objectIdCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToStringBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putObjectIdCollectionToObjectCollectionMap() {
            this.objectIdCollectionToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToBinaryCollection().convert(fieldCtx, (Collection)src, dst));
            this.objectIdCollectionToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToBooleanCollection().convert(fieldCtx, (Collection)src, dst));
            this.objectIdCollectionToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToByteCollection().convert(fieldCtx, (Collection)src, dst));
            this.objectIdCollectionToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToCharacterCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.objectIdCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToDateBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.objectIdCollectionToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToEnumCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.objectIdCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToNumberBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.objectIdCollectionToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToObjectIdCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.objectIdCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToStringBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
        }

        private void putObjectIdCollectionToObjectMap() {
            this.objectIdCollectionToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToBinary().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToBoolean().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToBooleanPrim().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToByte().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToBytePrim().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToCharacter().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToCharacterPrim().convert(fieldCtx, (Collection)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.objectIdCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToDateBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.objectIdCollectionToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToEnum().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.objectIdCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToNumberBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.objectIdCollectionToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToDoublePrim().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToFloatPrim().convert(fieldCtx, (Collection)o)));
            this.objectIdCollectionToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToIntegerPrim().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToLongPrim().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToShortPrim().convert(fieldCtx, (Collection)o));
            this.objectIdCollectionToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToObjectId().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.objectIdCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdCollectionToStringBased().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putObjectIdToObjectArrayMap() {
            this.objectIdToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToBinaryArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToBooleanArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToBooleanPrimArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToByteArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToBytePrimArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToCharacterArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToCharacterPrimArray().convert(fieldCtx, (ObjectId)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.objectIdToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToDateBasedArray().convert(fieldCtx, mainType, (ObjectId)o));
            }
            this.objectIdToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToEnumArray().convert(fieldCtx, mainType, (ObjectId)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.objectIdToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToNumberBasedArray().convert(fieldCtx, mainType, (ObjectId)o));
            }
            this.objectIdToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToDoublePrimArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToFloatPrimArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToIntegerPrimArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToLongPrimArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToShortPrimArray().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToObjectIdArray().convert(fieldCtx, (ObjectId)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.objectIdToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToStringBasedArray().convert(fieldCtx, mainType, (ObjectId)o));
            }
        }

        private void putObjectIdToObjectCollectionMap() {
            this.objectIdToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdToBinaryCollection().convert(fieldCtx, (ObjectId)src, dst));
            this.objectIdToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdToBooleanCollection().convert(fieldCtx, (ObjectId)src, dst));
            this.objectIdToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdToByteCollection().convert(fieldCtx, (ObjectId)src, dst));
            this.objectIdToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdToCharacterCollection().convert(fieldCtx, (ObjectId)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.objectIdToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdToDateBasedCollection().convert(fieldCtx, mainType, (ObjectId)src, dst));
            }
            this.objectIdToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdToEnumCollection().convert(fieldCtx, mainType, (ObjectId)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.objectIdToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdToNumberBasedCollection().convert(fieldCtx, mainType, (ObjectId)src, dst));
            }
            this.objectIdToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdToObjectIdCollection().convert(fieldCtx, (ObjectId)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.objectIdToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getObjectIdToStringBasedCollection().convert(fieldCtx, mainType, (ObjectId)src, dst));
            }
        }

        private void putObjectIdToObjectMap() {
            this.objectIdToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToBinary().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToBoolean().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToBooleanPrim().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToByte().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToBytePrim().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToCharacter().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getObjectIdToCharacterPrim().convert(fieldCtx, (ObjectId)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.objectIdToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToDateBased().convert(fieldCtx, mainType, (ObjectId)o));
            }
            this.objectIdToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToEnum().convert(fieldCtx, mainType, (ObjectId)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.objectIdToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToNumberBased().convert(fieldCtx, mainType, (ObjectId)o));
            }
            this.objectIdToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToDoublePrim().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getObjectIdToFloatPrim().convert(fieldCtx, (ObjectId)o)));
            this.objectIdToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToIntegerPrim().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToLongPrim().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToShortPrim().convert(fieldCtx, (ObjectId)o));
            this.objectIdToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToObjectId().convert(fieldCtx, (ObjectId)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.objectIdToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getObjectIdToStringBased().convert(fieldCtx, mainType, (ObjectId)o));
            }
        }

        private void putStringCollectionToObjectArrayMap() {
            this.stringCollectionToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToBinaryArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToBooleanArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToBooleanPrimArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToByteArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToBytePrimArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToCharacterArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToCharacterPrimArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.stringCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToDateBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.stringCollectionToObjectArrayMap.put(Enum.class, (fieldCtx, enumType, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToEnumArray().convert(fieldCtx, enumType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.stringCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToNumberBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
            this.stringCollectionToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToDoublePrimArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToFloatPrimArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToIntegerPrimArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToLongPrimArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToShortPrimArray().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToObjectIdArray().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.stringCollectionToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToStringBasedArray().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putStringCollectionToObjectCollectionMap() {
            this.stringCollectionToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToBinaryCollection().convert(fieldCtx, (Collection)src, dst));
            this.stringCollectionToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToBooleanCollection().convert(fieldCtx, (Collection)src, dst));
            this.stringCollectionToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToByteCollection().convert(fieldCtx, (Collection)src, dst));
            this.stringCollectionToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToCharacterCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.stringCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToDateBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.stringCollectionToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToEnumCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.stringCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToNumberBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
            this.stringCollectionToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToObjectIdCollection().convert(fieldCtx, (Collection)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.stringCollectionToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToStringBasedCollection().convert(fieldCtx, mainType, (Collection)src, dst));
            }
        }

        private void putStringCollectionToObjectMap() {
            this.stringCollectionToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToBinary().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToBoolean().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToBooleanPrim().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToByte().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToBytePrim().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToCharacter().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getStringCollectionToCharacterPrim().convert(fieldCtx, (Collection)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.stringCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToDateBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.stringCollectionToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToEnum().convert(fieldCtx, mainType, (Collection)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.stringCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToNumberBased().convert(fieldCtx, mainType, (Collection)o));
            }
            this.stringCollectionToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToDoublePrim().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getStringCollectionToFloatPrim().convert(fieldCtx, (Collection)o)));
            this.stringCollectionToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToIntegerPrim().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToLongPrim().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToShortPrim().convert(fieldCtx, (Collection)o));
            this.stringCollectionToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToObjectId().convert(fieldCtx, (Collection)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.stringCollectionToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringCollectionToStringBased().convert(fieldCtx, mainType, (Collection)o));
            }
        }

        private void putStringToObjectArrayMap() {
            this.stringToObjectArrayMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToBinaryArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToBooleanArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToBooleanPrimArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToByteArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToBytePrimArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToCharacterArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToCharacterPrimArray().convert(fieldCtx, (String)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.stringToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringToDateBasedArray().convert(fieldCtx, mainType, (String)o));
            }
            this.stringToObjectArrayMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringToEnumArray().convert(fieldCtx, mainType, (String)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.stringToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringToNumberBasedArray().convert(fieldCtx, mainType, (String)o));
            }
            this.stringToObjectArrayMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToDoublePrimArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(Float.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToFloatPrimArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToIntegerPrimArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToLongPrimArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToShortPrimArray().convert(fieldCtx, (String)o));
            this.stringToObjectArrayMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToObjectIdArray().convert(fieldCtx, (String)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.stringToObjectArrayMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringToStringBasedArray().convert(fieldCtx, mainType, (String)o));
            }
        }

        private void putStringToObjectCollectionMap() {
            this.stringToObjectCollectionMap.put(Binary.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringToBinaryCollection().convert(fieldCtx, (String)src, dst));
            this.stringToObjectCollectionMap.put(Boolean.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringToBooleanCollection().convert(fieldCtx, (String)src, dst));
            this.stringToObjectCollectionMap.put(Byte.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringToByteCollection().convert(fieldCtx, (String)src, dst));
            this.stringToObjectCollectionMap.put(Character.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringToCharacterCollection().convert(fieldCtx, (String)src, dst));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.stringToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringToDateBasedCollection().convert(fieldCtx, mainType, (String)src, dst));
            }
            this.stringToObjectCollectionMap.put(Enum.class, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringToEnumCollection().convert(fieldCtx, mainType, (String)src, dst));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.stringToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringToNumberBasedCollection().convert(fieldCtx, mainType, (String)src, dst));
            }
            this.stringToObjectCollectionMap.put(ObjectId.class, (fieldCtx, __, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringToObjectIdCollection().convert(fieldCtx, (String)src, dst));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.stringToObjectCollectionMap.put(type, (fieldCtx, mainType, src, dst) -> fieldCtx.getConfiguration().getToObject().getStringToStringBasedCollection().convert(fieldCtx, mainType, (String)src, dst));
            }
        }

        private void putStringToObjectMap() {
            this.stringToObjectMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToBinary().convert(fieldCtx, (String)o));
            this.stringToObjectMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToBoolean().convert(fieldCtx, (String)o));
            this.stringToObjectMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToBooleanPrim().convert(fieldCtx, (String)o));
            this.stringToObjectMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToByte().convert(fieldCtx, (String)o));
            this.stringToObjectMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToBytePrim().convert(fieldCtx, (String)o));
            this.stringToObjectMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToCharacter().convert(fieldCtx, (String)o));
            this.stringToObjectMap.put(Character.TYPE, (fieldCtx, __, o) -> Character.valueOf(fieldCtx.getConfiguration().getToObject().getStringToCharacterPrim().convert(fieldCtx, (String)o)));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.stringToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringToDateBased().convert(fieldCtx, mainType, (String)o));
            }
            this.stringToObjectMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringToEnum().convert(fieldCtx, mainType, (String)o));
            for (Class<?> type : NumberBased.REFERENCE_TYPES_SET) {
                this.stringToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringToNumberBased().convert(fieldCtx, mainType, (String)o));
            }
            this.stringToObjectMap.put(Double.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToDoublePrim().convert(fieldCtx, (String)o));
            this.stringToObjectMap.put(Float.TYPE, (fieldCtx, __, o) -> Float.valueOf(fieldCtx.getConfiguration().getToObject().getStringToFloatPrim().convert(fieldCtx, (String)o)));
            this.stringToObjectMap.put(Integer.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToIntegerPrim().convert(fieldCtx, (String)o));
            this.stringToObjectMap.put(Long.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToLongPrim().convert(fieldCtx, (String)o));
            this.stringToObjectMap.put(Short.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToShortPrim().convert(fieldCtx, (String)o));
            this.stringToObjectMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToObject().getStringToObjectId().convert(fieldCtx, (String)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.stringToObjectMap.put(type, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToObject().getStringToStringBased().convert(fieldCtx, mainType, (String)o));
            }
        }

        private void putToBsonMap() {
            this.toBsonMap.put(Binary.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getBinaryToBson().convert(fieldCtx, (Binary)o));
            this.toBsonMap.put(Boolean.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getBooleanPrimToBson().convert(fieldCtx, (Boolean)o));
            this.toBsonMap.put(Boolean.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getBooleanToBson().convert(fieldCtx, (Boolean)o));
            this.toBsonMap.put(Byte.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getBytePrimToBson().convert(fieldCtx, (Byte)o));
            this.toBsonMap.put(Byte.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getByteToBson().convert(fieldCtx, (Byte)o));
            this.toBsonMap.put(Character.TYPE, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getCharacterPrimToBson().convert(fieldCtx, ((Character)o).charValue()));
            this.toBsonMap.put(Character.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getCharacterToBson().convert(fieldCtx, (Character)o));
            for (Class<?> type : DateBased.TYPES_SET) {
                this.toBsonMap.put(type, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getDateBasedToBson().convert(fieldCtx, o));
            }
            this.toBsonMap.put(Enum.class, (fieldCtx, mainType, o) -> fieldCtx.getConfiguration().getToBson().getEnumToBson().convert(fieldCtx, mainType, (Enum)o));
            for (Class<?> type : NumberBased.TYPES_SET) {
                this.toBsonMap.put(type, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getNumberBasedToBson().convert(fieldCtx, o));
            }
            this.toBsonMap.put(ObjectId.class, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getObjectIdToBson().convert(fieldCtx, (ObjectId)o));
            for (Class<?> type : StringBased.TYPES_SET) {
                this.toBsonMap.put(type, (fieldCtx, __, o) -> fieldCtx.getConfiguration().getToBson().getStringBasedToBson().convert(fieldCtx, o));
            }
        }

        @FunctionalInterface
        public static interface FuncToObject {
            public Object convert(JaxBsonFieldContext var1, Class<?> var2, Object var3);
        }

        @FunctionalInterface
        public static interface FuncToObjectCollection {
            public Object convert(JaxBsonFieldContext var1, Class<?> var2, Object var3, Collection<?> var4);
        }

        @FunctionalInterface
        public static interface FuncToBson {
            public Object convert(JaxBsonFieldContext var1, Class<?> var2, Object var3);
        }
    }
}

