/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

enum ValueContainerType {
    ANY_ATTRIBUTE(false, false, null),
    ARRAY(true, false, null),
    LIST(false, true, ArrayList.class),
    NONE(false, false, null),
    SET(false, true, HashSet.class),
    SORTED_SET(false, true, TreeSet.class);

    private boolean array;
    private boolean collection;
    private final Class<?> collectionClass;
    private final Constructor<Collection<Object>> collectionConstructor;

    protected static ValueContainerType fromType(Class<?> type) {
        if (type.isArray()) {
            return ARRAY;
        }
        if (List.class.isAssignableFrom(type)) {
            return LIST;
        }
        if (SortedSet.class.isAssignableFrom(type)) {
            return SORTED_SET;
        }
        if (Set.class.isAssignableFrom(type)) {
            return SET;
        }
        if (Collection.class.isAssignableFrom(type)) {
            throw new IllegalStateException("Collection of type " + type.getName() + " not supported. Supported collections are: " + List.class.getName() + ", " + Set.class + " and " + SortedSet.class.getSimpleName());
        }
        if (Map.class.isAssignableFrom(type)) {
            throw new IllegalStateException("Value container type " + Map.class.getName() + " not supported: " + type.getName());
        }
        return NONE;
    }

    private ValueContainerType(boolean array, boolean collection, Class<?> collectionClass) {
        this.array = array;
        this.collection = collection;
        this.collectionClass = collectionClass;
        this.collectionConstructor = this.createCollectionConstructor();
    }

    private Constructor<Collection<Object>> createCollectionConstructor() {
        if (this.collectionClass == null) {
            return null;
        }
        try {
            Constructor<Collection<Object>> ret = this.collectionClass.getDeclaredConstructor(new Class[0]);
            ret.setAccessible(true);
            return ret;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("No no-argument constructor for collection type " + this.collectionClass.getName());
        }
    }

    protected Collection<Object> collectionInstance() {
        try {
            return this.collectionConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate object of collection class '" + this.collectionClass.getName() + "'.", e);
        }
    }

    protected boolean isArray() {
        return this.array;
    }

    protected boolean isCollection() {
        return this.collection;
    }
}

