/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bson.types.Decimal128;
import org.qnixyz.jbson.JaxBsonFieldContext;

public class NumberBased {
    private static final FuncMap FUNC_MAP = new FuncMap();
    private static Class<?>[] PRIMITIVE_TYPES = new Class[]{Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    public static final Set<Class<?>> PRIMITIVE_TYPES_SET = Collections.unmodifiableSet(new HashSet(Arrays.asList(PRIMITIVE_TYPES)));
    private static Class<?>[] REFERENCE_TYPES = new Class[]{BigDecimal.class, BigInteger.class, Decimal128.class, Double.class, Float.class, Integer.class, Long.class, Short.class};
    public static final Set<Class<?>> REFERENCE_TYPES_SET = Collections.unmodifiableSet(new HashSet(Arrays.asList(REFERENCE_TYPES)));
    private static Class<?>[] TYPES = new Class[]{BigDecimal.class, BigInteger.class, Decimal128.class, Double.class, Double.TYPE, Float.class, Float.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE};
    public static final Set<Class<?>> TYPES_SET = Collections.unmodifiableSet(new HashSet(Arrays.asList(TYPES)));
    private final Set<Class<?>> _checkerFalse = new HashSet();
    private final Set<Class<?>> _checkerTrue = new HashSet();
    private Checker checker = type -> {
        if (this._checkerTrue.contains(type)) {
            return true;
        }
        if (this._checkerFalse.contains(type)) {
            return false;
        }
        for (Class<?> e : TYPES_SET) {
            if (!e.isAssignableFrom(type)) continue;
            this._checkerTrue.add(type);
            return true;
        }
        this._checkerFalse.add(type);
        return false;
    };
    private ToBson toBson = (fieldCtx, value) -> {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        ToBson func = NumberBased.FUNC_MAP.getToBson(type);
        if (func != null) {
            return func.convert(fieldCtx, value);
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            BigDecimal cast = (BigDecimal)value;
            if (fieldCtx.getJaxBsonNumberHint() != null) {
                if (fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                cast = cast.round(new MathContext(fieldCtx.getJaxBsonNumberHint().precision(), fieldCtx.getJaxBsonNumberHint().roundingMode()));
            }
            return new BsonNumber(new Decimal128(cast));
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            BigInteger cast = (BigInteger)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(new Decimal128(new BigDecimal(cast)));
        }
        if (Decimal128.class.isAssignableFrom(type)) {
            Decimal128 cast = (Decimal128)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(cast);
        }
        if (Double.class.isAssignableFrom(type)) {
            Double cast = (Double)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(cast);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            Double cast = (Double)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(cast);
        }
        if (Float.class.isAssignableFrom(type)) {
            Float cast = (Float)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(cast.doubleValue());
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            Float cast = (Float)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(cast.doubleValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return new BsonNumber((Integer)value);
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            Integer cast = (Integer)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(cast);
        }
        if (Long.class.isAssignableFrom(type)) {
            Long cast = (Long)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(cast);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            Long cast = (Long)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(cast);
        }
        if (Short.class.isAssignableFrom(type)) {
            Short cast = (Short)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(cast.intValue());
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            Short cast = (Short)value;
            if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                return new BsonNumber(cast.toString());
            }
            return new BsonNumber(cast.intValue());
        }
        throw new IllegalStateException("Failed to convert value to Bson: " + value);
    };
    private ToObject toObject = (type, value) -> {
        if (value == null) {
            return null;
        }
        Class<?> valueType = value.getClass();
        if (type.equals(valueType)) {
            return value;
        }
        ToObject func = NumberBased.FUNC_MAP.getToObject(type);
        if (func != null) {
            return func.convert(type, value);
        }
        throw new IllegalStateException("Failed to convert value to Java object: " + value);
    };

    public Checker getChecker() {
        return this.checker;
    }

    public ToBson getToBson() {
        return this.toBson;
    }

    public ToObject getToObject() {
        return this.toObject;
    }

    public void setChecker(Checker checker) {
        this.checker = Objects.requireNonNull(checker);
    }

    public void setToBson(ToBson toBson) {
        this.toBson = Objects.requireNonNull(toBson);
    }

    public void setToObject(ToObject toObject) {
        this.toObject = Objects.requireNonNull(toObject);
    }

    @FunctionalInterface
    public static interface ToObject {
        public Object convert(Class<?> var1, Number var2);
    }

    @FunctionalInterface
    public static interface ToBson {
        public BsonNumber convert(JaxBsonFieldContext var1, Object var2);
    }

    private static class FuncMap {
        private final Map<Class<?>, ToBson> toBsonMap = new HashMap();
        private final Map<Class<?>, ToObject> toObjectMap = new HashMap();

        private FuncMap() {
            this.putToObjectMap();
            this.putToBsonMap();
        }

        private ToBson getToBson(Class<?> type) {
            return this.toBsonMap.get(type);
        }

        private ToObject getToObject(Class<?> fieldType) {
            return this.toObjectMap.get(fieldType);
        }

        private void putToBsonMap() {
            this.toBsonMap.put(BigDecimal.class, (fieldCtx, value) -> {
                BigDecimal cast = (BigDecimal)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null) {
                    if (fieldCtx.getJaxBsonNumberHintCfg().asString()) {
                        return new BsonNumber(cast.toString());
                    }
                    cast = cast.round(new MathContext(fieldCtx.getJaxBsonNumberHintCfg().precision(), fieldCtx.getJaxBsonNumberHintCfg().roundingMode()));
                } else if (fieldCtx.getJaxBsonNumberHint() != null) {
                    if (fieldCtx.getJaxBsonNumberHint().asString()) {
                        return new BsonNumber(cast.toString());
                    }
                    cast = cast.round(new MathContext(fieldCtx.getJaxBsonNumberHint().precision(), fieldCtx.getJaxBsonNumberHint().roundingMode()));
                }
                return new BsonNumber(new Decimal128(cast));
            });
            this.toBsonMap.put(BigInteger.class, (fieldCtx, value) -> {
                BigInteger cast = (BigInteger)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(new Decimal128(new BigDecimal(cast)));
            });
            this.toBsonMap.put(Decimal128.class, (fieldCtx, value) -> {
                Decimal128 cast = (Decimal128)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(cast);
            });
            this.toBsonMap.put(Double.class, (fieldCtx, value) -> {
                Double cast = (Double)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(cast);
            });
            this.toBsonMap.put(Double.TYPE, (fieldCtx, value) -> {
                Double cast = (Double)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(cast);
            });
            this.toBsonMap.put(Float.class, (fieldCtx, value) -> {
                Float cast = (Float)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(cast.doubleValue());
            });
            this.toBsonMap.put(Float.TYPE, (fieldCtx, value) -> {
                Float cast = (Float)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(cast.doubleValue());
            });
            this.toBsonMap.put(Integer.class, (fieldCtx, value) -> {
                Integer cast = (Integer)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber((Integer)value);
            });
            this.toBsonMap.put(Integer.TYPE, (fieldCtx, value) -> {
                Integer cast = (Integer)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(cast);
            });
            this.toBsonMap.put(Long.class, (fieldCtx, value) -> {
                Long cast = (Long)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(cast);
            });
            this.toBsonMap.put(Long.TYPE, (fieldCtx, value) -> {
                Long cast = (Long)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(cast);
            });
            this.toBsonMap.put(Short.class, (fieldCtx, value) -> {
                Short cast = (Short)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(cast.intValue());
            });
            this.toBsonMap.put(Short.TYPE, (fieldCtx, value) -> {
                Short cast = (Short)value;
                if (fieldCtx.getJaxBsonNumberHintCfg() != null ? fieldCtx.getJaxBsonNumberHintCfg().asString() : fieldCtx.getJaxBsonNumberHint() != null && fieldCtx.getJaxBsonNumberHint().asString()) {
                    return new BsonNumber(cast.toString());
                }
                return new BsonNumber(cast.intValue());
            });
        }

        private void putToObjectMap() {
            this.toObjectMap.put(BigDecimal.class, (__, value) -> {
                Class<?> valueType = value.getClass();
                if (Decimal128.class.equals(valueType)) {
                    return ((Decimal128)value).bigDecimalValue();
                }
                return new BigDecimal(value.doubleValue());
            });
            this.toObjectMap.put(BigInteger.class, (__, value) -> {
                Class<?> valueType = value.getClass();
                if (Decimal128.class.equals(valueType)) {
                    return ((Decimal128)value).bigDecimalValue().toBigInteger();
                }
                return BigInteger.valueOf(value.longValue());
            });
            this.toObjectMap.put(Decimal128.class, (__, value) -> new Decimal128(value.longValue()));
            this.toObjectMap.put(Double.class, (__, value) -> value.doubleValue());
            this.toObjectMap.put(Double.TYPE, (__, value) -> value.doubleValue());
            this.toObjectMap.put(Float.class, (__, value) -> Float.valueOf(value.floatValue()));
            this.toObjectMap.put(Float.TYPE, (__, value) -> Float.valueOf(value.floatValue()));
            this.toObjectMap.put(Integer.class, (__, value) -> value.intValue());
            this.toObjectMap.put(Integer.TYPE, (__, value) -> value.intValue());
            this.toObjectMap.put(Long.class, (__, value) -> value.longValue());
            this.toObjectMap.put(Long.TYPE, (__, value) -> value.longValue());
            this.toObjectMap.put(Short.class, (__, value) -> value.shortValue());
            this.toObjectMap.put(Short.TYPE, (__, value) -> value.shortValue());
        }
    }

    @FunctionalInterface
    public static interface Checker {
        public boolean check(Class<?> var1);
    }

    public static class BsonNumber {
        private final Object value;

        public BsonNumber(Decimal128 value) {
            this.value = value;
        }

        public BsonNumber(Double value) {
            this.value = value;
        }

        public BsonNumber(Integer value) {
            this.value = value;
        }

        public BsonNumber(Long value) {
            this.value = value;
        }

        public BsonNumber(String value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

