/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.JaxBsonToBsonPre;
import org.qnixyz.jbson.annotations.cfg.JaxBsonToBsonPreImpl;
import org.qnixyz.jbson.annotations.cfg.Utils;

public class JaxBsonToBsonPreMethodMap {
    private Map<Method, JaxBsonToBsonPre> map;

    public boolean containsKey(Method key) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(key);
    }

    public JaxBsonToBsonPre get(Method method) {
        Objects.requireNonNull(method);
        if (this.map == null) {
            return null;
        }
        return this.map.get(method);
    }

    public Set<Method> getKeySet() {
        if (this.map == null) {
            return Collections.emptySet();
        }
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public JaxBsonToBsonPreMethodMap put(Method method, JaxBsonToBsonPre jaxBsonToBsonPre) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(jaxBsonToBsonPre);
        if (this.map == null) {
            this.map = new HashMap<Method, JaxBsonToBsonPre>();
        }
        this.map.put(method, jaxBsonToBsonPre);
        return this;
    }

    public JaxBsonToBsonPre remove(Method method) {
        if (this.map == null) {
            return null;
        }
        return this.map.remove(method);
    }

    public static class XmlAdapter
    extends javax.xml.bind.annotation.adapters.XmlAdapter<JaxBsonToBsonPreMethodMapType, JaxBsonToBsonPreMethodMap> {
        public JaxBsonToBsonPreMethodMapType marshal(JaxBsonToBsonPreMethodMap v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonToBsonPreMethodMapType ret = new JaxBsonToBsonPreMethodMapType();
            for (Map.Entry e : v.map.entrySet()) {
                ret.add(new JaxBsonToBsonPreMethodMapEntry((Method)e.getKey(), (JaxBsonToBsonPre)e.getValue()));
            }
            return ret;
        }

        public JaxBsonToBsonPreMethodMap unmarshal(JaxBsonToBsonPreMethodMapType v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonToBsonPreMethodMap ret = new JaxBsonToBsonPreMethodMap();
            for (JaxBsonToBsonPreMethodMapEntry e : v.set) {
                Method method = Utils.declaredMethodByName(e.methodClass, e.methodName, e.methodParameterTypes);
                if (ret.containsKey(method)) {
                    throw new IllegalStateException("Multiple definitions of JaxBsonToBsonPreMap method: " + e.methodClass + "." + e.methodName);
                }
                ret.put(method, e.jaxBsonToBsonPre);
            }
            return ret;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class JaxBsonToBsonPreMethodMapType {
        @JaxBsonName(name="entries")
        @XmlElement(name="entry")
        private SortedSet<JaxBsonToBsonPreMethodMapEntry> set;

        private JaxBsonToBsonPreMethodMapType() {
        }

        private void add(JaxBsonToBsonPreMethodMapEntry e) {
            Objects.requireNonNull(e);
            if (this.set == null) {
                this.set = new TreeSet<JaxBsonToBsonPreMethodMapEntry>();
            }
            this.set.add(e);
        }

        private boolean isEmpty() {
            return this.set == null || this.set.isEmpty();
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class JaxBsonToBsonPreMethodMapEntry
    implements Comparable<JaxBsonToBsonPreMethodMapEntry> {
        @XmlElement(required=true)
        private JaxBsonToBsonPreImpl jaxBsonToBsonPre;
        @XmlAttribute(required=true)
        private String methodClass;
        @XmlAttribute(required=true)
        private String methodName;
        @XmlAttribute
        private List<String> methodParameterTypes;

        private JaxBsonToBsonPreMethodMapEntry() {
        }

        private JaxBsonToBsonPreMethodMapEntry(Method method, JaxBsonToBsonPre jaxBsonToBsonPre) {
            this.methodClass = method.getDeclaringClass().getName();
            this.methodName = method.getName();
            if (method.getParameterTypes() != null) {
                for (Class<?> pt : method.getParameterTypes()) {
                    this.addParameterType(pt);
                }
            }
            if (jaxBsonToBsonPre != null) {
                this.jaxBsonToBsonPre = jaxBsonToBsonPre instanceof JaxBsonToBsonPreImpl ? (JaxBsonToBsonPreImpl)jaxBsonToBsonPre : new JaxBsonToBsonPreImpl(jaxBsonToBsonPre);
            }
        }

        private void addParameterType(Class<?> pt) {
            if (this.methodParameterTypes == null) {
                this.methodParameterTypes = new ArrayList<String>();
            }
            this.methodParameterTypes.add(pt.getName());
        }

        @Override
        public int compareTo(JaxBsonToBsonPreMethodMapEntry o) {
            if (o == null) {
                return 1;
            }
            int ret = org.qnixyz.jbson.impl.Utils.compare(this.methodClass, o.methodClass);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compare(this.methodName, o.methodName);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compareStringLists(this.methodParameterTypes, o.methodParameterTypes);
            if (ret != 0) {
                return ret;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxBsonToBsonPreMethodMapEntry other = (JaxBsonToBsonPreMethodMapEntry)obj;
            if (this.methodClass == null ? other.methodClass != null : !this.methodClass.equals(other.methodClass)) {
                return false;
            }
            if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
                return false;
            }
            return !(this.methodParameterTypes == null ? other.methodParameterTypes != null : !this.methodParameterTypes.equals(other.methodParameterTypes));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.methodClass == null ? 0 : this.methodClass.hashCode());
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            result = 31 * result + (this.methodParameterTypes == null ? 0 : this.methodParameterTypes.hashCode());
            return result;
        }
    }
}

