/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.qnixyz.jbson.helpers.XmlEnumValueHelper;

public class IndexedEnum {
    private final Map<Object, String> enumToString = new HashMap<Object, String>();
    private final Map<String, Object> stringToEnum = new HashMap<String, Object>();
    private final Class<?> type;

    public IndexedEnum(Class<?> type) {
        this.type = Objects.requireNonNull(type);
        if (!Enum.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Supplied class isn't enum: " + type);
        }
        this.index();
    }

    public String enumToString(Object v) {
        if (v == null) {
            return null;
        }
        if (!this.enumToString.containsKey(v)) {
            throw new IllegalArgumentException("Supplied parameter 'v' (" + v + ") not in value map for class " + this.type + ". Contained enumerations: " + this.enumToString.keySet());
        }
        return this.enumToString.get(v);
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object stringToEnum(Object v) {
        if (v == null) {
            return null;
        }
        if (!this.stringToEnum.containsKey(v)) {
            throw new IllegalArgumentException("Supplied parameter 'v' not in this map: " + v + ". Contained enumerations: " + this.stringToEnum.keySet());
        }
        return this.stringToEnum.get(v);
    }

    private String getEnumString(Object enumConstant) {
        try {
            XmlEnumValueHelper xmlEnumValue = XmlEnumValueHelper.instance(enumConstant.getClass().getField(((Enum)enumConstant).name()));
            if (xmlEnumValue == null) {
                return enumConstant.toString();
            }
            return xmlEnumValue.value();
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private void index() {
        ?[] enumConstants = this.type.getEnumConstants();
        if (enumConstants != null) {
            for (Object enumConstant : enumConstants) {
                String enumString = this.getEnumString(enumConstant);
                if (this.stringToEnum.containsKey(enumString)) {
                    throw new IllegalStateException("Multiple string values '" + enumString + "' in enum " + this.type);
                }
                this.stringToEnum.put(enumString, enumConstant);
                this.enumToString.put(enumConstant, enumString);
            }
        }
    }
}

