/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.qnixyz.jbson.JaxBsonFieldContext;
import org.qnixyz.jbson.NumberBased;
import org.qnixyz.jbson.impl.Utils;

public class JaxBsonToBson {
    public static final JaxBsonToBson DEFAULT = new Builder().build();
    private final BinaryCollectionToBson binaryCollectionToBson;
    private final BinaryToBson binaryToBson;
    private final BooleanArrayToBson booleanArrayToBson;
    private final BooleanCollectionToBson booleanCollectionToBson;
    private final BooleanPrimArrayToBson booleanPrimArrayToBson;
    private final BooleanPrimToBson booleanPrimToBson;
    private final BooleanToBson booleanToBson;
    private final ByteArrayToBson byteArrayToBson;
    private final ByteCollectionToBson byteCollectionToBson;
    private final BytePrimArrayToBson bytePrimArrayToBson;
    private final BytePrimToBson bytePrimToBson;
    private final ByteToBson byteToBson;
    private final CharacterArrayToBson characterArrayToBson;
    private final CharacterCollectionToBson characterCollectionToBson;
    private final CharacterPrimArrayToBson characterPrimArrayToBson;
    private final CharacterPrimToBson characterPrimToBson;
    private final CharacterToBson characterToBson;
    private final DateBasedArrayToBson dateBasedArrayToBson;
    private final DateBasedCollectionToBson dateBasedCollectionToBson;
    private final DateBasedToBson dateBasedToBson;
    private final DoublePrimArrayToBson doublePrimArrayToBson;
    private final EnumArrayToBson enumArrayToBson;
    private final EnumCollectionToBson enumCollectionToBson;
    private final EnumToBson enumToBson;
    private final FloatPrimArrayToBson floatPrimArrayToBson;
    private final FloatPrimToBson floatPrimToBson;
    private final IntegerPrimArrayToBson integerPrimArrayToBson;
    private final LongPrimArrayToBson longPrimArrayToBson;
    private final NumberBasedArrayToBson numberBasedArrayToBson;
    private final NumberBasedCollectionToBson numberBasedCollectionToBson;
    private final NumberBasedToBson numberBasedToBson;
    private final ObjectIdArrayToBson objectIdArrayToBson;
    private final ObjectIdCollectionToBson objectIdCollectionToBson;
    private final ObjectIdToBson objectIdToBson;
    private final ShortPrimArrayToBson shortPrimArrayToBson;
    private final ShortPrimToBson shortPrimToBson;
    private final StringBasedArrayToBson stringBasedArrayToBson;
    private final StringBasedCollectionToBson stringBasedCollectionToBson;
    private final StringBasedToBson stringBasedToBson;

    private JaxBsonToBson() {
        this.binaryCollectionToBson = null;
        this.binaryToBson = null;
        this.booleanArrayToBson = null;
        this.booleanCollectionToBson = null;
        this.booleanPrimArrayToBson = null;
        this.booleanPrimToBson = null;
        this.booleanToBson = null;
        this.byteArrayToBson = null;
        this.byteCollectionToBson = null;
        this.bytePrimArrayToBson = null;
        this.bytePrimToBson = null;
        this.byteToBson = null;
        this.characterArrayToBson = null;
        this.characterCollectionToBson = null;
        this.characterPrimArrayToBson = null;
        this.characterPrimToBson = null;
        this.characterToBson = null;
        this.dateBasedArrayToBson = null;
        this.dateBasedCollectionToBson = null;
        this.dateBasedToBson = null;
        this.doublePrimArrayToBson = null;
        this.enumArrayToBson = null;
        this.enumCollectionToBson = null;
        this.enumToBson = null;
        this.floatPrimArrayToBson = null;
        this.floatPrimToBson = null;
        this.integerPrimArrayToBson = null;
        this.longPrimArrayToBson = null;
        this.numberBasedArrayToBson = null;
        this.numberBasedCollectionToBson = null;
        this.numberBasedToBson = null;
        this.objectIdArrayToBson = null;
        this.objectIdCollectionToBson = null;
        this.objectIdToBson = null;
        this.shortPrimArrayToBson = null;
        this.shortPrimToBson = null;
        this.stringBasedArrayToBson = null;
        this.stringBasedCollectionToBson = null;
        this.stringBasedToBson = null;
    }

    private JaxBsonToBson(Builder b) {
        this.binaryCollectionToBson = b.binaryCollectionToBson;
        this.binaryToBson = b.binaryToBson;
        this.booleanArrayToBson = b.booleanArrayToBson;
        this.booleanCollectionToBson = b.booleanCollectionToBson;
        this.booleanPrimArrayToBson = b.booleanPrimArrayToBson;
        this.booleanPrimToBson = b.booleanPrimToBson;
        this.booleanToBson = b.booleanToBson;
        this.byteArrayToBson = b.byteArrayToBson;
        this.byteCollectionToBson = b.byteCollectionToBson;
        this.bytePrimArrayToBson = b.bytePrimArrayToBson;
        this.bytePrimToBson = b.bytePrimToBson;
        this.byteToBson = b.byteToBson;
        this.characterArrayToBson = b.characterArrayToBson;
        this.characterCollectionToBson = b.characterCollectionToBson;
        this.characterPrimArrayToBson = b.characterPrimArrayToBson;
        this.characterPrimToBson = b.characterPrimToBson;
        this.characterToBson = b.characterToBson;
        this.dateBasedArrayToBson = b.dateBasedArrayToBson;
        this.dateBasedCollectionToBson = b.dateBasedCollectionToBson;
        this.dateBasedToBson = b.dateBasedToBson;
        this.doublePrimArrayToBson = b.doublePrimArrayToBson;
        this.enumArrayToBson = b.enumArrayToBson;
        this.enumCollectionToBson = b.enumCollectionToBson;
        this.enumToBson = b.enumToBson;
        this.floatPrimArrayToBson = b.floatPrimArrayToBson;
        this.floatPrimToBson = b.floatPrimToBson;
        this.integerPrimArrayToBson = b.integerPrimArrayToBson;
        this.longPrimArrayToBson = b.longPrimArrayToBson;
        this.numberBasedArrayToBson = b.numberBasedArrayToBson;
        this.numberBasedCollectionToBson = b.numberBasedCollectionToBson;
        this.numberBasedToBson = b.numberBasedToBson;
        this.objectIdArrayToBson = b.objectIdArrayToBson;
        this.objectIdCollectionToBson = b.objectIdCollectionToBson;
        this.objectIdToBson = b.objectIdToBson;
        this.shortPrimArrayToBson = b.shortPrimArrayToBson;
        this.shortPrimToBson = b.shortPrimToBson;
        this.stringBasedArrayToBson = b.stringBasedArrayToBson;
        this.stringBasedCollectionToBson = b.stringBasedCollectionToBson;
        this.stringBasedToBson = b.stringBasedToBson;
    }

    public BinaryCollectionToBson getBinaryCollectionToBson() {
        return this.binaryCollectionToBson;
    }

    public BinaryToBson getBinaryToBson() {
        return this.binaryToBson;
    }

    public BooleanArrayToBson getBooleanArrayToBson() {
        return this.booleanArrayToBson;
    }

    public BooleanCollectionToBson getBooleanCollectionToBson() {
        return this.booleanCollectionToBson;
    }

    public BooleanPrimArrayToBson getBooleanPrimArrayToBson() {
        return this.booleanPrimArrayToBson;
    }

    public BooleanPrimToBson getBooleanPrimToBson() {
        return this.booleanPrimToBson;
    }

    public BooleanToBson getBooleanToBson() {
        return this.booleanToBson;
    }

    public ByteArrayToBson getByteArrayToBson() {
        return this.byteArrayToBson;
    }

    public ByteCollectionToBson getByteCollectionToBson() {
        return this.byteCollectionToBson;
    }

    public BytePrimArrayToBson getBytePrimArrayToBson() {
        return this.bytePrimArrayToBson;
    }

    public BytePrimToBson getBytePrimToBson() {
        return this.bytePrimToBson;
    }

    public ByteToBson getByteToBson() {
        return this.byteToBson;
    }

    public CharacterArrayToBson getCharacterArrayToBson() {
        return this.characterArrayToBson;
    }

    public CharacterCollectionToBson getCharacterCollectionToBson() {
        return this.characterCollectionToBson;
    }

    public CharacterPrimArrayToBson getCharacterPrimArrayToBson() {
        return this.characterPrimArrayToBson;
    }

    public CharacterPrimToBson getCharacterPrimToBson() {
        return this.characterPrimToBson;
    }

    public CharacterToBson getCharacterToBson() {
        return this.characterToBson;
    }

    public DateBasedArrayToBson getDateBasedArrayToBson() {
        return this.dateBasedArrayToBson;
    }

    public DateBasedCollectionToBson getDateBasedCollectionToBson() {
        return this.dateBasedCollectionToBson;
    }

    public DateBasedToBson getDateBasedToBson() {
        return this.dateBasedToBson;
    }

    public DoublePrimArrayToBson getDoublePrimArrayToBson() {
        return this.doublePrimArrayToBson;
    }

    public EnumArrayToBson getEnumArrayToBson() {
        return this.enumArrayToBson;
    }

    public EnumCollectionToBson getEnumCollectionToBson() {
        return this.enumCollectionToBson;
    }

    public EnumToBson getEnumToBson() {
        return this.enumToBson;
    }

    public FloatPrimArrayToBson getFloatPrimArrayToBson() {
        return this.floatPrimArrayToBson;
    }

    public FloatPrimToBson getFloatPrimToBson() {
        return this.floatPrimToBson;
    }

    public IntegerPrimArrayToBson getIntegerPrimArrayToBson() {
        return this.integerPrimArrayToBson;
    }

    public LongPrimArrayToBson getLongPrimArrayToBson() {
        return this.longPrimArrayToBson;
    }

    public NumberBasedArrayToBson getNumberBasedArrayToBson() {
        return this.numberBasedArrayToBson;
    }

    public NumberBasedCollectionToBson getNumberBasedCollectionToBson() {
        return this.numberBasedCollectionToBson;
    }

    public NumberBasedToBson getNumberBasedToBson() {
        return this.numberBasedToBson;
    }

    public ObjectIdArrayToBson getObjectIdArrayToBson() {
        return this.objectIdArrayToBson;
    }

    public ObjectIdCollectionToBson getObjectIdCollectionToBson() {
        return this.objectIdCollectionToBson;
    }

    public ObjectIdToBson getObjectIdToBson() {
        return this.objectIdToBson;
    }

    public ShortPrimArrayToBson getShortPrimArrayToBson() {
        return this.shortPrimArrayToBson;
    }

    public ShortPrimToBson getShortPrimToBson() {
        return this.shortPrimToBson;
    }

    public StringBasedArrayToBson getStringBasedArrayToBson() {
        return this.stringBasedArrayToBson;
    }

    public StringBasedCollectionToBson getStringBasedCollectionToBson() {
        return this.stringBasedCollectionToBson;
    }

    public StringBasedToBson getStringBasedToBson() {
        return this.stringBasedToBson;
    }

    @FunctionalInterface
    public static interface StringBasedToBson {
        public String convert(JaxBsonFieldContext var1, Object var2);
    }

    @FunctionalInterface
    public static interface StringBasedCollectionToBson {
        public List<String> convert(JaxBsonFieldContext var1, Collection<Object> var2);
    }

    @FunctionalInterface
    public static interface StringBasedArrayToBson {
        public List<String> convert(JaxBsonFieldContext var1, Object[] var2);
    }

    @FunctionalInterface
    public static interface ShortPrimToBson {
        public Object convert(JaxBsonFieldContext var1, short var2);
    }

    @FunctionalInterface
    public static interface ShortPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, short[] var2);
    }

    @FunctionalInterface
    public static interface ObjectIdToBson {
        public Object convert(JaxBsonFieldContext var1, ObjectId var2);
    }

    @FunctionalInterface
    public static interface ObjectIdCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Collection<ObjectId> var2);
    }

    @FunctionalInterface
    public static interface ObjectIdArrayToBson {
        public Object convert(JaxBsonFieldContext var1, ObjectId[] var2);
    }

    @FunctionalInterface
    public static interface NumberBasedToBson {
        public Object convert(JaxBsonFieldContext var1, Object var2);
    }

    @FunctionalInterface
    public static interface NumberBasedCollectionToBson {
        public List<Object> convert(JaxBsonFieldContext var1, Collection<Object> var2);
    }

    @FunctionalInterface
    public static interface NumberBasedArrayToBson {
        public List<Object> convert(JaxBsonFieldContext var1, Object[] var2);
    }

    @FunctionalInterface
    public static interface LongPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, long[] var2);
    }

    @FunctionalInterface
    public static interface IntegerPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, int[] var2);
    }

    @FunctionalInterface
    public static interface FloatPrimToBson {
        public Object convert(JaxBsonFieldContext var1, float var2);
    }

    @FunctionalInterface
    public static interface FloatPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, float[] var2);
    }

    @FunctionalInterface
    public static interface EnumToBson {
        public Object convert(JaxBsonFieldContext var1, Class<?> var2, Enum<?> var3);
    }

    @FunctionalInterface
    public static interface EnumCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Class<?> var2, Collection<Enum<?>> var3);
    }

    @FunctionalInterface
    public static interface EnumArrayToBson {
        public Object convert(JaxBsonFieldContext var1, Class<?> var2, Enum<?>[] var3);
    }

    @FunctionalInterface
    public static interface DoublePrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, double[] var2);
    }

    @FunctionalInterface
    public static interface DateBasedToBson {
        public Date convert(JaxBsonFieldContext var1, Object var2);
    }

    @FunctionalInterface
    public static interface DateBasedCollectionToBson {
        public List<Date> convert(JaxBsonFieldContext var1, Collection<Object> var2);
    }

    @FunctionalInterface
    public static interface DateBasedArrayToBson {
        public List<Date> convert(JaxBsonFieldContext var1, Object[] var2);
    }

    @FunctionalInterface
    public static interface CharacterToBson {
        public Object convert(JaxBsonFieldContext var1, Character var2);
    }

    @FunctionalInterface
    public static interface CharacterPrimToBson {
        public Object convert(JaxBsonFieldContext var1, char var2);
    }

    @FunctionalInterface
    public static interface CharacterPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, char[] var2);
    }

    @FunctionalInterface
    public static interface CharacterCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Collection<Character> var2);
    }

    @FunctionalInterface
    public static interface CharacterArrayToBson {
        public Object convert(JaxBsonFieldContext var1, Character[] var2);
    }

    @FunctionalInterface
    public static interface ByteToBson {
        public Object convert(JaxBsonFieldContext var1, Byte var2);
    }

    @FunctionalInterface
    public static interface BytePrimToBson {
        public Object convert(JaxBsonFieldContext var1, byte var2);
    }

    @FunctionalInterface
    public static interface BytePrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, byte[] var2);
    }

    @FunctionalInterface
    public static interface ByteCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Collection<Byte> var2);
    }

    @FunctionalInterface
    public static interface ByteArrayToBson {
        public Object convert(JaxBsonFieldContext var1, Byte[] var2);
    }

    public static class Builder {
        private BinaryCollectionToBson binaryCollectionToBson = (fieldCtx, src) -> {
            ArrayList ret = new ArrayList();
            src.forEach(e -> ret.add(fieldCtx.getConfiguration().getToBson().getBinaryToBson().convert(fieldCtx, (Binary)e)));
            return ret;
        };
        private BinaryToBson binaryToBson = (fieldCtx, src) -> src;
        private BooleanArrayToBson booleanArrayToBson = (fieldCtx, src) -> {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (Boolean e : src) {
                ret.add(fieldCtx.getConfiguration().getToBson().getBooleanToBson().convert(fieldCtx, e));
            }
            return ret;
        };
        private BooleanCollectionToBson booleanCollectionToBson = (fieldCtx, src) -> {
            ArrayList ret = new ArrayList();
            src.forEach(e -> ret.add(fieldCtx.getConfiguration().getToBson().getBooleanToBson().convert(fieldCtx, (Boolean)e)));
            return ret;
        };
        private BooleanPrimArrayToBson booleanPrimArrayToBson = (fieldCtx, src) -> Arrays.asList(Utils.toObjectArray(src));
        private BooleanPrimToBson booleanPrimToBson = (fieldCtx, src) -> src;
        private BooleanToBson booleanToBson = (fieldCtx, src) -> src;
        private ByteArrayToBson byteArrayToBson = (fieldCtx, src) -> new Binary(Utils.toPrimitiveArray(src));
        private ByteCollectionToBson byteCollectionToBson = (fieldCtx, src) -> {
            byte[] ret = new byte[src.size()];
            int i = 0;
            for (Byte e : src) {
                if (e != null) {
                    ret[i] = e;
                }
                ++i;
            }
            return new Binary(ret);
        };
        private BytePrimArrayToBson bytePrimArrayToBson = (fieldCtx, src) -> new Binary(src);
        private BytePrimToBson bytePrimToBson = (fieldCtx, src) -> new Binary(new byte[]{src});
        private ByteToBson byteToBson = (fieldCtx, src) -> new Binary(new byte[]{src});
        private CharacterArrayToBson characterArrayToBson = (fieldCtx, src) -> new String(Utils.toPrimitiveArray(src));
        private CharacterCollectionToBson characterCollectionToBson = (fieldCtx, src) -> {
            char[] ret = new char[src.size()];
            int i = 0;
            for (Character e : src) {
                if (e != null) {
                    ret[i] = e.charValue();
                }
                ++i;
            }
            return new String(ret);
        };
        private CharacterPrimArrayToBson characterPrimArrayToBson = (fieldCtx, src) -> new String(src);
        private CharacterPrimToBson characterPrimToBson = (fieldCtx, src) -> Character.valueOf(src).toString();
        private CharacterToBson characterToBson = (fieldCtx, src) -> src.toString();
        private DateBasedArrayToBson dateBasedArrayToBson = (fieldCtx, src) -> {
            ArrayList<Date> ret = new ArrayList<Date>();
            for (Object e : src) {
                ret.add(fieldCtx.getConfiguration().getDateBased().getToBson().convert(e));
            }
            return ret;
        };
        private DateBasedCollectionToBson dateBasedCollectionToBson = (fieldCtx, src) -> {
            ArrayList ret = new ArrayList();
            src.forEach(e -> ret.add(fieldCtx.getConfiguration().getDateBased().getToBson().convert(e)));
            return ret;
        };
        private DateBasedToBson dateBasedToBson = (fieldCtx, src) -> fieldCtx.getConfiguration().getDateBased().getToBson().convert(src);
        private DoublePrimArrayToBson doublePrimArrayToBson = (fieldCtx, src) -> Arrays.asList(Utils.toObjectArray(src));
        private EnumArrayToBson enumArrayToBson = (fieldCtx, enumType, src) -> {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (Enum e : src) {
                ret.add(fieldCtx.getConfiguration().getToBson().getEnumToBson().convert(fieldCtx, enumType, e));
            }
            return ret;
        };
        private EnumCollectionToBson enumCollectionToBson = (fieldCtx, enumType, src) -> {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (Enum e : src) {
                ret.add(fieldCtx.getConfiguration().getToBson().getEnumToBson().convert(fieldCtx, enumType, e));
            }
            return ret;
        };
        private EnumToBson enumToBson = (fieldCtx, enumType, src) -> fieldCtx.getConfiguration().getIndexedEnum(enumType).enumToString(src);
        private FloatPrimArrayToBson floatPrimArrayToBson = (fieldCtx, src) -> {
            ArrayList<Object> ret = new ArrayList<Object>();
            float[] fArray = src;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float e = Float.valueOf(fArray[i]);
                ret.add(fieldCtx.getConfiguration().getToBson().getFloatPrimToBson().convert(fieldCtx, e.floatValue()));
            }
            return ret;
        };
        private FloatPrimToBson floatPrimToBson = (fieldCtx, src) -> Float.valueOf(src).doubleValue();
        private IntegerPrimArrayToBson integerPrimArrayToBson = (fieldCtx, src) -> Arrays.asList(Utils.toObjectArray(src));
        private LongPrimArrayToBson longPrimArrayToBson = (fieldCtx, src) -> Arrays.asList(Utils.toObjectArray(src));
        private NumberBasedArrayToBson numberBasedArrayToBson = (fieldCtx, src) -> {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (Object e : src) {
                NumberBased.BsonNumber bsonNumber = fieldCtx.getConfiguration().getNumberBased().getToBson().convert(fieldCtx, e);
                ret.add(bsonNumber == null ? null : bsonNumber.getValue());
            }
            return ret;
        };
        private NumberBasedCollectionToBson numberBasedCollectionToBson = (fieldCtx, src) -> {
            ArrayList ret = new ArrayList();
            src.forEach(e -> {
                NumberBased.BsonNumber bsonNumber = fieldCtx.getConfiguration().getNumberBased().getToBson().convert(fieldCtx, e);
                ret.add(bsonNumber == null ? null : bsonNumber.getValue());
            });
            return ret;
        };
        private NumberBasedToBson numberBasedToBson = (fieldCtx, src) -> fieldCtx.getConfiguration().getNumberBased().getToBson().convert(fieldCtx, src).getValue();
        private ObjectIdArrayToBson objectIdArrayToBson = (fieldCtx, src) -> Arrays.asList(src);
        private ObjectIdCollectionToBson objectIdCollectionToBson = (fieldCtx, src) -> src;
        private ObjectIdToBson objectIdToBson = (fieldCtx, src) -> src;
        private ShortPrimArrayToBson shortPrimArrayToBson = (fieldCtx, src) -> {
            ArrayList<Object> ret = new ArrayList<Object>();
            short[] sArray = src;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                Short e = sArray[i];
                ret.add(fieldCtx.getConfiguration().getToBson().getShortPrimToBson().convert(fieldCtx, e));
            }
            return ret;
        };
        private ShortPrimToBson shortPrimToBson = (fieldCtx, src) -> Short.valueOf(src).intValue();
        private StringBasedArrayToBson stringBasedArrayToBson = (fieldCtx, src) -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object e : src) {
                ret.add(fieldCtx.getConfiguration().getStringBased().getToBson().convert(e));
            }
            return ret;
        };
        private StringBasedCollectionToBson stringBasedCollectionToBson = (fieldCtx, src) -> {
            ArrayList ret = new ArrayList();
            src.forEach(e -> ret.add(fieldCtx.getConfiguration().getStringBased().getToBson().convert(e)));
            return ret;
        };
        private StringBasedToBson stringBasedToBson = (fieldCtx, src) -> fieldCtx.getConfiguration().getStringBased().getToBson().convert(src);

        public Builder binaryCollectionToBson(BinaryCollectionToBson binaryCollectionToBson) {
            this.binaryCollectionToBson = Objects.requireNonNull(binaryCollectionToBson);
            return this;
        }

        public Builder binaryToBson(BinaryToBson binaryToBson) {
            this.binaryToBson = Objects.requireNonNull(binaryToBson);
            return this;
        }

        public Builder booleanArrayToBson(BooleanArrayToBson booleanArrayToBson) {
            this.booleanArrayToBson = Objects.requireNonNull(booleanArrayToBson);
            return this;
        }

        public Builder booleanCollectionToBson(BooleanCollectionToBson booleanCollectionToBson) {
            this.booleanCollectionToBson = Objects.requireNonNull(booleanCollectionToBson);
            return this;
        }

        public Builder booleanPrimArrayToBson(BooleanPrimArrayToBson booleanPrimArrayToBson) {
            this.booleanPrimArrayToBson = Objects.requireNonNull(booleanPrimArrayToBson);
            return this;
        }

        public Builder booleanPrimToBson(BooleanPrimToBson booleanPrimToBson) {
            this.booleanPrimToBson = Objects.requireNonNull(booleanPrimToBson);
            return this;
        }

        public Builder booleanToBson(BooleanToBson booleanToBson) {
            this.booleanToBson = Objects.requireNonNull(booleanToBson);
            return this;
        }

        public JaxBsonToBson build() {
            return new JaxBsonToBson(this);
        }

        public Builder byteArrayToBson(ByteArrayToBson byteArrayToBson) {
            this.byteArrayToBson = Objects.requireNonNull(byteArrayToBson);
            return this;
        }

        public Builder byteCollectionToBson(ByteCollectionToBson byteCollectionToBson) {
            this.byteCollectionToBson = Objects.requireNonNull(byteCollectionToBson);
            return this;
        }

        public Builder bytePrimArrayToBson(BytePrimArrayToBson bytePrimArrayToBson) {
            this.bytePrimArrayToBson = Objects.requireNonNull(bytePrimArrayToBson);
            return this;
        }

        public Builder bytePrimToBson(BytePrimToBson bytePrimToBson) {
            this.bytePrimToBson = Objects.requireNonNull(bytePrimToBson);
            return this;
        }

        public Builder byteToBson(ByteToBson byteToBson) {
            this.byteToBson = Objects.requireNonNull(byteToBson);
            return this;
        }

        public Builder characterArrayToBson(CharacterArrayToBson characterArrayToBson) {
            this.characterArrayToBson = Objects.requireNonNull(characterArrayToBson);
            return this;
        }

        public Builder characterCollectionToBson(CharacterCollectionToBson characterCollectionToBson) {
            this.characterCollectionToBson = Objects.requireNonNull(characterCollectionToBson);
            return this;
        }

        public Builder characterPrimArrayToBson(CharacterPrimArrayToBson characterPrimArrayToBson) {
            this.characterPrimArrayToBson = Objects.requireNonNull(characterPrimArrayToBson);
            return this;
        }

        public Builder characterPrimToBson(CharacterPrimToBson characterPrimToBson) {
            this.characterPrimToBson = Objects.requireNonNull(characterPrimToBson);
            return this;
        }

        public Builder characterToBson(CharacterToBson characterToBson) {
            this.characterToBson = Objects.requireNonNull(characterToBson);
            return this;
        }

        public Builder dateBasedArrayToBson(DateBasedArrayToBson dateBasedArrayToBson) {
            this.dateBasedArrayToBson = Objects.requireNonNull(dateBasedArrayToBson);
            return this;
        }

        public Builder dateBasedCollectionToBson(DateBasedCollectionToBson dateBasedCollectionToBson) {
            this.dateBasedCollectionToBson = Objects.requireNonNull(dateBasedCollectionToBson);
            return this;
        }

        public Builder dateBasedToBson(DateBasedToBson dateBasedToBson) {
            this.dateBasedToBson = Objects.requireNonNull(dateBasedToBson);
            return this;
        }

        public Builder doublePrimArrayToBson(DoublePrimArrayToBson doublePrimArrayToBson) {
            this.doublePrimArrayToBson = Objects.requireNonNull(doublePrimArrayToBson);
            return this;
        }

        public Builder enumArrayToBson(EnumArrayToBson enumArrayToBson) {
            this.enumArrayToBson = Objects.requireNonNull(enumArrayToBson);
            return this;
        }

        public Builder enumCollectionToBson(EnumCollectionToBson enumCollectionToBson) {
            this.enumCollectionToBson = Objects.requireNonNull(enumCollectionToBson);
            return this;
        }

        public Builder enumToBson(EnumToBson enumToBson) {
            this.enumToBson = Objects.requireNonNull(enumToBson);
            return this;
        }

        public Builder floatPrimArrayToBson(FloatPrimArrayToBson floatPrimArrayToBson) {
            this.floatPrimArrayToBson = Objects.requireNonNull(floatPrimArrayToBson);
            return this;
        }

        public Builder floatPrimToBson(FloatPrimToBson floatPrimToBson) {
            this.floatPrimToBson = Objects.requireNonNull(floatPrimToBson);
            return this;
        }

        public Builder integerPrimArrayToBson(IntegerPrimArrayToBson integerPrimArrayToBson) {
            this.integerPrimArrayToBson = Objects.requireNonNull(integerPrimArrayToBson);
            return this;
        }

        public Builder longPrimArrayToBson(LongPrimArrayToBson longPrimArrayToBson) {
            this.longPrimArrayToBson = Objects.requireNonNull(longPrimArrayToBson);
            return this;
        }

        public Builder numberBasedArrayToBson(NumberBasedArrayToBson numberBasedArrayToBson) {
            this.numberBasedArrayToBson = Objects.requireNonNull(numberBasedArrayToBson);
            return this;
        }

        public Builder numberBasedCollectionToBson(NumberBasedCollectionToBson numberBasedCollectionToBson) {
            this.numberBasedCollectionToBson = Objects.requireNonNull(numberBasedCollectionToBson);
            return this;
        }

        public Builder numberBasedToBson(NumberBasedToBson numberBasedToBson) {
            this.numberBasedToBson = Objects.requireNonNull(numberBasedToBson);
            return this;
        }

        public Builder objectIdArrayToBson(ObjectIdArrayToBson objectIdArrayToBson) {
            this.objectIdArrayToBson = Objects.requireNonNull(objectIdArrayToBson);
            return this;
        }

        public Builder objectIdCollectionToBson(ObjectIdCollectionToBson objectIdCollectionToBson) {
            this.objectIdCollectionToBson = Objects.requireNonNull(objectIdCollectionToBson);
            return this;
        }

        public Builder objectIdToBson(ObjectIdToBson objectIdToBson) {
            this.objectIdToBson = Objects.requireNonNull(objectIdToBson);
            return this;
        }

        public Builder shortPrimArrayToBson(ShortPrimArrayToBson shortPrimArrayToBson) {
            this.shortPrimArrayToBson = Objects.requireNonNull(shortPrimArrayToBson);
            return this;
        }

        public Builder shortPrimToBson(ShortPrimToBson shortPrimToBson) {
            this.shortPrimToBson = Objects.requireNonNull(shortPrimToBson);
            return this;
        }

        public Builder stringBasedArrayToBson(StringBasedArrayToBson stringBasedArrayToBson) {
            this.stringBasedArrayToBson = Objects.requireNonNull(stringBasedArrayToBson);
            return this;
        }

        public Builder stringBasedCollectionToBson(StringBasedCollectionToBson stringBasedCollectionToBson) {
            this.stringBasedCollectionToBson = Objects.requireNonNull(stringBasedCollectionToBson);
            return this;
        }

        public Builder stringBasedToBson(StringBasedToBson stringBasedToBson) {
            this.stringBasedToBson = Objects.requireNonNull(stringBasedToBson);
            return this;
        }
    }

    @FunctionalInterface
    public static interface BooleanToBson {
        public Object convert(JaxBsonFieldContext var1, Boolean var2);
    }

    @FunctionalInterface
    public static interface BooleanPrimToBson {
        public Object convert(JaxBsonFieldContext var1, boolean var2);
    }

    @FunctionalInterface
    public static interface BooleanPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, boolean[] var2);
    }

    @FunctionalInterface
    public static interface BooleanCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Collection<Boolean> var2);
    }

    @FunctionalInterface
    public static interface BooleanArrayToBson {
        public Object convert(JaxBsonFieldContext var1, Boolean[] var2);
    }

    @FunctionalInterface
    public static interface BinaryToBson {
        public Object convert(JaxBsonFieldContext var1, Binary var2);
    }

    @FunctionalInterface
    public static interface BinaryCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Collection<Binary> var2);
    }
}

