/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.adapters;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class JaxBsonAdapter<ValueType, BoundType> {
    protected JaxBsonAdapter() {
    }

    public Class<?> boundType(Class<?> valueType, String descr) {
        try {
            Method method = this.getClass().getDeclaredMethod("unmarshal", valueType);
            return method.getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("JaxBson XML java type adapter class '" + this.getClass().getName() + "' doesn't have a 'unmarshal' method to convert '" + valueType + "', for " + descr, e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot access method 'unmarshal' through reflection for class '" + this.getClass().getName() + "' and value type '" + valueType + "' for " + descr, e);
        }
    }

    public abstract ValueType marshal(BoundType var1) throws Exception;

    public abstract BoundType unmarshal(ValueType var1) throws Exception;

    public Class<?> valueType(Class<?> boundType, String descr) {
        try {
            Method method = this.getClass().getDeclaredMethod("marshal", boundType);
            return method.getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("JaxBson XML java type adapter class '" + this.getClass().getName() + "' doesn't have a 'marshal' method to convert '" + boundType + "', for " + descr, e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot access method 'marshal' through reflection for class '" + this.getClass().getName() + "' and value type '" + boundType + "' for " + descr, e);
        }
    }

    public Class<?> valueType(Field field) {
        return this.valueType(field.getType(), "field " + field.getName());
    }
}

