/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.qnixyz.jbson.annotations.JaxBsonIgnoreTransient;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.adapters.JaxBsonAdapter;
import org.qnixyz.jbson.annotations.cfg.JaxBsonIgnoreTransientImpl;
import org.qnixyz.jbson.annotations.cfg.Utils;

public class JaxBsonIgnoreTransientFieldMap {
    private final Map<Field, JaxBsonIgnoreTransient> map;

    private JaxBsonIgnoreTransientFieldMap() {
        this.map = null;
    }

    private JaxBsonIgnoreTransientFieldMap(Builder b) {
        this.map = b.map == null ? Collections.emptyMap() : Collections.unmodifiableMap(b.map);
    }

    public boolean containsKey(Field key) {
        return this.map == null ? false : this.map.containsKey(key);
    }

    public JaxBsonIgnoreTransient get(Field key) {
        Objects.requireNonNull(key);
        return this.map == null ? null : this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public Set<Field> keySet() {
        return this.map == null ? Collections.emptySet() : this.map.keySet();
    }

    public static class XmlAdapter
    extends JaxBsonAdapter<JaxBsonIgnoreTransientFieldMapType, JaxBsonIgnoreTransientFieldMap> {
        @Override
        public JaxBsonIgnoreTransientFieldMapType marshal(JaxBsonIgnoreTransientFieldMap v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonIgnoreTransientFieldMapType ret = new JaxBsonIgnoreTransientFieldMapType();
            for (Map.Entry e : v.map.entrySet()) {
                ret.add(new JaxBsonIgnoreTransientFieldMapEntry((Field)e.getKey(), (JaxBsonIgnoreTransient)e.getValue()));
            }
            return ret;
        }

        @Override
        public JaxBsonIgnoreTransientFieldMap unmarshal(JaxBsonIgnoreTransientFieldMapType v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            Builder ret = new Builder();
            for (JaxBsonIgnoreTransientFieldMapEntry e : v.set) {
                Field field = Utils.declaredFieldByName(e.fieldClass, e.fieldName);
                if (ret.containsKey(field)) {
                    throw new IllegalStateException("Multiple definitions of JaxBsonIgnoreTransientMap field: " + e.fieldClass + "." + e.fieldName);
                }
                ret.put(field, e.jaxBsonIgnoreTransient);
            }
            return ret.build();
        }
    }

    private static class JaxBsonIgnoreTransientFieldMapType {
        @JaxBsonName(name="entries")
        private SortedSet<JaxBsonIgnoreTransientFieldMapEntry> set;

        private JaxBsonIgnoreTransientFieldMapType() {
        }

        private void add(JaxBsonIgnoreTransientFieldMapEntry e) {
            Objects.requireNonNull(e);
            if (this.set == null) {
                this.set = new TreeSet<JaxBsonIgnoreTransientFieldMapEntry>();
            }
            this.set.add(e);
        }

        private boolean isEmpty() {
            return this.set == null || this.set.isEmpty();
        }
    }

    private static class JaxBsonIgnoreTransientFieldMapEntry
    implements Comparable<JaxBsonIgnoreTransientFieldMapEntry> {
        private String fieldClass;
        private String fieldName;
        private JaxBsonIgnoreTransientImpl jaxBsonIgnoreTransient;

        private JaxBsonIgnoreTransientFieldMapEntry() {
        }

        private JaxBsonIgnoreTransientFieldMapEntry(Field field, JaxBsonIgnoreTransient jaxBsonIgnoreTransient) {
            this.fieldClass = field.getDeclaringClass().getName();
            this.fieldName = field.getName();
            if (jaxBsonIgnoreTransient != null) {
                this.jaxBsonIgnoreTransient = jaxBsonIgnoreTransient instanceof JaxBsonIgnoreTransientImpl ? (JaxBsonIgnoreTransientImpl)jaxBsonIgnoreTransient : new JaxBsonIgnoreTransientImpl(jaxBsonIgnoreTransient);
            }
        }

        @Override
        public int compareTo(JaxBsonIgnoreTransientFieldMapEntry o) {
            if (o == null) {
                return 1;
            }
            int ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldClass, o.fieldClass);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldName, o.fieldName);
            if (ret != 0) {
                return ret;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxBsonIgnoreTransientFieldMapEntry other = (JaxBsonIgnoreTransientFieldMapEntry)obj;
            if (this.fieldClass == null ? other.fieldClass != null : !this.fieldClass.equals(other.fieldClass)) {
                return false;
            }
            return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldClass == null ? 0 : this.fieldClass.hashCode());
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            return result;
        }
    }

    public static class Builder {
        private Map<Field, JaxBsonIgnoreTransient> map;

        public JaxBsonIgnoreTransientFieldMap build() {
            return new JaxBsonIgnoreTransientFieldMap(this);
        }

        public boolean containsKey(Field key) {
            return this.map == null ? false : this.map.containsKey(key);
        }

        public JaxBsonIgnoreTransient get(Field key) {
            Objects.requireNonNull(key);
            return this.map == null ? null : this.map.get(key);
        }

        public boolean isEmpty() {
            return this.map == null || this.map.isEmpty();
        }

        public Set<Field> keySet() {
            return this.map == null ? Collections.emptySet() : this.map.keySet();
        }

        public Builder put(Field field, JaxBsonIgnoreTransient jaxBsonIgnoreTransient) {
            Objects.requireNonNull(field);
            Objects.requireNonNull(jaxBsonIgnoreTransient);
            if (this.map == null) {
                this.map = new HashMap<Field, JaxBsonIgnoreTransient>();
            }
            this.map.put(field, jaxBsonIgnoreTransient);
            return this;
        }

        public JaxBsonIgnoreTransient remove(Field field) {
            if (this.map == null) {
                return null;
            }
            return this.map.remove(field);
        }
    }
}

