/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.JaxBsonNumberHint;
import org.qnixyz.jbson.annotations.adapters.JaxBsonAdapter;
import org.qnixyz.jbson.annotations.cfg.JaxBsonNumberHintImpl;
import org.qnixyz.jbson.annotations.cfg.Utils;

public class JaxBsonNumberHintFieldMap {
    private final Map<Field, JaxBsonNumberHint> map;

    private JaxBsonNumberHintFieldMap() {
        this.map = null;
    }

    private JaxBsonNumberHintFieldMap(Builder b) {
        this.map = b.map == null ? Collections.emptyMap() : Collections.unmodifiableMap(b.map);
    }

    public boolean containsKey(Field key) {
        return this.map == null ? false : this.map.containsKey(key);
    }

    public JaxBsonNumberHint get(Field key) {
        Objects.requireNonNull(key);
        return this.map == null ? null : this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public Set<Field> keySet() {
        return this.map == null ? Collections.emptySet() : this.map.keySet();
    }

    public static class XmlAdapter
    extends JaxBsonAdapter<JaxBsonNumberHintFieldMapType, JaxBsonNumberHintFieldMap> {
        @Override
        public JaxBsonNumberHintFieldMapType marshal(JaxBsonNumberHintFieldMap v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonNumberHintFieldMapType ret = new JaxBsonNumberHintFieldMapType();
            for (Map.Entry e : v.map.entrySet()) {
                ret.add(new JaxBsonNumberHintFieldMapEntry((Field)e.getKey(), (JaxBsonNumberHint)e.getValue()));
            }
            return ret;
        }

        @Override
        public JaxBsonNumberHintFieldMap unmarshal(JaxBsonNumberHintFieldMapType v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            Builder ret = new Builder();
            for (JaxBsonNumberHintFieldMapEntry e : v.set) {
                Field field = Utils.declaredFieldByName(e.fieldClass, e.fieldName);
                if (ret.containsKey(field)) {
                    throw new IllegalStateException("Multiple definitions of JaxBsonNumberHintMap field: " + e.fieldClass + "." + e.fieldName);
                }
                ret.put(field, e.jaxBsonNumberHint);
            }
            return ret.build();
        }
    }

    private static class JaxBsonNumberHintFieldMapType {
        @JaxBsonName(name="entries")
        private SortedSet<JaxBsonNumberHintFieldMapEntry> set;

        private JaxBsonNumberHintFieldMapType() {
        }

        private void add(JaxBsonNumberHintFieldMapEntry e) {
            Objects.requireNonNull(e);
            if (this.set == null) {
                this.set = new TreeSet<JaxBsonNumberHintFieldMapEntry>();
            }
            this.set.add(e);
        }

        private boolean isEmpty() {
            return this.set == null || this.set.isEmpty();
        }
    }

    private static class JaxBsonNumberHintFieldMapEntry
    implements Comparable<JaxBsonNumberHintFieldMapEntry> {
        private String fieldClass;
        private String fieldName;
        private JaxBsonNumberHintImpl jaxBsonNumberHint;

        private JaxBsonNumberHintFieldMapEntry() {
        }

        private JaxBsonNumberHintFieldMapEntry(Field field, JaxBsonNumberHint jaxBsonNumberHint) {
            this.fieldClass = field.getDeclaringClass().getName();
            this.fieldName = field.getName();
            if (jaxBsonNumberHint != null) {
                this.jaxBsonNumberHint = jaxBsonNumberHint instanceof JaxBsonNumberHintImpl ? (JaxBsonNumberHintImpl)jaxBsonNumberHint : new JaxBsonNumberHintImpl.Builder(jaxBsonNumberHint).build();
            }
        }

        @Override
        public int compareTo(JaxBsonNumberHintFieldMapEntry o) {
            if (o == null) {
                return 1;
            }
            int ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldClass, o.fieldClass);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldName, o.fieldName);
            if (ret != 0) {
                return ret;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxBsonNumberHintFieldMapEntry other = (JaxBsonNumberHintFieldMapEntry)obj;
            if (this.fieldClass == null ? other.fieldClass != null : !this.fieldClass.equals(other.fieldClass)) {
                return false;
            }
            return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldClass == null ? 0 : this.fieldClass.hashCode());
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            return result;
        }
    }

    public static class Builder {
        private Map<Field, JaxBsonNumberHint> map;

        public JaxBsonNumberHintFieldMap build() {
            return new JaxBsonNumberHintFieldMap(this);
        }

        public boolean containsKey(Field key) {
            return this.map == null ? false : this.map.containsKey(key);
        }

        public JaxBsonNumberHint get(Field key) {
            Objects.requireNonNull(key);
            return this.map == null ? null : this.map.get(key);
        }

        public boolean isEmpty() {
            return this.map == null || this.map.isEmpty();
        }

        public Set<Field> keySet() {
            return this.map == null ? Collections.emptySet() : this.map.keySet();
        }

        public Builder put(Field field, JaxBsonNumberHint jaxBsonNumberHint) {
            Objects.requireNonNull(field);
            Objects.requireNonNull(jaxBsonNumberHint);
            if (this.map == null) {
                this.map = new HashMap<Field, JaxBsonNumberHint>();
            }
            this.map.put(field, jaxBsonNumberHint);
            return this;
        }

        public JaxBsonNumberHint remove(Field field) {
            if (this.map == null) {
                return null;
            }
            return this.map.remove(field);
        }
    }
}

