/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.annotation.Annotation;
import java.math.RoundingMode;
import java.util.Objects;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.JaxBsonNumberHint;

@JaxBsonName(name="jaxBsonNumberHint")
public class JaxBsonNumberHintImpl
implements JaxBsonNumberHint {
    public static final JaxBsonNumberHintImpl DEFAULT = new Builder().build();
    private final boolean asString;
    private final int precision;
    private final RoundingMode roundingMode;

    private JaxBsonNumberHintImpl() {
        this.asString = false;
        this.precision = 34;
        this.roundingMode = RoundingMode.HALF_UP;
    }

    private JaxBsonNumberHintImpl(Builder b) {
        this.asString = b.asString;
        this.precision = b.precision;
        this.roundingMode = Objects.requireNonNull(b.roundingMode);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return JaxBsonNumberHint.class;
    }

    @Override
    public boolean asString() {
        return this.asString;
    }

    @Override
    public int precision() {
        return this.precision;
    }

    @Override
    public RoundingMode roundingMode() {
        return this.roundingMode;
    }

    public static class Builder {
        private boolean asString = false;
        private int precision = 34;
        private RoundingMode roundingMode = RoundingMode.HALF_UP;

        public Builder() {
        }

        public Builder(JaxBsonNumberHint other) {
            this.other(other);
        }

        public Builder asString(boolean asString) {
            this.asString = asString;
            return this;
        }

        public JaxBsonNumberHintImpl build() {
            return new JaxBsonNumberHintImpl(this);
        }

        public Builder other(JaxBsonNumberHint other) {
            this.asString(other.asString());
            this.precision(other.precision());
            this.roundingMode(other.roundingMode());
            return this;
        }

        public Builder precision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder roundingMode(RoundingMode roundingMode) {
            this.roundingMode = Objects.requireNonNull(roundingMode);
            return this;
        }
    }
}

