/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.JaxBsonToBsonPost;
import org.qnixyz.jbson.annotations.adapters.JaxBsonAdapter;
import org.qnixyz.jbson.annotations.cfg.JaxBsonToBsonPostImpl;
import org.qnixyz.jbson.annotations.cfg.Utils;

public class JaxBsonToBsonPostMethodMap {
    private final Map<Method, JaxBsonToBsonPost> map;

    private JaxBsonToBsonPostMethodMap() {
        this.map = null;
    }

    private JaxBsonToBsonPostMethodMap(Builder b) {
        this.map = b.map == null ? Collections.emptyMap() : Collections.unmodifiableMap(b.map);
    }

    public boolean containsKey(Method key) {
        return this.map == null ? false : this.map.containsKey(key);
    }

    public JaxBsonToBsonPost get(Method key) {
        Objects.requireNonNull(key);
        return this.map == null ? null : this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public Set<Method> keySet() {
        return this.map == null ? Collections.emptySet() : this.map.keySet();
    }

    public static class XmlAdapter
    extends JaxBsonAdapter<JaxBsonToBsonPostMethodMapType, JaxBsonToBsonPostMethodMap> {
        @Override
        public JaxBsonToBsonPostMethodMapType marshal(JaxBsonToBsonPostMethodMap v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonToBsonPostMethodMapType ret = new JaxBsonToBsonPostMethodMapType();
            for (Map.Entry e : v.map.entrySet()) {
                ret.add(new JaxBsonToBsonPostMethodMapEntry((Method)e.getKey(), (JaxBsonToBsonPost)e.getValue()));
            }
            return ret;
        }

        @Override
        public JaxBsonToBsonPostMethodMap unmarshal(JaxBsonToBsonPostMethodMapType v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            Builder ret = new Builder();
            for (JaxBsonToBsonPostMethodMapEntry e : v.set) {
                Method method = Utils.declaredMethodByName(e.methodClass, e.methodName, e.methodParameterTypes);
                if (ret.containsKey(method)) {
                    throw new IllegalStateException("Multiple definitions of JaxBsonToBsonPostMap method: " + e.methodClass + "." + e.methodName);
                }
                ret.put(method, e.jaxBsonToBsonPost);
            }
            return ret.build();
        }
    }

    private static class JaxBsonToBsonPostMethodMapType {
        @JaxBsonName(name="entries")
        private SortedSet<JaxBsonToBsonPostMethodMapEntry> set;

        private JaxBsonToBsonPostMethodMapType() {
        }

        private void add(JaxBsonToBsonPostMethodMapEntry e) {
            Objects.requireNonNull(e);
            if (this.set == null) {
                this.set = new TreeSet<JaxBsonToBsonPostMethodMapEntry>();
            }
            this.set.add(e);
        }

        private boolean isEmpty() {
            return this.set == null || this.set.isEmpty();
        }
    }

    private static class JaxBsonToBsonPostMethodMapEntry
    implements Comparable<JaxBsonToBsonPostMethodMapEntry> {
        private JaxBsonToBsonPostImpl jaxBsonToBsonPost;
        private String methodClass;
        private String methodName;
        private List<String> methodParameterTypes;

        private JaxBsonToBsonPostMethodMapEntry() {
        }

        private JaxBsonToBsonPostMethodMapEntry(Method method, JaxBsonToBsonPost jaxBsonToBsonPost) {
            this.methodClass = method.getDeclaringClass().getName();
            this.methodName = method.getName();
            if (method.getParameterTypes() != null) {
                for (Class<?> pt : method.getParameterTypes()) {
                    this.addParameterType(pt);
                }
            }
            if (jaxBsonToBsonPost != null) {
                this.jaxBsonToBsonPost = jaxBsonToBsonPost instanceof JaxBsonToBsonPostImpl ? (JaxBsonToBsonPostImpl)jaxBsonToBsonPost : new JaxBsonToBsonPostImpl(jaxBsonToBsonPost);
            }
        }

        private void addParameterType(Class<?> pt) {
            if (this.methodParameterTypes == null) {
                this.methodParameterTypes = new ArrayList<String>();
            }
            this.methodParameterTypes.add(pt.getName());
        }

        @Override
        public int compareTo(JaxBsonToBsonPostMethodMapEntry o) {
            if (o == null) {
                return 1;
            }
            int ret = org.qnixyz.jbson.impl.Utils.compare(this.methodClass, o.methodClass);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compare(this.methodName, o.methodName);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compareStringLists(this.methodParameterTypes, o.methodParameterTypes);
            if (ret != 0) {
                return ret;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxBsonToBsonPostMethodMapEntry other = (JaxBsonToBsonPostMethodMapEntry)obj;
            if (this.methodClass == null ? other.methodClass != null : !this.methodClass.equals(other.methodClass)) {
                return false;
            }
            if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
                return false;
            }
            return !(this.methodParameterTypes == null ? other.methodParameterTypes != null : !this.methodParameterTypes.equals(other.methodParameterTypes));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.methodClass == null ? 0 : this.methodClass.hashCode());
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            result = 31 * result + (this.methodParameterTypes == null ? 0 : this.methodParameterTypes.hashCode());
            return result;
        }
    }

    public static class Builder {
        private Map<Method, JaxBsonToBsonPost> map;

        public JaxBsonToBsonPostMethodMap build() {
            return new JaxBsonToBsonPostMethodMap(this);
        }

        public boolean containsKey(Method key) {
            return this.map == null ? false : this.map.containsKey(key);
        }

        public JaxBsonToBsonPost get(Method key) {
            Objects.requireNonNull(key);
            return this.map == null ? null : this.map.get(key);
        }

        public boolean isEmpty() {
            return this.map == null || this.map.isEmpty();
        }

        public Set<Method> keySet() {
            return this.map == null ? Collections.emptySet() : this.map.keySet();
        }

        public Builder put(Method method, JaxBsonToBsonPost jaxBsonToBsonPost) {
            Objects.requireNonNull(method);
            Objects.requireNonNull(jaxBsonToBsonPost);
            if (this.map == null) {
                this.map = new HashMap<Method, JaxBsonToBsonPost>();
            }
            this.map.put(method, jaxBsonToBsonPost);
            return this;
        }

        public JaxBsonToBsonPost remove(Method method) {
            if (this.map == null) {
                return null;
            }
            return this.map.remove(method);
        }
    }
}

