/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.JaxBsonToObjectPre;
import org.qnixyz.jbson.annotations.adapters.JaxBsonAdapter;
import org.qnixyz.jbson.annotations.cfg.JaxBsonToObjectPreImpl;
import org.qnixyz.jbson.annotations.cfg.Utils;

public class JaxBsonToObjectPreMethodMap {
    private final Map<Method, JaxBsonToObjectPre> map;

    private JaxBsonToObjectPreMethodMap() {
        this.map = null;
    }

    private JaxBsonToObjectPreMethodMap(Builder b) {
        this.map = b.map == null ? Collections.emptyMap() : Collections.unmodifiableMap(b.map);
    }

    public boolean containsKey(Method key) {
        return this.map == null ? false : this.map.containsKey(key);
    }

    public JaxBsonToObjectPre get(Method key) {
        Objects.requireNonNull(key);
        return this.map == null ? null : this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public Set<Method> keySet() {
        return this.map == null ? Collections.emptySet() : this.map.keySet();
    }

    public static class XmlAdapter
    extends JaxBsonAdapter<JaxBsonToObjectPreMethodMapType, JaxBsonToObjectPreMethodMap> {
        @Override
        public JaxBsonToObjectPreMethodMapType marshal(JaxBsonToObjectPreMethodMap v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonToObjectPreMethodMapType ret = new JaxBsonToObjectPreMethodMapType();
            for (Map.Entry e : v.map.entrySet()) {
                ret.add(new JaxBsonToObjectPreMethodMapEntry((Method)e.getKey(), (JaxBsonToObjectPre)e.getValue()));
            }
            return ret;
        }

        @Override
        public JaxBsonToObjectPreMethodMap unmarshal(JaxBsonToObjectPreMethodMapType v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            Builder ret = new Builder();
            for (JaxBsonToObjectPreMethodMapEntry e : v.set) {
                Method method = Utils.declaredMethodByName(e.methodClass, e.methodName, e.methodParameterTypes);
                if (ret.containsKey(method)) {
                    throw new IllegalStateException("Multiple definitions of JaxBsonToObjectPreMap method: " + e.methodClass + "." + e.methodName);
                }
                ret.put(method, e.jaxBsonToObjectPre);
            }
            return ret.build();
        }
    }

    private static class JaxBsonToObjectPreMethodMapType {
        @JaxBsonName(name="entries")
        private SortedSet<JaxBsonToObjectPreMethodMapEntry> set;

        private JaxBsonToObjectPreMethodMapType() {
        }

        private void add(JaxBsonToObjectPreMethodMapEntry e) {
            Objects.requireNonNull(e);
            if (this.set == null) {
                this.set = new TreeSet<JaxBsonToObjectPreMethodMapEntry>();
            }
            this.set.add(e);
        }

        private boolean isEmpty() {
            return this.set == null || this.set.isEmpty();
        }
    }

    private static class JaxBsonToObjectPreMethodMapEntry
    implements Comparable<JaxBsonToObjectPreMethodMapEntry> {
        private JaxBsonToObjectPreImpl jaxBsonToObjectPre;
        private String methodClass;
        private String methodName;
        private List<String> methodParameterTypes;

        private JaxBsonToObjectPreMethodMapEntry() {
        }

        private JaxBsonToObjectPreMethodMapEntry(Method method, JaxBsonToObjectPre jaxBsonToObjectPre) {
            this.methodClass = method.getDeclaringClass().getName();
            this.methodName = method.getName();
            if (method.getParameterTypes() != null) {
                for (Class<?> pt : method.getParameterTypes()) {
                    this.addParameterType(pt);
                }
            }
            if (jaxBsonToObjectPre != null) {
                this.jaxBsonToObjectPre = jaxBsonToObjectPre instanceof JaxBsonToObjectPreImpl ? (JaxBsonToObjectPreImpl)jaxBsonToObjectPre : new JaxBsonToObjectPreImpl(jaxBsonToObjectPre);
            }
        }

        private void addParameterType(Class<?> pt) {
            if (this.methodParameterTypes == null) {
                this.methodParameterTypes = new ArrayList<String>();
            }
            this.methodParameterTypes.add(pt.getName());
        }

        @Override
        public int compareTo(JaxBsonToObjectPreMethodMapEntry o) {
            if (o == null) {
                return 1;
            }
            int ret = org.qnixyz.jbson.impl.Utils.compare(this.methodClass, o.methodClass);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compare(this.methodName, o.methodName);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compareStringLists(this.methodParameterTypes, o.methodParameterTypes);
            if (ret != 0) {
                return ret;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxBsonToObjectPreMethodMapEntry other = (JaxBsonToObjectPreMethodMapEntry)obj;
            if (this.methodClass == null ? other.methodClass != null : !this.methodClass.equals(other.methodClass)) {
                return false;
            }
            if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
                return false;
            }
            return !(this.methodParameterTypes == null ? other.methodParameterTypes != null : !this.methodParameterTypes.equals(other.methodParameterTypes));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.methodClass == null ? 0 : this.methodClass.hashCode());
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            return result;
        }
    }

    public static class Builder {
        private Map<Method, JaxBsonToObjectPre> map;

        public JaxBsonToObjectPreMethodMap build() {
            return new JaxBsonToObjectPreMethodMap(this);
        }

        public boolean containsKey(Method key) {
            return this.map == null ? false : this.map.containsKey(key);
        }

        public JaxBsonToObjectPre get(Method key) {
            Objects.requireNonNull(key);
            return this.map == null ? null : this.map.get(key);
        }

        public boolean isEmpty() {
            return this.map == null || this.map.isEmpty();
        }

        public Set<Method> keySet() {
            return this.map == null ? Collections.emptySet() : this.map.keySet();
        }

        public Builder put(Method field, JaxBsonToObjectPre jaxBsonIgnoreTransient) {
            Objects.requireNonNull(field);
            Objects.requireNonNull(jaxBsonIgnoreTransient);
            if (this.map == null) {
                this.map = new HashMap<Method, JaxBsonToObjectPre>();
            }
            this.map.put(field, jaxBsonIgnoreTransient);
            return this;
        }

        public JaxBsonToObjectPre remove(Method field) {
            if (this.map == null) {
                return null;
            }
            return this.map.remove(field);
        }
    }
}

