/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.JaxBsonTransient;
import org.qnixyz.jbson.annotations.adapters.JaxBsonAdapter;
import org.qnixyz.jbson.annotations.cfg.JaxBsonTransientImpl;
import org.qnixyz.jbson.annotations.cfg.Utils;

public class JaxBsonTransientFieldMap {
    private final Map<Field, JaxBsonTransient> map;

    private JaxBsonTransientFieldMap() {
        this.map = null;
    }

    private JaxBsonTransientFieldMap(Builder b) {
        this.map = b.map == null ? Collections.emptyMap() : Collections.unmodifiableMap(b.map);
    }

    public boolean containsKey(Field key) {
        return this.map == null ? false : this.map.containsKey(key);
    }

    public JaxBsonTransient get(Field key) {
        Objects.requireNonNull(key);
        return this.map == null ? null : this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public Set<Field> keySet() {
        return this.map == null ? Collections.emptySet() : this.map.keySet();
    }

    public static class XmlAdapter
    extends JaxBsonAdapter<JaxBsonTransientFieldMapType, JaxBsonTransientFieldMap> {
        @Override
        public JaxBsonTransientFieldMapType marshal(JaxBsonTransientFieldMap v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonTransientFieldMapType ret = new JaxBsonTransientFieldMapType();
            for (Map.Entry e : v.map.entrySet()) {
                ret.add(new JaxBsonTransientFieldMapEntry((Field)e.getKey(), (JaxBsonTransient)e.getValue()));
            }
            return ret;
        }

        @Override
        public JaxBsonTransientFieldMap unmarshal(JaxBsonTransientFieldMapType v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            Builder ret = new Builder();
            for (JaxBsonTransientFieldMapEntry e : v.set) {
                Field field = Utils.declaredFieldByName(e.fieldClass, e.fieldName);
                if (ret.containsKey(field)) {
                    throw new IllegalStateException("Multiple definitions of JaxBsonTransientMap field: " + e.fieldClass + "." + e.fieldName);
                }
                ret.put(field, e.jaxBsonTransient);
            }
            return ret.build();
        }
    }

    private static class JaxBsonTransientFieldMapType {
        @JaxBsonName(name="entries")
        private SortedSet<JaxBsonTransientFieldMapEntry> set;

        private JaxBsonTransientFieldMapType() {
        }

        private void add(JaxBsonTransientFieldMapEntry e) {
            Objects.requireNonNull(e);
            if (this.set == null) {
                this.set = new TreeSet<JaxBsonTransientFieldMapEntry>();
            }
            this.set.add(e);
        }

        private boolean isEmpty() {
            return this.set == null || this.set.isEmpty();
        }
    }

    private static class JaxBsonTransientFieldMapEntry
    implements Comparable<JaxBsonTransientFieldMapEntry> {
        private String fieldClass;
        private String fieldName;
        private JaxBsonTransientImpl jaxBsonTransient;

        private JaxBsonTransientFieldMapEntry() {
        }

        private JaxBsonTransientFieldMapEntry(Field field, JaxBsonTransient jaxBsonTransient) {
            this.fieldClass = field.getDeclaringClass().getName();
            this.fieldName = field.getName();
            if (jaxBsonTransient != null) {
                this.jaxBsonTransient = jaxBsonTransient instanceof JaxBsonTransientImpl ? (JaxBsonTransientImpl)jaxBsonTransient : new JaxBsonTransientImpl(jaxBsonTransient);
            }
        }

        @Override
        public int compareTo(JaxBsonTransientFieldMapEntry o) {
            if (o == null) {
                return 1;
            }
            int ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldClass, o.fieldClass);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldName, o.fieldName);
            if (ret != 0) {
                return ret;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxBsonTransientFieldMapEntry other = (JaxBsonTransientFieldMapEntry)obj;
            if (this.fieldClass == null ? other.fieldClass != null : !this.fieldClass.equals(other.fieldClass)) {
                return false;
            }
            return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldClass == null ? 0 : this.fieldClass.hashCode());
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            return result;
        }
    }

    public static class Builder {
        private Map<Field, JaxBsonTransient> map;

        public JaxBsonTransientFieldMap build() {
            return new JaxBsonTransientFieldMap(this);
        }

        public boolean containsKey(Field key) {
            return this.map == null ? false : this.map.containsKey(key);
        }

        public JaxBsonTransient get(Field key) {
            Objects.requireNonNull(key);
            return this.map == null ? null : this.map.get(key);
        }

        public boolean isEmpty() {
            return this.map == null || this.map.isEmpty();
        }

        public Set<Field> keySet() {
            return this.map == null ? Collections.emptySet() : this.map.keySet();
        }

        public Builder put(Field field, JaxBsonTransient jaxBsonIgnoreTransient) {
            Objects.requireNonNull(field);
            Objects.requireNonNull(jaxBsonIgnoreTransient);
            if (this.map == null) {
                this.map = new HashMap<Field, JaxBsonTransient>();
            }
            this.map.put(field, jaxBsonIgnoreTransient);
            return this;
        }

        public JaxBsonTransient remove(Field field) {
            if (this.map == null) {
                return null;
            }
            return this.map.remove(field);
        }
    }
}

