/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.JaxBsonXmlAnyAttributeMapping;
import org.qnixyz.jbson.annotations.adapters.JaxBsonAdapter;
import org.qnixyz.jbson.annotations.cfg.JaxBsonXmlAnyAttributeMappingImpl;
import org.qnixyz.jbson.annotations.cfg.Utils;

public class JaxBsonXmlAnyAttributeMappingFieldMap {
    private final Map<Field, JaxBsonXmlAnyAttributeMapping> map;

    private JaxBsonXmlAnyAttributeMappingFieldMap() {
        this.map = null;
    }

    private JaxBsonXmlAnyAttributeMappingFieldMap(Builder b) {
        this.map = b.map == null ? Collections.emptyMap() : Collections.unmodifiableMap(b.map);
    }

    public boolean containsKey(Field key) {
        return this.map == null ? false : this.map.containsKey(key);
    }

    public JaxBsonXmlAnyAttributeMapping get(Field key) {
        Objects.requireNonNull(key);
        return this.map == null ? null : this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public Set<Field> keySet() {
        return this.map == null ? Collections.emptySet() : this.map.keySet();
    }

    public static class XmlAdapter
    extends JaxBsonAdapter<JaxBsonXmlAnyAttributeMappingFieldMapType, JaxBsonXmlAnyAttributeMappingFieldMap> {
        @Override
        public JaxBsonXmlAnyAttributeMappingFieldMapType marshal(JaxBsonXmlAnyAttributeMappingFieldMap v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonXmlAnyAttributeMappingFieldMapType ret = new JaxBsonXmlAnyAttributeMappingFieldMapType();
            for (Map.Entry e : v.map.entrySet()) {
                ret.add(new JaxBsonXmlAnyAttributeMappingFieldMapEntry((Field)e.getKey(), (JaxBsonXmlAnyAttributeMapping)e.getValue()));
            }
            return ret;
        }

        @Override
        public JaxBsonXmlAnyAttributeMappingFieldMap unmarshal(JaxBsonXmlAnyAttributeMappingFieldMapType v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            Builder ret = new Builder();
            for (JaxBsonXmlAnyAttributeMappingFieldMapEntry e : v.set) {
                Field field = Utils.declaredFieldByName(e.fieldClass, e.fieldName);
                if (ret.containsKey(field)) {
                    throw new IllegalStateException("Multiple definitions of JaxBsonXmlAnyAttributeMappingMap field: " + e.fieldClass + "." + e.fieldName);
                }
                ret.put(field, e.jaxBsonXmlAnyAttributeMapping);
            }
            return ret.build();
        }
    }

    private static class JaxBsonXmlAnyAttributeMappingFieldMapType {
        @JaxBsonName(name="entries")
        private SortedSet<JaxBsonXmlAnyAttributeMappingFieldMapEntry> set;

        private JaxBsonXmlAnyAttributeMappingFieldMapType() {
        }

        private void add(JaxBsonXmlAnyAttributeMappingFieldMapEntry e) {
            Objects.requireNonNull(e);
            if (this.set == null) {
                this.set = new TreeSet<JaxBsonXmlAnyAttributeMappingFieldMapEntry>();
            }
            this.set.add(e);
        }

        private boolean isEmpty() {
            return this.set == null || this.set.isEmpty();
        }
    }

    private static class JaxBsonXmlAnyAttributeMappingFieldMapEntry
    implements Comparable<JaxBsonXmlAnyAttributeMappingFieldMapEntry> {
        private String fieldClass;
        private String fieldName;
        private JaxBsonXmlAnyAttributeMappingImpl jaxBsonXmlAnyAttributeMapping;

        private JaxBsonXmlAnyAttributeMappingFieldMapEntry() {
        }

        private JaxBsonXmlAnyAttributeMappingFieldMapEntry(Field field, JaxBsonXmlAnyAttributeMapping jaxBsonXmlAnyAttributeMapping) {
            this.fieldClass = field.getDeclaringClass().getName();
            this.fieldName = field.getName();
            if (jaxBsonXmlAnyAttributeMapping != null) {
                this.jaxBsonXmlAnyAttributeMapping = jaxBsonXmlAnyAttributeMapping instanceof JaxBsonXmlAnyAttributeMappingImpl ? (JaxBsonXmlAnyAttributeMappingImpl)jaxBsonXmlAnyAttributeMapping : new JaxBsonXmlAnyAttributeMappingImpl(jaxBsonXmlAnyAttributeMapping);
            }
        }

        @Override
        public int compareTo(JaxBsonXmlAnyAttributeMappingFieldMapEntry o) {
            if (o == null) {
                return 1;
            }
            int ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldClass, o.fieldClass);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldName, o.fieldName);
            if (ret != 0) {
                return ret;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxBsonXmlAnyAttributeMappingFieldMapEntry other = (JaxBsonXmlAnyAttributeMappingFieldMapEntry)obj;
            if (this.fieldClass == null ? other.fieldClass != null : !this.fieldClass.equals(other.fieldClass)) {
                return false;
            }
            return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldClass == null ? 0 : this.fieldClass.hashCode());
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            return result;
        }
    }

    public static class Builder {
        private Map<Field, JaxBsonXmlAnyAttributeMapping> map;

        public JaxBsonXmlAnyAttributeMappingFieldMap build() {
            return new JaxBsonXmlAnyAttributeMappingFieldMap(this);
        }

        public boolean containsKey(Field key) {
            return this.map == null ? false : this.map.containsKey(key);
        }

        public JaxBsonXmlAnyAttributeMapping get(Field key) {
            Objects.requireNonNull(key);
            return this.map == null ? null : this.map.get(key);
        }

        public boolean isEmpty() {
            return this.map == null || this.map.isEmpty();
        }

        public Set<Field> keySet() {
            return this.map == null ? Collections.emptySet() : this.map.keySet();
        }

        public Builder put(Field field, JaxBsonXmlAnyAttributeMapping jaxBsonIgnoreTransient) {
            Objects.requireNonNull(field);
            Objects.requireNonNull(jaxBsonIgnoreTransient);
            if (this.map == null) {
                this.map = new HashMap<Field, JaxBsonXmlAnyAttributeMapping>();
            }
            this.map.put(field, jaxBsonIgnoreTransient);
            return this;
        }

        public JaxBsonXmlAnyAttributeMapping remove(Field field) {
            if (this.map == null) {
                return null;
            }
            return this.map.remove(field);
        }
    }
}

