/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

public class Utils {
    private static final Class<?>[] NO_PARAMETER_TYPES = new Class[0];

    public static Class<?> classByNamne(String className) {
        return Utils.classByNamne(className, true);
    }

    public static Class<?> classByNamne(String className, boolean throwException) {
        Objects.requireNonNull(className);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (throwException) {
                throw new IllegalStateException("No class found where className=" + className, e);
            }
            return null;
        }
    }

    public static Field declaredFieldByName(Class<?> fieldClass, String fieldName) {
        Objects.requireNonNull(fieldClass);
        Objects.requireNonNull(fieldName);
        try {
            return fieldClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("No declared field found where fieldClass=" + fieldClass.getName() + " and fieldName=" + fieldName, e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot access declared field where fieldClass=" + fieldClass.getName() + " and fieldName=" + fieldName, e);
        }
    }

    public static Field declaredFieldByName(String fieldClass, String fieldName) {
        return Utils.declaredFieldByName(Utils.classByNamne(fieldClass), fieldName);
    }

    public static Method declaredMethodByName(Class<?> methodClass, String methodName, Class<?> ... methodParameterTypes) {
        try {
            return methodClass.getDeclaredMethod(methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No declared method where methodClass=" + methodClass.getName() + ", methodName=" + methodName + ", methodParameterTypes=" + methodParameterTypes, e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot access declared method where methodClass=" + methodClass.getName() + ", methodName=" + methodName + ", methodParameterTypes=" + methodParameterTypes, e);
        }
    }

    public static Method declaredMethodByName(String fieldClass, String methodName, List<String> methodParameterTypes) {
        return Utils.declaredMethodByName(Utils.classByNamne(fieldClass), methodName, Utils.parameterTypesByName(methodParameterTypes));
    }

    public static Class<?>[] parameterTypesByName(List<String> parameterTypes) {
        if (parameterTypes == null || parameterTypes.isEmpty()) {
            return NO_PARAMETER_TYPES;
        }
        Class[] ret = new Class[parameterTypes.size()];
        for (int i = 0; i < parameterTypes.size(); ++i) {
            String className = parameterTypes.get(i);
            ret[i] = Utils.classByNamne(className, false);
            if (ret[i] != null) continue;
            throw new IllegalStateException("Class not found for parameter type[" + i + "]: " + className);
        }
        return ret;
    }
}

