/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.qnixyz.jbson.annotations.adapters.JaxBsonAdapter;

public class JaxBsonAdapterHelper {
    private static final Class<?> JAKARTA_CLASS = JaxBsonAdapterHelper.loadClass("Jakarta");
    private static final Class<?> JAKARTA_JAXB_CLASS = JaxBsonAdapterHelper.loadJaxbClass("jakarta");
    private static final Constructor<?> JAKARTA_UTIL_CONSTRUCTOR = JaxBsonAdapterHelper.loadUtilConstructor(JAKARTA_CLASS);
    private static final Class<?> JAVAX_CLASS = JaxBsonAdapterHelper.loadClass("Javax");
    private static final Class<?> JAVAX_JAXB_CLASS = JaxBsonAdapterHelper.loadJaxbClass("javax");
    private static final Constructor<?> JAVAX_UTIL_CONSTRUCTOR = JaxBsonAdapterHelper.loadUtilConstructor(JAVAX_CLASS);

    public static JaxBsonAdapter<Object, Object> instance(Class<?> cls) {
        if (JAKARTA_JAXB_CLASS != null && JAKARTA_JAXB_CLASS.isAssignableFrom(cls)) {
            return JaxBsonAdapterHelper.instanceJakarta(cls);
        }
        if (JAVAX_JAXB_CLASS != null && JAVAX_JAXB_CLASS.isAssignableFrom(cls)) {
            return JaxBsonAdapterHelper.instanceJavax(cls);
        }
        if (JaxBsonAdapter.class.isAssignableFrom(cls)) {
            try {
                Constructor<?> c = cls.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                return (JaxBsonAdapter)c.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No empty constructor for class " + cls, e);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Security exception with empty constructor for class " + cls, e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Cannot instantiate class with empty constructor " + cls, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Illegal access exception with empty constructor for class " + cls, e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("This is a bug", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("This is a bug", e);
            }
        }
        return null;
    }

    private static JaxBsonAdapter<Object, Object> instanceJakarta(Class<?> cls) {
        try {
            return (JaxBsonAdapter)JAKARTA_UTIL_CONSTRUCTOR.newInstance(cls);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static JaxBsonAdapter<Object, Object> instanceJavax(Class<?> cls) {
        try {
            return (JaxBsonAdapter)JAVAX_UTIL_CONSTRUCTOR.newInstance(cls);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Class<?> loadClass(String suffix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(JaxBsonAdapterHelper.class.getName() + suffix);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.adapters.XmlAdapter");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Constructor<?> loadUtilConstructor(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        try {
            Constructor<?> ret = cls.getConstructor(Class.class);
            ret.setAccessible(true);
            return ret;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }
}

