/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.qnixyz.jbson.annotations.adapters.JaxBsonAdapter;

public class JaxBsonAdapterHelperJakarta
extends JaxBsonAdapter<Object, Object> {
    private final XmlAdapter<Object, Object> xmlAdapter;
    private final Class<?> xmlAdapterClass;

    public JaxBsonAdapterHelperJakarta(Class<?> xmlAdapterClass) {
        this.xmlAdapterClass = Objects.requireNonNull(xmlAdapterClass);
        if (!XmlAdapter.class.isAssignableFrom(xmlAdapterClass)) {
            throw new IllegalStateException("Class " + xmlAdapterClass + " is not a subclass of " + XmlAdapter.class);
        }
        this.xmlAdapter = this.instance();
    }

    @Override
    public Class<?> boundType(Class<?> valueType, String descr) {
        try {
            Method method = this.xmlAdapterClass.getDeclaredMethod("unmarshal", valueType);
            return method.getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("JaxBson XML java type adapter class '" + this.xmlAdapterClass.getName() + "' doesn't have a 'unmarshal' method to convert '" + valueType + "', for " + descr, e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot access method 'unmarshal' through reflection for class '" + this.xmlAdapterClass.getName() + "' and value type '" + valueType + "' for " + descr, e);
        }
    }

    private XmlAdapter<Object, Object> instance() {
        try {
            Constructor<?> c = this.xmlAdapterClass.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return (XmlAdapter)c.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Class has no empty constructor: " + this.xmlAdapterClass, e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate class with empty constructor: " + this.xmlAdapterClass, e);
        }
    }

    @Override
    public Object marshal(Object v) throws Exception {
        return this.xmlAdapter.marshal(v);
    }

    @Override
    public Object unmarshal(Object v) throws Exception {
        return this.xmlAdapter.unmarshal(v);
    }

    @Override
    public Class<?> valueType(Class<?> boundType, String descr) {
        try {
            Method method = this.xmlAdapterClass.getDeclaredMethod("marshal", boundType);
            return method.getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("XML java type adapter class '" + this.xmlAdapterClass.getName() + "' doesn't have a 'marshal' method to convert '" + boundType + "', for " + descr, e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot access method 'marshal' through reflection for class '" + this.xmlAdapterClass.getName() + "' and value type '" + boundType + "' for " + descr, e);
        }
    }
}

