/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.qnixyz.jbson.annotations.JaxBsonJavaTypeAdapter;

public class JaxBsonJavaTypeAdapterHelper {
    private static final Class<?> JAKARTA_JAXB_CLASS = JaxBsonJavaTypeAdapterHelper.loadJaxbClass("jakarta");
    private static final Class<?> JAKARTA_JAXBSON_CLASS = JaxBsonJavaTypeAdapterHelper.loadJaxBsonClass(JAKARTA_JAXB_CLASS, "Jakarta");
    private static final Method JAKARTA_JAXBSON_METHOD = JaxBsonJavaTypeAdapterHelper.loadJaxBsonJakartaMethod(JAKARTA_JAXBSON_CLASS, JAKARTA_JAXB_CLASS);
    private static final Class<?> JAVAX_JAXB_CLASS = JaxBsonJavaTypeAdapterHelper.loadJaxbClass("javax");
    private static final Class<?> JAVAX_JAXBSON_CLASS = JaxBsonJavaTypeAdapterHelper.loadJaxBsonClass(JAVAX_JAXB_CLASS, "Javax");
    private static final Method JAVAX_JAXBSON_METHOD = JaxBsonJavaTypeAdapterHelper.loadJaxBsonJakartaMethod(JAVAX_JAXBSON_CLASS, JAVAX_JAXB_CLASS);

    private static JaxBsonJavaTypeAdapter instanceJakarta(Annotation a) {
        try {
            return (JaxBsonJavaTypeAdapter)JAKARTA_JAXBSON_METHOD.invoke(null, a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static JaxBsonJavaTypeAdapter instanceJavax(Annotation a) {
        try {
            return (JaxBsonJavaTypeAdapter)JAVAX_JAXBSON_METHOD.invoke(null, a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    public static JaxBsonJavaTypeAdapter jaxBsonJavaTypeAdapter(Annotation a) {
        if (a.annotationType().equals(JaxBsonJavaTypeAdapter.class)) {
            return (JaxBsonJavaTypeAdapter)a;
        }
        if (a.annotationType().equals(JAKARTA_JAXB_CLASS)) {
            return JaxBsonJavaTypeAdapterHelper.instanceJakarta(a);
        }
        if (a.annotationType().equals(JAVAX_JAXB_CLASS)) {
            return JaxBsonJavaTypeAdapterHelper.instanceJavax(a);
        }
        return null;
    }

    public static JaxBsonJavaTypeAdapter jaxBsonJavaTypeAdapter(Annotation[] as) {
        if (as == null) {
            return null;
        }
        JaxBsonJavaTypeAdapter other = null;
        for (Annotation a : as) {
            if (a.annotationType().equals(JaxBsonJavaTypeAdapter.class)) {
                return (JaxBsonJavaTypeAdapter)a;
            }
            JaxBsonJavaTypeAdapter inst = JaxBsonJavaTypeAdapterHelper.jaxBsonJavaTypeAdapter(a);
            if (inst == null) continue;
            other = inst;
        }
        return other;
    }

    public static JaxBsonJavaTypeAdapter jaxBsonJavaTypeAdapter(Field field) {
        return JaxBsonJavaTypeAdapterHelper.jaxBsonJavaTypeAdapter(field.getAnnotations());
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> loadJaxBsonClass(Class<?> clsJaxb, String suffix) {
        try {
            if (clsJaxb == null) {
                return null;
            }
            return Thread.currentThread().getContextClassLoader().loadClass(JaxBsonJavaTypeAdapterHelper.class.getName() + suffix);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Method loadJaxBsonJakartaMethod(Class<?> cls, Class<?> clsJaxb) {
        if (clsJaxb == null) {
            return null;
        }
        try {
            Method ret = cls.getDeclaredMethod("jaxBsonJavaTypeAdapter", clsJaxb);
            ret.setAccessible(true);
            return ret;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }
}

