/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.helpers.XmlAttributeHelper;
import org.qnixyz.jbson.helpers.XmlElementHelper;
import org.qnixyz.jbson.helpers.XmlElementRefHelper;
import org.qnixyz.jbson.helpers.XmlElementWrapperHelper;
import org.qnixyz.jbson.helpers.XmlRootElementHelper;
import org.qnixyz.jbson.helpers.XmlTypeHelper;
import org.qnixyz.jbson.impl.Utils;

public class JaxBsonNameHelper {
    private static JaxBsonName create(final String name) {
        return new JaxBsonName(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return JaxBsonName.class;
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    public static JaxBsonName instance(Annotation[] as, boolean forField) {
        if (as == null) {
            return null;
        }
        XmlAttributeHelper ah = null;
        XmlElementHelper eh = null;
        XmlElementRefHelper erh = null;
        XmlElementWrapperHelper ewh = null;
        XmlTypeHelper th = null;
        for (Annotation a : as) {
            if (a.annotationType().equals(JaxBsonName.class)) {
                return (JaxBsonName)a;
            }
            if (forField) {
                ah = ah == null ? XmlAttributeHelper.instance(a) : ah;
                eh = eh == null ? XmlElementHelper.instance(a) : eh;
                erh = erh == null ? XmlElementRefHelper.instance(a) : erh;
                ewh = ewh == null ? XmlElementWrapperHelper.instance(a) : ewh;
                continue;
            }
            th = th == null ? XmlTypeHelper.instance(a) : th;
        }
        String name = JaxBsonNameHelper.makeName(th);
        if (name == null) {
            name = JaxBsonNameHelper.makeName(ewh);
        }
        if (name == null) {
            name = JaxBsonNameHelper.makeName(eh);
        }
        if (name == null) {
            name = JaxBsonNameHelper.makeName(ah);
        }
        if (name == null) {
            name = JaxBsonNameHelper.makeName(erh);
        }
        return name == null ? null : JaxBsonNameHelper.create(name);
    }

    public static JaxBsonName instance(Class<?> type) {
        return JaxBsonNameHelper.instance(type.getAnnotations(), false);
    }

    public static JaxBsonName instance(Field field) {
        return JaxBsonNameHelper.instance(field.getAnnotations(), true);
    }

    private static String makeName(XmlAttributeHelper h) {
        if (h == null) {
            return null;
        }
        if (Utils.isBlank(h.name())) {
            return null;
        }
        if (h.name().equalsIgnoreCase("##default")) {
            return null;
        }
        return h.name();
    }

    private static String makeName(XmlElementHelper h) {
        if (h == null) {
            return null;
        }
        if (Utils.isBlank(h.name())) {
            return null;
        }
        if (h.name().equalsIgnoreCase("##default")) {
            return null;
        }
        return h.name();
    }

    private static String makeName(XmlElementRefHelper h) {
        if (h == null) {
            return null;
        }
        if (h.isDefaultType()) {
            return null;
        }
        Class<?> type = h.type();
        XmlRootElementHelper xre = XmlRootElementHelper.instance(type);
        return JaxBsonNameHelper.makeName(xre, type);
    }

    private static String makeName(XmlElementWrapperHelper h) {
        if (h == null) {
            return null;
        }
        if (Utils.isBlank(h.name())) {
            return null;
        }
        if (h.name().equalsIgnoreCase("##default")) {
            return null;
        }
        return h.name();
    }

    private static String makeName(XmlRootElementHelper h, Class<?> type) {
        if (h == null || Utils.isBlank(h.name()) || h.name().equalsIgnoreCase("##default")) {
            return Utils.lcFirst(type.getSimpleName());
        }
        return h.name();
    }

    private static String makeName(XmlTypeHelper h) {
        if (h == null) {
            return null;
        }
        if (Utils.isBlank(h.name())) {
            return null;
        }
        if (h.name().equalsIgnoreCase("##default")) {
            return null;
        }
        return h.name();
    }
}

