/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.qnixyz.jbson.annotations.JaxBsonSeeAlso;
import org.qnixyz.jbson.helpers.XmlElementHelper;
import org.qnixyz.jbson.helpers.XmlElementRefHelper;
import org.qnixyz.jbson.helpers.XmlElementRefsHelper;
import org.qnixyz.jbson.helpers.XmlElementsHelper;
import org.qnixyz.jbson.helpers.XmlSeeAlsoHelper;

public class JaxBsonSeeAlsoHelper {
    private static void add(Set<Class<?>> set, Class<?> cls) {
        if (cls != null) {
            set.add(cls);
        }
    }

    private static void add(Set<Class<?>> set, Class<?>[] classes) {
        if (classes != null) {
            for (Class<?> cls : classes) {
                JaxBsonSeeAlsoHelper.add(set, cls);
            }
        }
    }

    private static JaxBsonSeeAlso create(Set<Class<?>> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        final Class[] arr = set.toArray(new Class[set.size()]);
        return new JaxBsonSeeAlso(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return JaxBsonSeeAlso.class;
            }

            @Override
            public Class<?>[] value() {
                return arr;
            }
        };
    }

    public static JaxBsonSeeAlso instance(Annotation[] as, boolean forField) {
        if (as == null) {
            return null;
        }
        HashSet set = new HashSet();
        for (Annotation a : as) {
            if (a.annotationType().equals(JaxBsonSeeAlso.class)) {
                JaxBsonSeeAlsoHelper.add(set, ((JaxBsonSeeAlso)a).value());
                continue;
            }
            Object h = XmlSeeAlsoHelper.instance(a);
            if (h != null) {
                JaxBsonSeeAlsoHelper.add(set, ((XmlSeeAlsoHelper)h).value());
                continue;
            }
            h = XmlElementHelper.instance(a);
            if (h != null && !((XmlElementHelper)h).isDefaultType()) {
                JaxBsonSeeAlsoHelper.add(set, ((XmlElementHelper)h).type());
                continue;
            }
            Object hs = XmlElementsHelper.instance(a);
            if (hs != null) {
                if (((XmlElementsHelper)hs).value() == null) continue;
                for (XmlElementHelper xmlElementHelper : ((XmlElementsHelper)hs).value()) {
                    if (xmlElementHelper == null || xmlElementHelper.isDefaultType()) continue;
                    JaxBsonSeeAlsoHelper.add(set, xmlElementHelper.type());
                }
                continue;
            }
            h = XmlElementRefHelper.instance(a);
            if (h != null) {
                JaxBsonSeeAlsoHelper.add(set, ((XmlElementRefHelper)h).type());
                continue;
            }
            hs = XmlElementRefsHelper.instance(a);
            if (hs == null || ((XmlElementRefsHelper)hs).value() == null) continue;
            for (XmlElementRefHelper xmlElementRefHelper : ((XmlElementRefsHelper)hs).value()) {
                if (xmlElementRefHelper == null) continue;
                JaxBsonSeeAlsoHelper.add(set, xmlElementRefHelper.type());
            }
        }
        return JaxBsonSeeAlsoHelper.create(set);
    }

    public static JaxBsonSeeAlso instance(Class<?> type) {
        return JaxBsonSeeAlsoHelper.instance(type.getAnnotations(), false);
    }

    public static JaxBsonSeeAlso instance(Field field) {
        return JaxBsonSeeAlsoHelper.instance(field.getAnnotations(), true);
    }
}

