/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public abstract class XmlAnyAttributeHelper {
    private static final Class<?> JAKARTA_JAXB_CLASS = XmlAnyAttributeHelper.loadJaxbClass("jakarta");
    private static final Constructor<? extends XmlAnyAttributeHelper> JAKARTA_JAXBSON_CONSTRUCTOR = XmlAnyAttributeHelper.getJaxBsonJakartaConstructor(JAKARTA_JAXB_CLASS, "Jakarta");
    private static final Class<?> JAVAX_JAXB_CLASS = XmlAnyAttributeHelper.loadJaxbClass("javax");
    private static final Constructor<? extends XmlAnyAttributeHelper> JAVAX_JAXBSON_CONSTRUCTOR = XmlAnyAttributeHelper.getJaxBsonJakartaConstructor(JAVAX_JAXB_CLASS, "Javax");

    private static Constructor<? extends XmlAnyAttributeHelper> getJaxBsonJakartaConstructor(Class<?> clsJaxb, String suffix) {
        if (clsJaxb == null) {
            return null;
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(XmlAnyAttributeHelper.class.getName() + suffix);
            Constructor<?> ret = cls.getDeclaredConstructor(clsJaxb);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    public static XmlAnyAttributeHelper instance(Annotation a) {
        if (a.annotationType().equals(JAKARTA_JAXB_CLASS)) {
            return XmlAnyAttributeHelper.instanceJakarta(a);
        }
        if (a.annotationType().equals(JAVAX_JAXB_CLASS)) {
            return XmlAnyAttributeHelper.instanceJavax(a);
        }
        return null;
    }

    public static XmlAnyAttributeHelper instance(Annotation[] as) {
        if (as == null) {
            return null;
        }
        for (Annotation a : as) {
            XmlAnyAttributeHelper ret = XmlAnyAttributeHelper.instance(a);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static XmlAnyAttributeHelper instance(Field field) {
        return XmlAnyAttributeHelper.instance(field.getAnnotations());
    }

    private static XmlAnyAttributeHelper instanceJakarta(Annotation o) {
        try {
            return JAKARTA_JAXBSON_CONSTRUCTOR.newInstance(o);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static XmlAnyAttributeHelper instanceJavax(Annotation o) {
        try {
            return JAVAX_JAXBSON_CONSTRUCTOR.newInstance(o);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.XmlAnyAttribute");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public abstract Class<? extends Annotation> annotationType();
}

