/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public abstract class XmlAttributeHelper {
    private static final Class<?> JAKARTA_JAXB_CLASS = XmlAttributeHelper.loadJaxbClass("jakarta");
    private static final Constructor<? extends XmlAttributeHelper> JAKARTA_JAXBSON_CONSTRUCTOR = XmlAttributeHelper.getJaxBsonConstructor(JAKARTA_JAXB_CLASS, "Jakarta");
    private static final Class<?> JAVAX_JAXB_CLASS = XmlAttributeHelper.loadJaxbClass("javax");
    private static final Constructor<? extends XmlAttributeHelper> JAVAX_JAXBSON_CONSTRUCTOR = XmlAttributeHelper.getJaxBsonConstructor(JAVAX_JAXB_CLASS, "Javax");

    private static Constructor<? extends XmlAttributeHelper> getJaxBsonConstructor(Class<?> clsJaxb, String suffix) {
        if (clsJaxb == null) {
            return null;
        }
        try {
            Class<?> clsHelper = Thread.currentThread().getContextClassLoader().loadClass(XmlAttributeHelper.class.getName() + suffix);
            Constructor<?> ret = clsHelper.getDeclaredConstructor(clsJaxb);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    public static XmlAttributeHelper instance(Annotation a) {
        if (a.annotationType().equals(JAKARTA_JAXB_CLASS)) {
            return XmlAttributeHelper.instanceJakarta(a);
        }
        if (a.annotationType().equals(JAVAX_JAXB_CLASS)) {
            return XmlAttributeHelper.instanceJavax(a);
        }
        return null;
    }

    public static XmlAttributeHelper instance(Annotation[] as) {
        if (as == null) {
            return null;
        }
        for (Annotation a : as) {
            XmlAttributeHelper ret = XmlAttributeHelper.instance(a);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static XmlAttributeHelper instance(Field field) {
        return XmlAttributeHelper.instance(field.getAnnotations());
    }

    private static XmlAttributeHelper instanceJakarta(Annotation a) {
        try {
            return JAKARTA_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static XmlAttributeHelper instanceJavax(Annotation a) {
        try {
            return JAVAX_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.XmlAttribute");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public abstract String name();

    public abstract String namespace();

    public abstract boolean required();
}

