/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public abstract class XmlElementHelper {
    private static final Class<?> JAKARTA_JAXB_CLASS = XmlElementHelper.loadJaxbClass("jakarta");
    private static final Constructor<? extends XmlElementHelper> JAKARTA_JAXBSON_CONSTRUCTOR = XmlElementHelper.getJaxBsonConstructor(JAKARTA_JAXB_CLASS, "Jakarta");
    private static final Class<?> JAVAX_JAXB_CLASS = XmlElementHelper.loadJaxbClass("javax");
    private static final Constructor<? extends XmlElementHelper> JAVAX_JAXBSON_CONSTRUCTOR = XmlElementHelper.getJaxBsonConstructor(JAVAX_JAXB_CLASS, "Javax");

    private static Constructor<? extends XmlElementHelper> getJaxBsonConstructor(Class<?> clsJaxb, String suffix) {
        if (clsJaxb == null) {
            return null;
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(XmlElementHelper.class.getName() + suffix);
            Constructor<?> ret = cls.getDeclaredConstructor(clsJaxb);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    public static XmlElementHelper instance(Annotation a) {
        if (a.annotationType().equals(JAKARTA_JAXB_CLASS)) {
            return XmlElementHelper.instanceJakarta(a);
        }
        if (a.annotationType().equals(JAVAX_JAXB_CLASS)) {
            return XmlElementHelper.instanceJavax(a);
        }
        return null;
    }

    public static XmlElementHelper instance(Annotation[] as) {
        if (as == null) {
            return null;
        }
        for (Annotation a : as) {
            XmlElementHelper ret = XmlElementHelper.instance(a);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static XmlElementHelper instance(Field field) {
        return XmlElementHelper.instance(field.getAnnotations());
    }

    private static XmlElementHelper instanceJakarta(Annotation a) {
        try {
            return JAKARTA_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static XmlElementHelper instanceJavax(Annotation a) {
        try {
            return JAVAX_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.XmlElement");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public abstract String defaultValue();

    public abstract boolean isDefaultType();

    public abstract String name();

    public abstract String namespace();

    public abstract boolean nillable();

    public abstract boolean required();

    public abstract Class<?> type();
}

