/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public abstract class XmlElementRefHelper {
    private static final Class<?> JAKARTA_JAXB_CLASS = XmlElementRefHelper.loadJaxbClass("jakarta");
    private static final Constructor<? extends XmlElementRefHelper> JAKARTA_JAXBSON_CONSTRUCTOR = XmlElementRefHelper.getJaxBsonConstructor(JAKARTA_JAXB_CLASS, "Jakarta");
    private static final Class<?> JAVAX_JAXB_CLASS = XmlElementRefHelper.loadJaxbClass("javax");
    private static final Constructor<? extends XmlElementRefHelper> JAVAX_JAXBSON_CONSTRUCTOR = XmlElementRefHelper.getJaxBsonConstructor(JAVAX_JAXB_CLASS, "Javax");

    private static Constructor<? extends XmlElementRefHelper> getJaxBsonConstructor(Class<?> clsJaxb, String suffix) {
        if (clsJaxb == null) {
            return null;
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(XmlElementRefHelper.class.getName() + suffix);
            Constructor<?> ret = cls.getDeclaredConstructor(clsJaxb);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    public static XmlElementRefHelper instance(Annotation a) {
        if (a.annotationType().equals(JAKARTA_JAXB_CLASS)) {
            return XmlElementRefHelper.instanceJakarta(a);
        }
        if (a.annotationType().equals(JAVAX_JAXB_CLASS)) {
            return XmlElementRefHelper.instanceJavax(a);
        }
        return null;
    }

    public static XmlElementRefHelper instance(Annotation[] as) {
        if (as == null) {
            return null;
        }
        for (Annotation a : as) {
            XmlElementRefHelper ret = XmlElementRefHelper.instance(a);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static XmlElementRefHelper instance(Field field) {
        return XmlElementRefHelper.instance(field.getAnnotations());
    }

    private static XmlElementRefHelper instanceJakarta(Annotation a) {
        try {
            return JAKARTA_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static XmlElementRefHelper instanceJavax(Annotation a) {
        try {
            return JAVAX_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.XmlElementRef");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public abstract boolean isDefaultType();

    public abstract String name();

    public abstract String namespace();

    public abstract boolean required();

    public abstract Class<?> type();
}

