/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public abstract class XmlEnumValueHelper {
    private static final Class<?> JAKARTA_JAXB_CLASS = XmlEnumValueHelper.loadJaxbClass("jakarta");
    private static final Constructor<? extends XmlEnumValueHelper> JAKARTA_JAXBSON_CONSTRUCTOR = XmlEnumValueHelper.getJaxBsonConstructor(JAKARTA_JAXB_CLASS, "Jakarta");
    private static final Class<?> JAVAX_JAXB_CLASS = XmlEnumValueHelper.loadJaxbClass("javax");
    private static final Constructor<? extends XmlEnumValueHelper> JAVAX_JAXBSON_CONSTRUCTOR = XmlEnumValueHelper.getJaxBsonConstructor(JAVAX_JAXB_CLASS, "Javax");

    private static Constructor<? extends XmlEnumValueHelper> getJaxBsonConstructor(Class<?> clsJaxb, String suffix) {
        if (clsJaxb == null) {
            return null;
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(XmlEnumValueHelper.class.getName() + suffix);
            Constructor<?> ret = cls.getDeclaredConstructor(clsJaxb);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    public static XmlEnumValueHelper instance(Annotation a) {
        if (a.annotationType().equals(JAKARTA_JAXB_CLASS)) {
            return XmlEnumValueHelper.instanceJakarta(a);
        }
        if (a.annotationType().equals(JAVAX_JAXB_CLASS)) {
            return XmlEnumValueHelper.instanceJavax(a);
        }
        return null;
    }

    public static XmlEnumValueHelper instance(Annotation[] as) {
        if (as == null) {
            return null;
        }
        for (Annotation a : as) {
            XmlEnumValueHelper ret = XmlEnumValueHelper.instance(a);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static XmlEnumValueHelper instance(Field field) {
        return XmlEnumValueHelper.instance(field.getAnnotations());
    }

    private static XmlEnumValueHelper instanceJakarta(Annotation a) {
        try {
            return JAKARTA_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static XmlEnumValueHelper instanceJavax(Annotation a) {
        try {
            return JAVAX_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.XmlEnumValue");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public abstract Class<? extends Annotation> annotationType();

    public abstract String value();
}

