/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class XmlRootElementHelper {
    private static final Class<?> JAKARTA_JAXB_CLASS = XmlRootElementHelper.loadJaxbClass("jakarta");
    private static final Constructor<? extends XmlRootElementHelper> JAKARTA_JAXBSON_CONSTRUCTOR = XmlRootElementHelper.getJaxBsonConstructor(JAKARTA_JAXB_CLASS, "Jakarta");
    private static final Class<?> JAVAX_JAXB_CLASS = XmlRootElementHelper.loadJaxbClass("javax");
    private static final Constructor<? extends XmlRootElementHelper> JAVAX_JAXBSON_CONSTRUCTOR = XmlRootElementHelper.getJaxBsonConstructor(JAVAX_JAXB_CLASS, "Javax");

    private static Constructor<? extends XmlRootElementHelper> getJaxBsonConstructor(Class<?> clsJavax, String suffix) {
        if (clsJavax == null) {
            return null;
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(XmlRootElementHelper.class.getName() + suffix);
            Constructor<?> ret = cls.getDeclaredConstructor(clsJavax);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    public static XmlRootElementHelper instance(Annotation a) {
        if (a.annotationType().equals(JAKARTA_JAXB_CLASS)) {
            return XmlRootElementHelper.instanceJakarta(a);
        }
        if (a.annotationType().equals(JAVAX_JAXB_CLASS)) {
            return XmlRootElementHelper.instanceJavax(a);
        }
        return null;
    }

    public static XmlRootElementHelper instance(Annotation[] as) {
        if (as == null) {
            return null;
        }
        for (Annotation a : as) {
            XmlRootElementHelper ret = XmlRootElementHelper.instance(a);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static XmlRootElementHelper instance(Class<?> type) {
        return XmlRootElementHelper.instance(type.getAnnotations());
    }

    private static XmlRootElementHelper instanceJakarta(Annotation a) {
        try {
            return JAKARTA_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static XmlRootElementHelper instanceJavax(Annotation a) {
        try {
            return JAVAX_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.XmlRootElement");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public abstract Class<? extends Annotation> annotationType();

    public abstract String name();

    public abstract String namespace();
}

