/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class XmlSeeAlsoHelper {
    private static final Class<?> JAKARTA_JAXB_CLASS = XmlSeeAlsoHelper.loadJaxbClass("jakarta");
    private static final Constructor<? extends XmlSeeAlsoHelper> JAKARTA_JAXBSON_CONSTRUCTOR = XmlSeeAlsoHelper.getJaxBsonJakartaConstructor(JAKARTA_JAXB_CLASS, "Jakarta");
    private static final Class<?> JAVAX_JAXB_CLASS = XmlSeeAlsoHelper.loadJaxbClass("javax");
    private static final Constructor<? extends XmlSeeAlsoHelper> JAVAX_JAXBSON_CONSTRUCTOR = XmlSeeAlsoHelper.getJaxBsonJakartaConstructor(JAVAX_JAXB_CLASS, "Javax");

    private static Constructor<? extends XmlSeeAlsoHelper> getJaxBsonJakartaConstructor(Class<?> clsJaxb, String suffix) {
        if (clsJaxb == null) {
            return null;
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(XmlSeeAlsoHelper.class.getName() + suffix);
            Constructor<?> ret = cls.getDeclaredConstructor(clsJaxb);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    public static XmlSeeAlsoHelper instance(Annotation a) {
        if (a.annotationType().equals(JAKARTA_JAXB_CLASS)) {
            return XmlSeeAlsoHelper.instanceJakarta(a);
        }
        if (a.annotationType().equals(JAVAX_JAXB_CLASS)) {
            return XmlSeeAlsoHelper.instanceJavax(a);
        }
        return null;
    }

    public static XmlSeeAlsoHelper instance(Annotation[] as) {
        if (as == null) {
            return null;
        }
        for (Annotation a : as) {
            XmlSeeAlsoHelper ret = XmlSeeAlsoHelper.instance(a);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static XmlSeeAlsoHelper instance(Class<?> type) {
        return XmlSeeAlsoHelper.instance(type.getAnnotations());
    }

    private static XmlSeeAlsoHelper instanceJakarta(Annotation a) {
        try {
            return JAKARTA_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static XmlSeeAlsoHelper instanceJavax(Annotation a) {
        try {
            return JAVAX_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.XmlSeeAlso");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public abstract Class<? extends Annotation> annotationType();

    public abstract Class<?>[] value();
}

