/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class XmlTypeHelper {
    private static final Class<?> JAKARTA_JAXB_CLASS = XmlTypeHelper.loadJaxbClass("jakarta");
    private static final Constructor<? extends XmlTypeHelper> JAKARTA_JAXBSON_CONSTRUCTOR = XmlTypeHelper.getJaxBsonConstructor(JAKARTA_JAXB_CLASS, "Jakarta");
    private static final Class<?> JAVAX_JAXB_CLASS = XmlTypeHelper.loadJaxbClass("javax");
    private static final Constructor<? extends XmlTypeHelper> JAVAX_JAXBSON_CONSTRUCTOR = XmlTypeHelper.getJaxBsonConstructor(JAVAX_JAXB_CLASS, "Javax");

    private static Constructor<? extends XmlTypeHelper> getJaxBsonConstructor(Class<?> clsPrefix, String suffix) {
        if (clsPrefix == null) {
            return null;
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(XmlTypeHelper.class.getName() + suffix);
            Constructor<?> ret = cls.getDeclaredConstructor(clsPrefix);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    public static XmlTypeHelper instance(Annotation a) {
        if (a.annotationType().equals(JAKARTA_JAXB_CLASS)) {
            return XmlTypeHelper.instanceJakarta(a);
        }
        if (a.annotationType().equals(JAVAX_JAXB_CLASS)) {
            return XmlTypeHelper.instanceJavax(a);
        }
        return null;
    }

    public static XmlTypeHelper instance(Annotation[] as) {
        if (as == null) {
            return null;
        }
        for (Annotation a : as) {
            XmlTypeHelper ret = XmlTypeHelper.instance(a);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static XmlTypeHelper instance(Class<?> type) {
        return XmlTypeHelper.instance(type.getAnnotations());
    }

    private static XmlTypeHelper instanceJakarta(Annotation a) {
        try {
            return JAKARTA_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static XmlTypeHelper instanceJavax(Annotation a) {
        try {
            return JAVAX_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.XmlType");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public abstract Class<? extends Annotation> annotationType();

    public abstract Class<?> factoryClass();

    public abstract String factoryMethod();

    public abstract String name();

    public abstract String namespace();

    public abstract String[] propOrder();
}

