/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public abstract class XmlValueHelper {
    private static final Class<?> JAKARTA_JAXB_CLASS = XmlValueHelper.loadJaxbClass("jakarta");
    private static final Constructor<? extends XmlValueHelper> JAKARTA_JAXBSON_CONSTRUCTOR = XmlValueHelper.getJaxBsonConstructor(JAKARTA_JAXB_CLASS, "Jakarta");
    private static final Class<?> JAVAX_JAXB_CLASS = XmlValueHelper.loadJaxbClass("javax");
    private static final Constructor<? extends XmlValueHelper> JAVAX_JAXBSON_CONSTRUCTOR = XmlValueHelper.getJaxBsonConstructor(JAVAX_JAXB_CLASS, "Javax");

    private static Constructor<? extends XmlValueHelper> getJaxBsonConstructor(Class<?> clsJaxb, String suffix) {
        if (clsJaxb == null) {
            return null;
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(XmlValueHelper.class.getName() + suffix);
            Constructor<?> ret = cls.getDeclaredConstructor(clsJaxb);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    public static XmlValueHelper instance(Annotation a) {
        if (a.annotationType().equals(JAKARTA_JAXB_CLASS)) {
            return XmlValueHelper.instanceJakarta(a);
        }
        if (a.annotationType().equals(JAVAX_JAXB_CLASS)) {
            return XmlValueHelper.instanceJavax(a);
        }
        return null;
    }

    public static XmlValueHelper instance(Annotation[] as) {
        if (as == null) {
            return null;
        }
        for (Annotation a : as) {
            XmlValueHelper ret = XmlValueHelper.instance(a);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static XmlValueHelper instance(Field field) {
        return XmlValueHelper.instance(field.getAnnotations());
    }

    private static XmlValueHelper instanceJakarta(Annotation a) {
        try {
            return JAKARTA_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static XmlValueHelper instanceJavax(Annotation a) {
        try {
            return JAVAX_JAXBSON_CONSTRUCTOR.newInstance(a);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("This is a bug", e);
        }
    }

    private static Class<?> loadJaxbClass(String prefix) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(prefix + ".xml.bind.annotation.XmlValue");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public abstract Class<? extends Annotation> annotationType();
}

