/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bson.Document;
import org.qnixyz.jbson.annotations.adapters.JaxBsonAdapter;
import org.qnixyz.jbson.impl.FieldDescriptor;
import org.qnixyz.jbson.impl.JaxBsonContextImpl;
import org.qnixyz.jbson.impl.SimpleTypes;
import org.qnixyz.jbson.impl.ValueContainerType;

class FieldSubDescriptor {
    private final JaxBsonContextImpl ctx;
    private final FieldDescriptor fd;
    private final Class<?> mainType;
    private final String name;
    private final Set<Class<?>> referredTypes = new HashSet();
    private final boolean simpleType;
    private final ValueContainerType vct;
    private final JaxBsonAdapter<Object, Object> xmlAdapter;

    protected FieldSubDescriptor(JaxBsonContextImpl ctx, FieldDescriptor fd, String name, ValueContainerType vct, Class<?> mainType, JaxBsonAdapter<Object, Object> xmlAdapter) {
        this.ctx = ctx;
        this.fd = fd;
        this.name = name;
        this.vct = vct;
        this.mainType = mainType;
        this.xmlAdapter = xmlAdapter;
        this.simpleType = SimpleTypes.isSimpleType(ctx.getConfiguration(), mainType);
        if (!this.simpleType) {
            this.referredTypes.add(mainType);
        }
    }

    public Document debugInfo() {
        Document ret = new Document();
        ret.append("name", (Object)this.name);
        ret.append("mainType", this.mainType == null ? this.mainType : this.mainType.getName());
        ret.append("simpleType", (Object)this.simpleType);
        ret.append("vct", this.vct == null ? null : this.vct.name());
        ret.append("xmlAdapterClass", this.xmlAdapter == null ? this.xmlAdapter : this.xmlAdapter.getClass().getName());
        return ret;
    }

    private Object firstNonNull(List<?> l) {
        for (Object e : l) {
            if (e == null) continue;
            return e;
        }
        return null;
    }

    protected JaxBsonContextImpl getCtx() {
        return this.ctx;
    }

    protected FieldDescriptor getFd() {
        return this.fd;
    }

    protected Field getField() {
        return this.fd.getField();
    }

    protected Class<?> getMainType() {
        return this.mainType;
    }

    protected String getName() {
        return this.name;
    }

    protected Set<Class<?>> getReferredTypes() {
        return this.referredTypes;
    }

    protected boolean isArray() {
        return this.vct.isArray();
    }

    private boolean isBsonDocument(Object bsonValue) {
        return bsonValue != null && Document.class.isAssignableFrom(bsonValue.getClass());
    }

    protected boolean isCollection() {
        return this.vct.isCollection();
    }

    protected boolean isList() {
        return this.vct == ValueContainerType.LIST;
    }

    private boolean isListOfBsonDocument(Object bsonValue) {
        if (bsonValue == null) {
            return false;
        }
        if (!List.class.isAssignableFrom(bsonValue.getClass())) {
            return false;
        }
        if (((List)bsonValue).isEmpty()) {
            return true;
        }
        Object e = this.firstNonNull((List)bsonValue);
        if (e == null) {
            return false;
        }
        return this.isBsonDocument(e);
    }

    protected boolean isSet() {
        return this.vct == ValueContainerType.SET;
    }

    protected boolean isSimpleType() {
        return this.simpleType;
    }

    protected boolean isSortedSet() {
        return this.vct == ValueContainerType.SORTED_SET;
    }

    private Object marshal(Object o) {
        if (this.xmlAdapter == null) {
            return o;
        }
        try {
            return this.xmlAdapter.marshal(o);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception at handling JaxBsonXmlAdapter, when attempting to call " + this.xmlAdapter.getClass().getName() + ".marshal(Object)", e);
        }
    }

    private void setField(Object obj, Object value) {
        try {
            this.getField().set(obj, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected void toBson(Document bson, Object value, boolean omitType) {
        value = this.marshal(value);
        if (this.isSimpleType()) {
            value = this.ctx.getSimpleTypes().toBson(this.fd.getFieldCtx(), value);
            bson.put(this.name, value);
        } else if (value != null) {
            if (value.getClass().isArray()) {
                ArrayList<Document> list = new ArrayList<Document>();
                for (Object e2 : (Object[])value) {
                    list.add(this.ctx.toBson(e2, omitType));
                }
                bson.put(this.name, list);
            } else if (Collection.class.isAssignableFrom(value.getClass())) {
                ArrayList list = new ArrayList();
                ((Collection)value).forEach(e -> list.add(this.ctx.toBson(e, omitType)));
                bson.put(this.name, list);
            } else {
                bson.put(this.name, (Object)this.ctx.toBson(value, omitType));
            }
        }
    }

    protected void toObject(Object o, Object bsonValue) {
        if (this.isBsonDocument(bsonValue)) {
            String typeNameInBson = ((Document)bsonValue).getString((Object)this.ctx.getConfiguration().getTypeFieldName());
            Object obj = typeNameInBson == null && this.fd.isOneMainType() ? this.ctx.toObject((Document)bsonValue, this.mainType) : this.ctx.toObject((Document)bsonValue);
            obj = this.unmarshal(obj);
            this.setField(o, obj);
            return;
        }
        if (this.isListOfBsonDocument(bsonValue)) {
            if (this.isArray()) {
                this.toObjectListOfBsonDocumentToArray(o, (List)bsonValue);
            } else if (this.isCollection()) {
                this.toObjectListOfBsonDocumentToCollection(o, (List)bsonValue);
            } else {
                throw new IllegalStateException("List of Bson requires array or colletion field. Field " + this + ", Bson value: " + bsonValue);
            }
            return;
        }
        Object obj = this.unmarshal(bsonValue);
        if (this.xmlAdapter == null) {
            obj = this.ctx.getSimpleTypes().toObject(this, obj);
        }
        if (obj != null || this.simpleType) {
            this.setField(o, obj);
        }
    }

    private void toObjectListOfBsonDocumentToArray(Object o, List<Document> bsonValueList) {
        Object[] objArr = (Object[])Array.newInstance(this.mainType, bsonValueList.size());
        int i = 0;
        for (Document document : bsonValueList) {
            objArr[i] = this.fd.isOneMainType() ? this.ctx.toObject(document, this.mainType) : this.ctx.toObject(document);
            objArr[i] = this.unmarshal(objArr[i]);
            ++i;
        }
        this.setField(o, objArr);
    }

    private void toObjectListOfBsonDocumentToCollection(Object o, List<Document> bsonValueList) {
        Collection<Object> objColl = this.fd.collectionInstance();
        for (Document document : bsonValueList) {
            Object obj = this.fd.isOneMainType() ? this.ctx.toObject(document, this.mainType) : this.ctx.toObject(document);
            obj = this.unmarshal(obj);
            objColl.add(obj);
        }
        this.setField(o, objColl);
    }

    private Object unmarshal(Object o) {
        if (this.xmlAdapter == null) {
            return o;
        }
        try {
            return this.xmlAdapter.unmarshal(o);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception at handling XmlAdapter, when attempting to call " + this.xmlAdapter.getClass().getName() + ".unmarshal(Object)", e);
        }
    }
}

