/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.impl;

import java.util.List;

public class Utils {
    private static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    private static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    private static final byte[] EMPTY_BYTE_PRIMITIVE_ARRAY = new byte[0];
    private static final char[] EMPTY_CHAR_PRIMITIVE_ARRAY = new char[0];
    private static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    private static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    private static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    private static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];

    public static int compare(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s2 == null) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    public static int compareStringLists(List<String> o1, List<String> o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        for (int i = 0; i < o1.size(); ++i) {
            int ret;
            String s1 = o1.get(i);
            String s2 = null;
            if (o2.size() > i) {
                s2 = o2.get(i);
            }
            if ((ret = Utils.compare(s1, s2)) == 0) continue;
            return ret;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    public static boolean isBlank(String cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String lcFirst(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        String first = str.substring(0, 1).toLowerCase();
        return str.replaceFirst("^.", first);
    }

    public static Boolean[] toObjectArray(boolean[] a) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] ret = new Boolean[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        return ret;
    }

    public static Byte[] toObjectArray(byte[] a) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] ret = new Byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    public static Character[] toObjectArray(char[] a) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] ret = new Character[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = Character.valueOf(a[i]);
        }
        return ret;
    }

    public static Double[] toObjectArray(double[] a) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] ret = new Double[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    public static Integer[] toObjectArray(int[] a) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] ret = new Integer[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    public static Long[] toObjectArray(long[] a) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] ret = new Long[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    public static byte[] toPrimitiveArray(Byte[] a) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return EMPTY_BYTE_PRIMITIVE_ARRAY;
        }
        byte[] ret = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    public static char[] toPrimitiveArray(Character[] a) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return EMPTY_CHAR_PRIMITIVE_ARRAY;
        }
        char[] ret = new char[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i].charValue();
        }
        return ret;
    }
}

