/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.maven;

import java.io.File;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.quattor.maven.AbstractPanMojo;
import org.quattor.maven.PluginUtils;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.CompilerResults;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.output.Formatter;

public class PanBuildMojo
extends AbstractPanMojo {
    private String profiles = "profiles";
    private String debugNsInclude = ".+";
    private String debugNsExclude = "^$";
    private String initialData = null;
    private File outputDir;
    private String formats = "pan,dep";
    private int maxIteration = 10000;
    private int maxRecursion = 50;
    private int nthread = 0;
    private String logging = "none";
    private File logFile = null;
    private Set<Formatter> formatters;

    @Override
    public void execute() throws MojoExecutionException {
        this.setFormatters();
        this.createoutputDir();
        CompilerOptions options = this.createCompilerOptions();
        CompilerLogging.activateLoggers((String)this.logging);
        CompilerLogging.setLogFile((File)this.logFile);
        File profileDirectory = new File(this.sourceDirectory, this.profiles);
        Set<File> objects = PluginUtils.collectPanSources(profileDirectory);
        CompilerResults results = Compiler.run((CompilerOptions)options, null, objects);
        boolean hadError = results.print(this.verbose);
        if (hadError) {
            throw new MojoExecutionException("pan language syntax check failed");
        }
    }

    private void setFormatters() throws MojoExecutionException {
        this.formatters = CompilerOptions.getFormatters((String)this.formats);
    }

    private void createoutputDir() throws MojoExecutionException {
        if (!this.outputDir.isDirectory() && !this.outputDir.mkdirs()) {
            throw new MojoExecutionException("error creating " + this.outputDir);
        }
    }

    private CompilerOptions createCompilerOptions() throws MojoExecutionException {
        LinkedList<File> includeDirectories = new LinkedList<File>();
        includeDirectories.add(this.sourceDirectory);
        try {
            return new CompilerOptions(Pattern.compile(this.debugNsInclude), Pattern.compile(this.debugNsExclude), this.maxIteration, this.maxRecursion, this.formatters, this.outputDir, includeDirectories, this.warningsFromString(this.warnings), null, null, this.initialData, this.nthread);
        }
        catch (SyntaxException e) {
            throw new MojoExecutionException("error creating compiler options: " + e.getMessage());
        }
    }
}

