/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.maven;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.CompilerResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSyntaxMojo
extends AbstractMojo {
    private File sourceDirectory;
    private boolean verbose;
    private int deprecationLevel = 0;
    private boolean failOnWarn = false;

    public void execute() throws MojoExecutionException {
        CompilerOptions options = CompilerOptions.createCheckSyntaxOptions((int)this.deprecationLevel, (boolean)this.failOnWarn);
        TreeSet<File> sources = new TreeSet<File>();
        this.collectPanSources(sources, this.sourceDirectory);
        CompilerResults results = Compiler.run((CompilerOptions)options, null, sources);
        boolean hadError = results.print(this.verbose);
        if (hadError) {
            throw new MojoExecutionException("pan language syntax check failed");
        }
    }

    public void collectPanSources(Set<File> sources, File directory) {
        if (directory.exists()) {
            for (File file : this.panSourceFiles(directory)) {
                sources.add(file);
            }
            for (File subdir : this.subdirectories(directory)) {
                this.collectPanSources(sources, subdir);
            }
        }
    }

    public File[] panSourceFiles(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            return directory.listFiles(PanSourceFileFilter.getInstance());
        }
        return new File[0];
    }

    public File[] subdirectories(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            return directory.listFiles(DirectoryFileFilter.getInstance());
        }
        return new File[0];
    }

    public static class PanSourceFileFilter
    implements FileFilter {
        public static PanSourceFileFilter singleton = new PanSourceFileFilter();

        private PanSourceFileFilter() {
        }

        public static PanSourceFileFilter getInstance() {
            return singleton;
        }

        public boolean accept(File pathname) {
            String fname = pathname.getName();
            return fname.endsWith(".pan") || fname.endsWith(".tpl");
        }
    }

    public static class DirectoryFileFilter
    implements FileFilter {
        public static DirectoryFileFilter singleton = new DirectoryFileFilter();

        private DirectoryFileFilter() {
        }

        public static DirectoryFileFilter getInstance() {
            return singleton;
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

