/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.maven;

import java.io.File;
import java.util.LinkedList;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.quattor.maven.AbstractPanMojo;
import org.quattor.maven.PluginUtils;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.CompilerResults;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.output.FormatterUtils;

public class PanBuildMojo
extends AbstractPanMojo {
    private String profiles = "profiles";
    private File outputDirectory;
    private String formatterName = "pan";
    private Formatter formatter;

    public void execute() throws MojoExecutionException {
        this.setFormatter();
        this.createOutputDirectory();
        CompilerOptions options = this.createCompilerOptions();
        File profileDirectory = new File(this.sourceDirectory, this.profiles);
        Set<File> objects = PluginUtils.collectPanSources(profileDirectory);
        CompilerResults results = Compiler.run((CompilerOptions)options, null, objects);
        boolean hadError = results.print(this.verbose);
        if (hadError) {
            throw new MojoExecutionException("pan language syntax check failed");
        }
    }

    private void setFormatter() throws MojoExecutionException {
        this.formatter = FormatterUtils.getFormatterInstance((String)this.formatterName);
        if (this.formatter == null) {
            throw new MojoExecutionException("unknown formatter: " + this.formatterName);
        }
    }

    private void createOutputDirectory() throws MojoExecutionException {
        if (!this.outputDirectory.isDirectory() && !this.outputDirectory.mkdirs()) {
            throw new MojoExecutionException("error creating " + this.outputDirectory);
        }
    }

    private CompilerOptions createCompilerOptions() throws MojoExecutionException {
        LinkedList debugIncludePatterns = new LinkedList();
        LinkedList debugExcludePatterns = new LinkedList();
        boolean xmlWriteEnabled = true;
        boolean depWriteEnabled = true;
        int iterationLimit = 5000;
        int callDepthLimit = 50;
        File sessionDirectory = null;
        int nthread = 0;
        boolean gzipOutput = false;
        boolean forceBuild = false;
        File annotationDirectory = null;
        File annotationBaseDirectory = null;
        LinkedList<File> includeDirectories = new LinkedList<File>();
        includeDirectories.add(this.sourceDirectory);
        try {
            return new CompilerOptions(debugIncludePatterns, debugExcludePatterns, xmlWriteEnabled, depWriteEnabled, iterationLimit, callDepthLimit, this.formatter, this.outputDirectory, sessionDirectory, includeDirectories, nthread, gzipOutput, this.deprecationLevel, forceBuild, annotationDirectory, annotationBaseDirectory, this.failOnWarn, null);
        }
        catch (SyntaxException e) {
            throw new MojoExecutionException("error creating compiler options: " + e.getMessage());
        }
    }
}

