/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.maven;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUtils {
    private PluginUtils() {
    }

    public static Set<File> collectPanSources(File directory) {
        TreeSet<File> sources = new TreeSet<File>();
        PluginUtils.collectPanSources(sources, directory);
        return sources;
    }

    public static void collectPanSources(Set<File> sources, File directory) {
        if (directory.exists()) {
            for (File file : PluginUtils.panSourceFiles(directory)) {
                sources.add(file);
            }
            for (File subdir : PluginUtils.subdirectories(directory)) {
                PluginUtils.collectPanSources(sources, subdir);
            }
        }
    }

    public static File[] panSourceFiles(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            return directory.listFiles(PanSourceFileFilter.getInstance());
        }
        return new File[0];
    }

    public static File[] subdirectories(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            return directory.listFiles(DirectoryFileFilter.getInstance());
        }
        return new File[0];
    }

    public static class PanSourceFileFilter
    implements FileFilter {
        public static PanSourceFileFilter singleton = new PanSourceFileFilter();

        private PanSourceFileFilter() {
        }

        public static PanSourceFileFilter getInstance() {
            return singleton;
        }

        public boolean accept(File pathname) {
            String fname = pathname.getName();
            return fname.endsWith(".pan") || fname.endsWith(".tpl");
        }
    }

    public static class DirectoryFileFilter
    implements FileFilter {
        public static DirectoryFileFilter singleton = new DirectoryFileFilter();

        private DirectoryFileFilter() {
        }

        public static DirectoryFileFilter getInstance() {
            return singleton;
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

