/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.quattor.pan.utils.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotation
implements Iterable<Entry> {
    private static final Pattern xmlPrefix = Pattern.compile("^[Xx][Mm][Ll].*", 32);
    private static final Pattern validKeyChars = Pattern.compile("^[A-Za-z_]+[A-Za-z_\\.\\-]*$");
    private final String name;
    private final List<Entry> entries;

    public Annotation(String name, List<Entry> entries) {
        String string = this.name = name != null ? name : "";
        if (!Annotation.validName(this.name)) {
            String msg = MessageUtils.format("MSG_INVALID_ANNOTATION_NAME_OR_KEY", this.name);
            throw new IllegalArgumentException(msg);
        }
        ArrayList<Entry> copy = null;
        if (entries != null) {
            copy = new ArrayList(entries.size());
            copy.addAll(entries);
        } else {
            copy = new ArrayList<Entry>(0);
        }
        copy.trimToSize();
        this.entries = Collections.unmodifiableList(copy);
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnonymous() {
        return "".equals(this.name);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public static boolean validName(String name) {
        return "".equals(name) || Annotation.validKey(name);
    }

    public static boolean validKey(String key) {
        if (key == null) {
            return false;
        }
        if (xmlPrefix.matcher(key).matches()) {
            return false;
        }
        return validKeyChars.matcher(key).matches();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("@" + this.name + "{\n");
        for (Entry entry : this.getEntries()) {
            sb.append("  ");
            sb.append(entry.toString());
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static class Entry {
        private final String key;
        private final String value;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
            if (!Annotation.validKey(key)) {
                String msg = MessageUtils.format("MSG_INVALID_ANNOTATION_NAME_OR_KEY", key);
                throw new IllegalArgumentException(msg);
            }
            if (value == null) {
                String msg = MessageUtils.format("MSG_INVALID_ANNOTATION_NULL_VALUE", new Object[0]);
                throw new IllegalArgumentException(msg);
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s = %s", this.key, this.value);
        }
    }
}

