/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.ProtectedHashResource;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;
import org.quattor.pan.utils.TermFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashResource
extends Resource {
    private Map<String, Element> map;

    public HashResource() {
        this.map = new TreeMap<String, Element>();
    }

    private HashResource(Map<String, Element> childrenMap) {
        try {
            this.map = new TreeMap<String, Element>();
            for (Map.Entry<String, Element> entry : childrenMap.entrySet()) {
                this.map.put(entry.getKey(), entry.getValue().duplicate());
            }
        }
        catch (StackOverflowError e) {
            throw new EvaluationException("stack overflow; check for circular data structure");
        }
    }

    protected HashResource(HashResource source) {
        this.map = new TreeMap<String, Element>();
        for (Map.Entry<String, Element> entry : source.map.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue().protect());
        }
    }

    @Override
    public Element duplicate() {
        return new HashResource(this.map);
    }

    @Override
    public Element get(Term term) throws InvalidTermException {
        return this.map.get(term.getKey());
    }

    @Override
    public Element put(Term term, Element newValue) throws InvalidTermException {
        Element oldValue = null;
        if (newValue != null && !(newValue instanceof Null)) {
            oldValue = this.map.put(term.getKey(), newValue);
            if (oldValue != null) {
                oldValue.checkValidReplacement(newValue);
            }
        } else {
            oldValue = this.map.remove(term.getKey());
        }
        return oldValue;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public Set<Term> keySet() {
        TreeSet<Term> terms = new TreeSet<Term>();
        for (String s : this.map.keySet()) {
            Term term = TermFactory.create(s);
            terms.add(term);
        }
        return terms;
    }

    @Override
    public String locateUndefinedElement() {
        for (String term : this.map.keySet()) {
            String rpath = this.map.get(term).locateUndefinedElement();
            if (rpath == null) continue;
            return !"".equals(rpath) ? term + "/" + rpath : term;
        }
        return null;
    }

    @Override
    public void checkRange(Range range) throws ValidationException {
        if (!range.isInRange(this.map.size())) {
            throw ValidationException.create("MSG_HASH_SIZE_OUTSIDE_RANGE", this.map.size(), range.toString());
        }
    }

    @Override
    public void checkValidReplacement(Element newValue) throws EvaluationException {
        if (!(newValue instanceof Undef || newValue instanceof Null || newValue instanceof HashResource)) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_REPLACEMENT", this.getTypeAsString(), newValue.getTypeAsString()));
        }
    }

    @Override
    public Element protect() {
        return new ProtectedHashResource(this);
    }

    @Override
    public String getTypeAsString() {
        return "nlist";
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof HashResource) {
            return ((Object)this.map).equals(((HashResource)o).getBackingMap());
        }
        return false;
    }

    protected Map<String, Element> getBackingMap() {
        return this.map;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        String separator = "";
        for (Resource.Entry entry : this) {
            sb.append(separator);
            sb.append(((Property)entry.getKey()).toString());
            sb.append(", ");
            sb.append(((Element)entry.getValue()).toString());
            separator = ", ";
        }
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public Resource.Iterator iterator() {
        return new HashResourceIterator(this.map);
    }

    private static class HashResourceEntry
    implements Resource.Entry {
        private final Property key;
        private final Element value;

        public HashResourceEntry(Property key, Element value) {
            assert (key != null);
            assert (value != null);
            this.key = key;
            this.value = value;
        }

        public Property getKey() {
            return this.key;
        }

        public Element getValue() {
            return this.value;
        }

        public Element setValue(Element value) {
            throw new UnsupportedOperationException("HashResourceEntry does not support setValue()");
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof HashResourceEntry) {
                HashResourceEntry other = (HashResourceEntry)o;
                return this.key.equals(other.key) && this.value.equals(other.value);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashResourceIterator
    implements Resource.Iterator {
        private final Iterator<String> iterator;
        private final Map<String, Element> backingHash;

        public HashResourceIterator(Map<String, Element> backingHash) {
            assert (backingHash != null);
            this.backingHash = backingHash;
            this.iterator = backingHash.keySet().iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("HashResourceIterator does not support remove()");
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Resource.Entry next() {
            HashResourceEntry entry = null;
            try {
                StringProperty key = StringProperty.getInstance(this.iterator.next());
                Element value = this.backingHash.get(key.getValue());
                if (value == null) {
                    throw new EvaluationException(MessageUtils.format("MSG_CONCURRENT_MODIFICATION", new Object[0]), null);
                }
                entry = new HashResourceEntry(key, value);
            }
            catch (NoSuchElementException nsee) {
                throw new EvaluationException(MessageUtils.format("MSG_CONCURRENT_MODIFICATION", new Object[0]), null);
            }
            return entry;
        }
    }
}

