/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.Template;

public final class IfExists
extends BuiltInFunction {
    private IfExists(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("if_exists", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_STRING_ARG_REQ", "if_exists");
        }
        return new IfExists(sourceRange, operations);
    }

    public Element execute(Context context) {
        assert (this.ops.length == 1);
        boolean exists = false;
        this.throwExceptionIfCompileTimeContext(context);
        Element element = this.ops[0].execute(context);
        try {
            StringProperty result = (StringProperty)element;
            String s = result.getValue();
            if (Template.isValidTemplateName(s)) {
                try {
                    Template template = context.localAndGlobalLoad(s, true);
                    exists = template != null;
                }
                catch (EvaluationException consumed) {
                    exists = true;
                }
            } else {
                throw new EvaluationException("invalid template name: " + s, this.getSourceRange(), context);
            }
            return exists ? result : Undef.VALUE;
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("if_exists argument is not a string: " + element.getTypeAsString(), this.sourceRange, context);
        }
    }
}

