/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.operators.NestedListVariable;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Term;

public class SelfNestedListVariable
extends NestedListVariable {
    public SelfNestedListVariable(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, "SELF", operations);
        assert (operations.length > 0);
    }

    public void checkInvalidSelfContext() throws SyntaxException {
        throw SyntaxException.create(this.sourceRange, "MSG_INVALID_SELF_REF_IN_INCLUDE", new Object[0]);
    }

    public Element execute(Context context) {
        if (context.isCompileTimeContext()) {
            throw EvaluationException.create(this.sourceRange, "MSG_INVALID_IN_COMPILE_TIME_CONTEXT", this.getClass().getSimpleName());
        }
        Term[] terms = null;
        try {
            terms = this.calculateTerms(context);
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
        if (context.isSelfFinal()) {
            ee = EvaluationException.create("MSG_CANNOT_MODIFY_SELF", new Object[0]);
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
        Element result = context.getSelf();
        if (result == null) {
            throw CompilerError.create("MSG_SELF_IS_UNDEFINED", new Object[0]);
        }
        if (result instanceof Undef || result instanceof Null) {
            result = new ListResource();
            context.resetSelf(result);
        } else if (result.isProtected()) {
            result = result.writableCopy();
            context.resetSelf(result);
        }
        try {
            result = result.rgetList(terms, 0);
        }
        catch (InvalidTermException e) {
            throw new EvaluationException(e.formatVariableMessage(this.identifier, terms));
        }
        return result;
    }
}

