/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class While
extends AbstractOperation {
    private While(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
        assert (operations.length == 2);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        assert (ops.length == 2);
        Operation result = null;
        if (ops[0] instanceof Element) {
            try {
                BooleanProperty a = (BooleanProperty)ops[0];
                if (!a.getValue().booleanValue()) {
                    result = Undef.VALUE;
                }
            }
            catch (ClassCastException cce) {
                throw SyntaxException.create(sourceRange, "MSG_INVALID_LOOP_TEST", new Object[0]);
            }
        }
        if (result == null) {
            result = new While(sourceRange, ops);
        }
        return result;
    }

    public Element execute(Context context) {
        Operation condition = this.ops[0];
        Operation body = this.ops[1];
        Element result = Undef.VALUE;
        boolean test = false;
        try {
            test = ((BooleanProperty)condition.execute(context)).getValue();
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_LOOP_TEST", new Object[0]), this.sourceRange, context);
        }
        int limit = context.getIterationLimit();
        int count = 0;
        while (test) {
            if (++count > limit) {
                throw new EvaluationException(MessageUtils.format("MSG_LOOP_ITERATION_LIMIT", limit), this.sourceRange, context);
            }
            result = body.execute(context);
            try {
                test = ((BooleanProperty)condition.execute(context)).getValue();
            }
            catch (ClassCastException cce) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_LOOP_TEST", new Object[0]), this.sourceRange, context);
            }
        }
        return result;
    }
}

