/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.parser;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.quattor.pan.dml.DML;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.functions.Append;
import org.quattor.pan.dml.functions.Base64Decode;
import org.quattor.pan.dml.functions.Base64Encode;
import org.quattor.pan.dml.functions.Clone;
import org.quattor.pan.dml.functions.Create;
import org.quattor.pan.dml.functions.Debug;
import org.quattor.pan.dml.functions.DebugSuppressed;
import org.quattor.pan.dml.functions.Delete;
import org.quattor.pan.dml.functions.Deprecated;
import org.quattor.pan.dml.functions.Digest;
import org.quattor.pan.dml.functions.ErrorMessage;
import org.quattor.pan.dml.functions.Escape;
import org.quattor.pan.dml.functions.Exists;
import org.quattor.pan.dml.functions.FileContents;
import org.quattor.pan.dml.functions.First;
import org.quattor.pan.dml.functions.Format;
import org.quattor.pan.dml.functions.Function;
import org.quattor.pan.dml.functions.Hash;
import org.quattor.pan.dml.functions.IfExists;
import org.quattor.pan.dml.functions.Index;
import org.quattor.pan.dml.functions.IsBoolean;
import org.quattor.pan.dml.functions.IsDefined;
import org.quattor.pan.dml.functions.IsDouble;
import org.quattor.pan.dml.functions.IsHash;
import org.quattor.pan.dml.functions.IsList;
import org.quattor.pan.dml.functions.IsLong;
import org.quattor.pan.dml.functions.IsNull;
import org.quattor.pan.dml.functions.IsNumber;
import org.quattor.pan.dml.functions.IsProperty;
import org.quattor.pan.dml.functions.IsResource;
import org.quattor.pan.dml.functions.IsString;
import org.quattor.pan.dml.functions.Key;
import org.quattor.pan.dml.functions.Length;
import org.quattor.pan.dml.functions.List;
import org.quattor.pan.dml.functions.Match;
import org.quattor.pan.dml.functions.Matches;
import org.quattor.pan.dml.functions.Merge;
import org.quattor.pan.dml.functions.Next;
import org.quattor.pan.dml.functions.PathExists;
import org.quattor.pan.dml.functions.Prepend;
import org.quattor.pan.dml.functions.Replace;
import org.quattor.pan.dml.functions.Return;
import org.quattor.pan.dml.functions.Splice;
import org.quattor.pan.dml.functions.Split;
import org.quattor.pan.dml.functions.Substr;
import org.quattor.pan.dml.functions.ToBoolean;
import org.quattor.pan.dml.functions.ToDouble;
import org.quattor.pan.dml.functions.ToLong;
import org.quattor.pan.dml.functions.ToLowerCase;
import org.quattor.pan.dml.functions.ToString;
import org.quattor.pan.dml.functions.ToUpperCase;
import org.quattor.pan.dml.functions.Traceback;
import org.quattor.pan.dml.functions.TracebackSuppressed;
import org.quattor.pan.dml.functions.Unescape;
import org.quattor.pan.dml.functions.Value;
import org.quattor.pan.dml.operators.Add;
import org.quattor.pan.dml.operators.Assign;
import org.quattor.pan.dml.operators.BitAnd;
import org.quattor.pan.dml.operators.BitIOR;
import org.quattor.pan.dml.operators.BitNot;
import org.quattor.pan.dml.operators.BitXOR;
import org.quattor.pan.dml.operators.Div;
import org.quattor.pan.dml.operators.For;
import org.quattor.pan.dml.operators.Foreach;
import org.quattor.pan.dml.operators.IfElse;
import org.quattor.pan.dml.operators.LogicalAnd;
import org.quattor.pan.dml.operators.LogicalEQ;
import org.quattor.pan.dml.operators.LogicalGE;
import org.quattor.pan.dml.operators.LogicalGT;
import org.quattor.pan.dml.operators.LogicalLE;
import org.quattor.pan.dml.operators.LogicalLT;
import org.quattor.pan.dml.operators.LogicalNE;
import org.quattor.pan.dml.operators.LogicalNot;
import org.quattor.pan.dml.operators.LogicalOr;
import org.quattor.pan.dml.operators.Mod;
import org.quattor.pan.dml.operators.Mult;
import org.quattor.pan.dml.operators.SetValue;
import org.quattor.pan.dml.operators.Sub;
import org.quattor.pan.dml.operators.UnaryMinus;
import org.quattor.pan.dml.operators.UnaryPlus;
import org.quattor.pan.dml.operators.Variable;
import org.quattor.pan.dml.operators.While;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.parser.ASTBaseTypeSpec;
import org.quattor.pan.parser.ASTFieldSpec;
import org.quattor.pan.parser.ASTFullTypeSpec;
import org.quattor.pan.parser.ASTFunction;
import org.quattor.pan.parser.ASTOperation;
import org.quattor.pan.parser.ASTStatement;
import org.quattor.pan.parser.ASTTemplate;
import org.quattor.pan.parser.ASTTypeClause;
import org.quattor.pan.parser.ASTTypeSpec;
import org.quattor.pan.parser.ASTVariable;
import org.quattor.pan.parser.Node;
import org.quattor.pan.parser.SimpleNode;
import org.quattor.pan.statement.AssignmentStatement;
import org.quattor.pan.statement.BindStatement;
import org.quattor.pan.statement.FunctionStatement;
import org.quattor.pan.statement.IncludeStatement;
import org.quattor.pan.statement.Statement;
import org.quattor.pan.statement.TypeStatement;
import org.quattor.pan.statement.VariableStatement;
import org.quattor.pan.template.CompileTimeContext;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.Template;
import org.quattor.pan.type.AliasType;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.FullType;
import org.quattor.pan.type.HashType;
import org.quattor.pan.type.LinkType;
import org.quattor.pan.type.ListType;
import org.quattor.pan.type.RecordType;
import org.quattor.pan.utils.Path;
import org.quattor.pan.utils.Term;

public class PanParserAstUtils {
    private static final Map<String, Method> functionConstructors;

    public static Template convertAstToTemplate(File file, ASTTemplate ast) throws SyntaxException {
        LinkedList<Statement> statements = new LinkedList<Statement>();
        Path prefix = null;
        int nchild = ast.jjtGetNumChildren();
        block10: for (int i = 0; i < nchild; ++i) {
            Node n = ast.jjtGetChild(i);
            assert (n instanceof ASTStatement);
            ASTStatement snode = (ASTStatement)n;
            ASTStatement.StatementType stype = snode.getStatementType();
            switch (stype) {
                case NOOP: {
                    continue block10;
                }
                case BIND: {
                    statements.add(PanParserAstUtils.convertAstToBindStatement(file.getAbsolutePath(), snode));
                    continue block10;
                }
                case ASSIGN: {
                    statements.add(PanParserAstUtils.convertAstToAssignStatement(snode, prefix));
                    continue block10;
                }
                case VARIABLE: {
                    statements.add(PanParserAstUtils.convertAstToVariableStatement(snode));
                    continue block10;
                }
                case TYPE: {
                    statements.add(PanParserAstUtils.convertAstToTypeStatement(file.getAbsolutePath(), snode));
                    continue block10;
                }
                case FUNCTION: {
                    statements.add(PanParserAstUtils.convertAstToFunctionStatement(snode));
                    continue block10;
                }
                case INCLUDE: {
                    Statement stmt = PanParserAstUtils.convertAstToIncludeStatement(snode);
                    if (stmt == null) continue block10;
                    statements.add(stmt);
                    continue block10;
                }
                case PREFIX: {
                    prefix = PanParserAstUtils.convertAstToPrefixStatement(snode);
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
        Template t = new Template(file, ast.getSourceRange(), ast.getTemplateType(), ast.getIdentifier(), statements);
        return t;
    }

    private static Statement convertAstToBindStatement(String source, ASTStatement ast) throws SyntaxException {
        assert (ast.getStatementType() == ASTStatement.StatementType.BIND);
        Path path = PanParserAstUtils.createPathFromIdentifier(ast);
        assert (ast.jjtGetNumChildren() == 1);
        SimpleNode child = (SimpleNode)ast.jjtGetChild(0);
        FullType fullType = null;
        if (child instanceof ASTFullTypeSpec) {
            fullType = PanParserAstUtils.astToFullType(source, (ASTFullTypeSpec)child);
        } else if (child instanceof ASTOperation) {
            Operation dml = PanParserAstUtils.astToDml((ASTOperation)child);
            AliasType elementType = new AliasType(null, child.getSourceRange(), "element", null);
            fullType = new FullType(source, child.getSourceRange(), elementType, null, dml);
        } else assert (false);
        return new BindStatement(ast.getSourceRange(), path, fullType);
    }

    private static Path createPathFromIdentifier(ASTStatement ast) throws SyntaxException {
        try {
            String pathname = ast.getIdentifier();
            assert (pathname != null);
            return new Path(pathname);
        }
        catch (EvaluationException ee) {
            throw SyntaxException.create(ast.getSourceRange(), ee);
        }
        catch (SyntaxException se) {
            throw se.addExceptionInfo(ast.getSourceRange(), null);
        }
    }

    private static Statement convertAstToAssignStatement(ASTStatement ast, Path prefix) throws SyntaxException {
        assert (ast.getStatementType() == ASTStatement.StatementType.ASSIGN);
        AssignmentStatement statement = null;
        Path path = PanParserAstUtils.createPathFromIdentifier(ast);
        path = Path.resolve(prefix, path);
        assert (ast.jjtGetNumChildren() <= 1);
        if (ast.jjtGetNumChildren() == 0) {
            Null element = Null.VALUE;
            statement = AssignmentStatement.createAssignmentStatement(ast.getSourceRange(), path, element, ast.getConditionalFlag(), !ast.getFinalFlag());
        } else {
            ASTOperation child = (ASTOperation)ast.jjtGetChild(0);
            Operation dml = PanParserAstUtils.astToDml(child);
            statement = AssignmentStatement.createAssignmentStatement(ast.getSourceRange(), path, dml, ast.getConditionalFlag(), !ast.getFinalFlag());
        }
        return statement;
    }

    private static Statement convertAstToVariableStatement(ASTStatement ast) throws SyntaxException {
        assert (ast.getStatementType() == ASTStatement.StatementType.VARIABLE);
        String vname = ast.getIdentifier();
        assert (vname != null);
        assert (ast.jjtGetNumChildren() == 1);
        ASTOperation child = (ASTOperation)ast.jjtGetChild(0);
        Operation dml = PanParserAstUtils.astToDml(child);
        return VariableStatement.getInstance(ast.getSourceRange(), vname, dml, ast.getConditionalFlag(), !ast.getFinalFlag());
    }

    private static Statement convertAstToTypeStatement(String source, ASTStatement ast) throws SyntaxException {
        assert (ast.getStatementType() == ASTStatement.StatementType.TYPE);
        String tname = ast.getIdentifier();
        assert (tname != null);
        assert (ast.jjtGetNumChildren() == 1);
        ASTFullTypeSpec child = (ASTFullTypeSpec)ast.jjtGetChild(0);
        FullType fullType = PanParserAstUtils.astToFullType(source, child);
        return new TypeStatement(ast.getSourceRange(), tname, fullType);
    }

    private static Statement convertAstToFunctionStatement(ASTStatement ast) throws SyntaxException {
        assert (ast.getStatementType() == ASTStatement.StatementType.FUNCTION);
        String fname = ast.getIdentifier();
        assert (fname != null);
        assert (ast.jjtGetNumChildren() == 1);
        ASTOperation child = (ASTOperation)ast.jjtGetChild(0);
        Operation dml = PanParserAstUtils.astToDml(child);
        return new FunctionStatement(ast.getSourceRange(), fname, dml);
    }

    private static Statement convertAstToIncludeStatement(ASTStatement ast) throws SyntaxException {
        assert (ast.getStatementType() == ASTStatement.StatementType.INCLUDE);
        assert (ast.jjtGetNumChildren() == 1);
        ASTOperation child = (ASTOperation)ast.jjtGetChild(0);
        Operation dml = PanParserAstUtils.astToDml(child);
        return IncludeStatement.newIncludeStatement(ast.getSourceRange(), dml);
    }

    private static Path convertAstToPrefixStatement(ASTStatement ast) throws SyntaxException {
        assert (ast.getStatementType() == ASTStatement.StatementType.PREFIX);
        if (!"".equals(ast.getIdentifier())) {
            Path path = PanParserAstUtils.createPathFromIdentifier(ast);
            if (!path.isAbsolute()) {
                throw SyntaxException.create(ast.getSourceRange(), "MSG_PREFIX_MUST_BE_ABSOLUTE_PATH", path.toString());
            }
            return path;
        }
        return null;
    }

    private static FullType astToFullType(String source, ASTFullTypeSpec ast) throws SyntaxException {
        Operation withDml = null;
        Operation defaultDml = null;
        assert (ast.getId() == 4);
        assert (ast.jjtGetNumChildren() >= 1);
        ASTTypeSpec typeSpec = (ASTTypeSpec)ast.jjtGetChild(0);
        BaseType baseType = PanParserAstUtils.astToType(source, typeSpec);
        assert (baseType != null);
        SourceRange sourceRange = SourceRange.combineSourceRanges(typeSpec.getSourceRange());
        int nchild = ast.jjtGetNumChildren();
        block4: for (int i = 1; i < nchild; ++i) {
            SimpleNode child = (SimpleNode)ast.jjtGetChild(i);
            assert (child.getId() == 1);
            ASTOperation op = (ASTOperation)child;
            switch (op.getOperationType()) {
                case DEFAULT: {
                    assert (op.jjtGetNumChildren() == 1);
                    assert (op.jjtGetChild(0) instanceof ASTOperation);
                    ASTOperation dml = (ASTOperation)op.jjtGetChild(0);
                    assert (dml.getOperationType() == ASTOperation.OperationType.DML);
                    defaultDml = PanParserAstUtils.astToDml(dml);
                    sourceRange = SourceRange.combineSourceRanges(sourceRange, dml.getSourceRange());
                    continue block4;
                }
                case WITH: {
                    assert (op.jjtGetNumChildren() == 1);
                    assert (op.jjtGetChild(0) instanceof ASTOperation);
                    ASTOperation with = (ASTOperation)op.jjtGetChild(0);
                    assert (with.getOperationType() == ASTOperation.OperationType.DML);
                    withDml = PanParserAstUtils.astToDml(with);
                    sourceRange = SourceRange.combineSourceRanges(sourceRange, with.getSourceRange());
                    continue block4;
                }
                default: {
                    throw CompilerError.create("MSG_REACHED_IMPOSSIBLE_BRANCH", new Object[0]);
                }
            }
        }
        return new FullType(source, ast.getSourceRange(), baseType, PanParserAstUtils.runDefaultDml(defaultDml), withDml);
    }

    private static Operation astToOperation(SimpleNode node) throws SyntaxException {
        Operation op = null;
        block0 : switch (node.getId()) {
            case 1: {
                ASTOperation onode = (ASTOperation)node;
                switch (onode.getOperationType()) {
                    case DML: {
                        op = PanParserAstUtils.astToDml(onode);
                        break block0;
                    }
                    case PLUS: {
                        op = UnaryPlus.newOperation(onode.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)));
                        break block0;
                    }
                    case MINUS: {
                        op = UnaryMinus.newOperation(onode.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)));
                        break block0;
                    }
                    case NOT: {
                        op = LogicalNot.newOperation(onode.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)));
                        break block0;
                    }
                    case BIT_NOT: {
                        op = BitNot.newOperation(onode.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)));
                        break block0;
                    }
                    case LITERAL: {
                        op = onode.getOperation();
                        break block0;
                    }
                    case ASSIGN: {
                        op = PanParserAstUtils.astToAssign(onode);
                        break block0;
                    }
                    case IF: {
                        op = PanParserAstUtils.astToIfElse(onode);
                        break block0;
                    }
                    case WHILE: {
                        op = While.newOperation(onode.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                        break block0;
                    }
                    case FOREACH: {
                        op = new Foreach(onode.getSourceRange(), PanParserAstUtils.astToSetValue((ASTVariable)node.jjtGetChild(0)), PanParserAstUtils.astToSetValue((ASTVariable)node.jjtGetChild(1)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(2)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(3)));
                        break block0;
                    }
                    case FOR: {
                        op = new For(onode.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(2)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(3)));
                        break block0;
                    }
                }
                op = null;
                break;
            }
            case 9: {
                op = PanParserAstUtils.astToVariable((ASTVariable)node, false);
                break;
            }
            case 10: {
                op = LogicalOr.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 11: {
                op = LogicalAnd.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 12: {
                op = BitIOR.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 13: {
                op = BitXOR.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 14: {
                op = BitAnd.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 15: {
                op = LogicalEQ.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 16: {
                op = LogicalNE.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 17: {
                op = LogicalLT.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 18: {
                op = LogicalGT.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 19: {
                op = LogicalLE.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 20: {
                op = LogicalGE.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 21: {
                op = Add.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 22: {
                op = Sub.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 23: {
                op = Mult.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 24: {
                op = Div.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 25: {
                op = Mod.newOperation(node.getSourceRange(), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(0)), PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(1)));
                break;
            }
            case 26: {
                op = PanParserAstUtils.astToFunction((ASTFunction)node);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (op != null);
        return op;
    }

    private static Operation astToDml(ASTOperation node) throws SyntaxException {
        assert (node.getOperationType() == ASTOperation.OperationType.DML);
        int count = node.jjtGetNumChildren();
        assert (count >= 1);
        Operation[] operations = new Operation[count];
        SourceRange sourceRange = node.getSourceRange();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                SimpleNode n = (SimpleNode)node.jjtGetChild(i);
                operations[i] = PanParserAstUtils.astToOperation(n);
                sourceRange = SourceRange.combineSourceRanges(sourceRange, n.getSourceRange());
            }
        }
        return DML.getInstance(sourceRange, operations);
    }

    private static Operation astToIfElse(ASTOperation node) throws SyntaxException {
        int count = node.jjtGetNumChildren();
        assert (count >= 2);
        Operation condition = PanParserAstUtils.astToDml((ASTOperation)node.jjtGetChild(0));
        Operation trueClause = PanParserAstUtils.astToDml((ASTOperation)node.jjtGetChild(1));
        Operation falseClause = Undef.VALUE;
        if (count == 3) {
            falseClause = PanParserAstUtils.astToDml((ASTOperation)node.jjtGetChild(2));
        }
        return IfElse.newOperation(node.getSourceRange(), condition, trueClause, falseClause);
    }

    private static Operation astToFunction(ASTFunction node) throws SyntaxException {
        int count = node.jjtGetNumChildren();
        Operation[] ops = new Operation[count];
        for (int i = 0; i < count; ++i) {
            ops[i] = PanParserAstUtils.astToDml((ASTOperation)node.jjtGetChild(i));
            ops[i].checkRestrictedContext();
        }
        Method c = functionConstructors.get(node.getName());
        if (c != null) {
            try {
                return (Operation)c.invoke(null, node.getSourceRange(), ops);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (t instanceof SyntaxException) {
                    throw (SyntaxException)t;
                }
                CompilerError error = CompilerError.create("MSG_UNEXPECTED_EXCEPTION_ENCOUNTERED", new Object[0]);
                error.initCause(t);
                throw error;
            }
            catch (IllegalAccessException iae) {
                CompilerError error = CompilerError.create("MSG_UNEXPECTED_EXCEPTION_ENCOUNTERED", new Object[0]);
                error.initCause(iae);
                throw error;
            }
            catch (ClassCastException cce) {
                CompilerError error = CompilerError.create("MSG_UNEXPECTED_EXCEPTION_ENCOUNTERED", new Object[0]);
                error.initCause(cce);
                throw error;
            }
        }
        return new Function(node.getSourceRange(), node.getName(), ops);
    }

    private static Operation astToSetValue(ASTVariable node) throws SyntaxException {
        int count = node.jjtGetNumChildren();
        Operation[] ops = new Operation[count];
        for (int i = 0; i < count; ++i) {
            ops[i] = PanParserAstUtils.astToDml((ASTOperation)node.jjtGetChild(i));
            ops[i].checkRestrictedContext();
        }
        return SetValue.getInstance(node.getSourceRange(), node.getName(), ops);
    }

    private static Operation astToAssign(ASTOperation node) throws SyntaxException {
        int count = node.jjtGetNumChildren();
        Operation[] ops = new Operation[count];
        ops[0] = PanParserAstUtils.astToOperation((SimpleNode)node.jjtGetChild(count - 1));
        for (int i = count - 2; i >= 0; --i) {
            try {
                int index = count - 1 - i;
                ops[index] = PanParserAstUtils.astToSetValue((ASTVariable)node.jjtGetChild(i));
                continue;
            }
            catch (ClassCastException cce) {
                throw CompilerError.create("MSG_ASSIGNMENT_HAS_NON_VARIABLE_CHILD", new Object[0]);
            }
        }
        return new Assign(node.getSourceRange(), ops);
    }

    private static Operation astToVariable(ASTVariable node, boolean lookupOnly) throws SyntaxException {
        int count = node.jjtGetNumChildren();
        Operation[] ops = new Operation[count];
        for (int i = 0; i < count; ++i) {
            ops[i] = PanParserAstUtils.astToDml((ASTOperation)node.jjtGetChild(i));
            ops[i].checkRestrictedContext();
        }
        return Variable.getInstance(node.getSourceRange(), node.getName(), lookupOnly, ops);
    }

    private static BaseType astToType(String source, SimpleNode node) throws SyntaxException {
        BaseType baseType = null;
        assert (node.jjtGetNumChildren() >= 1);
        assert (node.getId() == 5);
        ASTBaseTypeSpec base = (ASTBaseTypeSpec)node.jjtGetChild(0);
        String identifier = base.getIdentifier();
        if (identifier == null) {
            LinkedList<String> includes = new LinkedList<String>();
            TreeMap<Term, FullType> reqFields = new TreeMap<Term, FullType>();
            TreeMap<Term, FullType> optFields = new TreeMap<Term, FullType>();
            int nfields = base.jjtGetNumChildren();
            for (int i = 0; i < nfields; ++i) {
                SimpleNode fchild = (SimpleNode)base.jjtGetChild(i);
                assert (fchild instanceof ASTFieldSpec);
                ASTFieldSpec field = (ASTFieldSpec)fchild;
                String include = field.getInclude();
                if (include == null) {
                    Term term = field.getKey();
                    assert (field.jjtGetNumChildren() == 1);
                    SimpleNode ftypeNode = (SimpleNode)field.jjtGetChild(0);
                    assert (ftypeNode.getId() == 4);
                    FullType ftype = PanParserAstUtils.astToFullType(source, (ASTFullTypeSpec)ftypeNode);
                    if (field.isRequired()) {
                        reqFields.put(term, ftype);
                        continue;
                    }
                    optFields.put(term, ftype);
                    continue;
                }
                includes.add(include);
            }
            baseType = new RecordType(source, base.getSourceRange(), base.isExtensible(), base.getRange(), includes, reqFields, optFields);
        } else {
            baseType = new AliasType(source, base.getSourceRange(), identifier, base.getRange());
        }
        int nchild = node.jjtGetNumChildren();
        block6: for (int i = 1; i < nchild; ++i) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            assert (child.getId() == 8);
            ASTTypeClause clause = (ASTTypeClause)child;
            switch (clause.getClauseType()) {
                case LIST: {
                    baseType = new ListType(source, clause.getSourceRange(), baseType, clause.getRange());
                    continue block6;
                }
                case HASH: {
                    baseType = new HashType(source, clause.getSourceRange(), baseType, clause.getRange());
                    continue block6;
                }
                case LINK: {
                    baseType = new LinkType(source, clause.getSourceRange(), baseType);
                    continue block6;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
        return baseType;
    }

    private static Element runDefaultDml(Operation dml) throws SyntaxException {
        if (dml == null) {
            return null;
        }
        CompileTimeContext context = new CompileTimeContext();
        Element value = null;
        try {
            value = context.executeDmlBlock(dml);
        }
        catch (EvaluationException ee) {
            SyntaxException se = SyntaxException.create(null, "MSG_DEF_VALUE_NOT_CONSTANT", new Object[0]);
            se.initCause(ee);
            throw se;
        }
        if (value instanceof Undef) {
            throw SyntaxException.create(null, "MSG_DEF_VALUE_CANNOT_BE_UNDEF", new Object[0]);
        }
        if (value instanceof Null) {
            throw SyntaxException.create(null, "MSG_DEF_VALUE_CANNOT_BE_UNDEF", new Object[0]);
        }
        return value;
    }

    static {
        try {
            HashMap<String, Method> fc = new HashMap<String, Method>();
            fc.put("append", Append.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("prepend", Prepend.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("first", First.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("next", Next.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("delete", Delete.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("exists", Exists.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("return", Return.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("nlist", Hash.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("list", List.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_boolean", IsBoolean.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_defined", IsDefined.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_double", IsDouble.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_long", IsLong.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_nlist", IsHash.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_list", IsList.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_null", IsNull.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_number", IsNumber.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_property", IsProperty.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_resource", IsResource.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("is_string", IsString.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("value", Value.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("error", ErrorMessage.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("length", Length.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("match", Match.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("matches", Matches.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("path_exists", PathExists.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("to_lowercase", ToLowerCase.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("to_uppercase", ToUpperCase.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("to_string", ToString.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("to_boolean", ToBoolean.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("to_long", ToLong.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("to_double", ToDouble.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("base64_decode", Base64Decode.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("base64_encode", Base64Encode.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("escape", Escape.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("unescape", Unescape.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("key", Key.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("merge", Merge.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("substr", Substr.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("replace", Replace.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("split", Split.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("splice", Splice.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("index", Index.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("clone", Clone.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("create", Create.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("if_exists", IfExists.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("format", Format.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("deprecated", Deprecated.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("digest", Digest.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("file_contents", FileContents.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("debug", Debug.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("-suppress-debug-", DebugSuppressed.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("traceback", Traceback.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            fc.put("-suppress-traceback-", TracebackSuppressed.class.getDeclaredMethod("getInstance", SourceRange.class, Operation[].class));
            functionConstructors = Collections.unmodifiableMap(fc);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
            throw CompilerError.create("MSG_CANNOT_CREATE_FUNCTION_TABLE", new Object[0]);
        }
    }
}

