/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.quattor.pan.exceptions.EvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizedSourceLocator {
    private final List<File> includeDirectories;
    private static final List<String> emptyRelativePaths;

    public OptimizedSourceLocator(File sessionDirectory, List<File> includeDirectories) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (includeDirectories != null && includeDirectories.size() != 0) {
            for (File d : includeDirectories) {
                if (!d.isAbsolute()) {
                    throw EvaluationException.create("MSG_NON_ABSOLUTE_PATH_IN_INCLUDE_DIRS", d.toString());
                }
                if (d.isDirectory()) continue;
                throw EvaluationException.create("MSG_NON_DIRECTORY_IN_INCLUDE_DIRS", d.toString());
            }
            dirs.addAll(includeDirectories);
            dirs.trimToSize();
        } else {
            dirs.add(new File(System.getProperty("user.dir")));
            dirs.trimToSize();
        }
        dirs.trimToSize();
        this.includeDirectories = Collections.unmodifiableList(dirs);
    }

    public File lookup(String name) {
        return this.lookup(name, emptyRelativePaths);
    }

    public File lookup(String name, String suffix) {
        return this.lookup(name, suffix, emptyRelativePaths);
    }

    public File lookup(String name, List<String> loadpath) {
        return this.lookup(name, ".tpl", loadpath);
    }

    public File lookup(String name, String suffix, List<String> loadpath) {
        assert (loadpath != null);
        assert (loadpath.size() > 0);
        String src = name + suffix;
        for (File d : this.includeDirectories) {
            for (String rpath : loadpath) {
                File dir = new File(d, rpath);
                File sourceFile = new File(dir, src);
                if (!sourceFile.exists()) continue;
                return sourceFile;
            }
        }
        return null;
    }

    static {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("");
        list.trimToSize();
        emptyRelativePaths = list;
    }
}

