/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.ant;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.parser.ASTTemplate;
import org.quattor.pan.repository.SourceType;
import org.quattor.pan.tasks.CompileTask;
import org.quattor.pan.utils.FileStatCache;
import org.quattor.pan.utils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyChecker {
    private final List<File> includeDirectories;
    private final Pattern ignoreDependencyPattern;
    private final FileStatCache statCache = new FileStatCache();
    private static final Pattern NONE = Pattern.compile("^$");

    public DependencyChecker(List<File> includeDirectories, Pattern ignoredDependencyPattern) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (includeDirectories != null) {
            dirs.addAll(includeDirectories);
        } else {
            String userDir = System.getProperty("user.dir");
            File file = new File(userDir).getAbsoluteFile();
            dirs.add(file);
        }
        dirs.trimToSize();
        this.includeDirectories = Collections.unmodifiableList(dirs);
        this.ignoreDependencyPattern = ignoredDependencyPattern != null ? ignoredDependencyPattern : NONE;
    }

    public List<File> extractOutdatedFiles(List<File> objectFiles, File outputDirectory, boolean gzipOutput) {
        LinkedList<File> outdated = new LinkedList<File>();
        String xmlSuffix = gzipOutput ? ".xml.gz" : ".xml";
        CompilerOptions options = CompilerOptions.createCheckSyntaxOptions(Integer.MAX_VALUE, false);
        for (File objectFile : objectFiles) {
            String name = DependencyChecker.extractLocalizedTemplateName(objectFile, options);
            if (name == null) {
                outdated.add(objectFile);
                continue;
            }
            File t = new File(outputDirectory, name + xmlSuffix);
            File d = new File(outputDirectory, name + ".xml.dep");
            if (!this.statCache.exists(t) || !this.statCache.exists(d)) {
                outdated.add(objectFile);
                continue;
            }
            long targetTime = this.statCache.getModificationTime(t);
            if (this.statCache.isMissingOrModifiedBefore(d, targetTime)) {
                outdated.add(objectFile);
                continue;
            }
            if (!this.isDependencyListOutdated(d, targetTime)) continue;
            outdated.add(objectFile);
        }
        return outdated;
    }

    public static String extractLocalizedTemplateName(File sourceFile, CompilerOptions options) {
        try {
            ASTTemplate ast = CompileTask.CallImpl.compile(sourceFile, options);
            String name = ast.getIdentifier();
            return FileUtils.localizeFilename(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDependencyListOutdated(File dependencyFile, Long targetTime) {
        boolean outdated = false;
        Scanner scanner = null;
        try {
            scanner = new Scanner(dependencyFile);
            while (scanner.hasNextLine() && !outdated) {
                if (!this.isDependencyOutdated(scanner.nextLine(), targetTime)) continue;
                outdated = true;
                break;
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: Outdated dependency file (" + dependencyFile.toString() + "); compiling profile");
            outdated = true;
        }
        catch (IOException e) {
            outdated = true;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return outdated;
    }

    public boolean isDependencyOutdated(String line, Long targetTime) {
        DependencyInfo info = new DependencyInfo(line);
        if (this.ignoreDependencyPattern.matcher(info.name).matches()) {
            return false;
        }
        switch (info.type) {
            case TPL: {
                return this.isSourceDependencyOutdated(info, targetTime);
            }
            case PAN: {
                return this.isSourceDependencyOutdated(info, targetTime);
            }
            case PANX: {
                return this.isSourceDependencyOutdated(info, targetTime);
            }
            case TEXT: {
                return this.isTextDependencyOutdated(info, targetTime);
            }
            case ABSENT_SOURCE: {
                return this.lookupSourceFile(info.name) != null;
            }
            case ABSENT_TEXT: {
                return this.lookupTextFile(info.name) != null;
            }
        }
        throw new BuildException("unknown file type: " + (Object)((Object)info.type));
    }

    public boolean isSourceDependencyOutdated(DependencyInfo info, long targetTime) {
        if (this.isSingleDependencyOutdated(info.file, targetTime)) {
            return true;
        }
        File foundFile = this.lookupSourceFile(info.name);
        return DependencyChecker.isSingleDependencyDifferent(info.file, foundFile);
    }

    public boolean isTextDependencyOutdated(DependencyInfo info, long targetTime) {
        if (this.isSingleDependencyOutdated(info.file, targetTime)) {
            return true;
        }
        File foundFile = this.lookupTextFile(info.name);
        return DependencyChecker.isSingleDependencyDifferent(info.file, foundFile);
    }

    public boolean isSingleDependencyOutdated(File dep, long targetTime) {
        if (dep != null) {
            return this.statCache.isMissingOrModifiedAfter(dep, targetTime);
        }
        return true;
    }

    public File lookupSourceFile(String tplName) {
        String localTplName = FileUtils.localizeFilename(tplName);
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (String extension : SourceType.getExtensions()) {
            sourceFiles.add(localTplName + extension);
        }
        for (File pathdir : this.includeDirectories) {
            for (String sourceFile : sourceFiles) {
                File check = new File(pathdir, sourceFile);
                if (!this.statCache.exists(check)) continue;
                return check;
            }
        }
        return null;
    }

    public File lookupTextFile(String tplName) {
        String localTplName = FileUtils.localizeFilename(tplName);
        for (File pathdir : this.includeDirectories) {
            File check = new File(pathdir, localTplName);
            if (!this.statCache.exists(check)) continue;
            return check;
        }
        return null;
    }

    public static boolean isSingleDependencyDifferent(File dep, File foundFile) {
        if (foundFile != null) {
            return !dep.equals(foundFile);
        }
        return false;
    }

    public static String stripPanExtensions(String name) {
        for (SourceType type : SourceType.values()) {
            String extension = type.getExtension();
            if ("".equals(extension) || !name.endsWith(extension)) continue;
            int index = name.lastIndexOf(extension);
            return name.substring(0, index);
        }
        return name;
    }

    public static File reconstructSingleDependency(String templatePath, String tplName, SourceType type) throws URISyntaxException {
        URI path = new URI(templatePath);
        URI fullname = new URI(tplName + type.getExtension());
        URI fullpath = path.resolve(fullname);
        return new File(fullpath).getAbsoluteFile();
    }

    public static class DependencyInfo {
        public final String name;
        public final SourceType type;
        public final File file;

        public DependencyInfo(String dependencyLine) {
            String[] fields = dependencyLine.split("\\s+");
            if (fields.length != 2 && fields.length != 3) {
                throw new BuildException("malformed dependency line");
            }
            this.name = fields[0];
            this.type = SourceType.valueOf(fields[1]);
            if (fields.length == 3) {
                try {
                    this.file = DependencyChecker.reconstructSingleDependency(fields[2], this.name, this.type);
                }
                catch (URISyntaxException e) {
                    throw new BuildException(e.getMessage());
                }
            } else {
                this.file = null;
            }
            this.validate();
        }

        private void validate() {
            if (this.file == null && !this.type.isAbsent()) {
                throw new BuildException("missing path information for dependency");
            }
            if (this.file != null && this.type.isAbsent()) {
                throw new BuildException("path information for absent file");
            }
        }
    }
}

