/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.CompilerResults;
import org.quattor.pan.CompilerStatistics;
import org.quattor.pan.cache.BuildCache;
import org.quattor.pan.cache.CompileCache;
import org.quattor.pan.cache.Valid1Cache;
import org.quattor.pan.cache.Valid2Cache;
import org.quattor.pan.repository.SourceRepository;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler {
    public static final String version;
    private final TreeMap<TaskResult.ResultType, ThreadPoolExecutor> executors;
    private final AtomicInteger remainingTasks = new AtomicInteger(0);
    private final BlockingQueue<Future<? extends TaskResult>> resultsQueue = new LinkedBlockingQueue<Future<? extends TaskResult>>();
    private final AtomicInteger buildThreadLimit;
    private final Object buildThreadLock = new Object();
    private final CompilerStatistics stats;
    public final CompilerOptions options;
    private final Set<File> files;
    private final CompileCache ccache;
    private final BuildCache bcache;
    private final Valid1Cache v1cache;
    private final Valid2Cache v2cache;

    public Compiler(CompilerOptions options, List<String> objectNames, Collection<File> tplFiles) {
        assert (options != null);
        CompilerLogging.setLogFile(null);
        this.stats = new CompilerStatistics();
        this.options = options;
        this.files = options.resolveFileList(objectNames, tplFiles);
        this.ccache = new CompileCache(this);
        this.bcache = new BuildCache(this);
        this.v1cache = new Valid1Cache(this);
        this.v2cache = new Valid2Cache(this);
        int nprocs = Runtime.getRuntime().availableProcessors();
        if (options.activeThreadsPerQueue > 0) {
            nprocs = options.activeThreadsPerQueue;
        }
        this.executors = new TreeMap();
        for (TaskResult.ResultType t : TaskResult.ResultType.values()) {
            this.executors.put(t, (ThreadPoolExecutor)Executors.newFixedThreadPool(nprocs));
        }
        this.buildThreadLimit = new AtomicInteger(nprocs);
    }

    public static CompilerResults run(CompilerOptions options, List<String> objectNames, Collection<File> tplFiles) {
        return new Compiler(options, objectNames, tplFiles).process();
    }

    public static void main(String[] args) {
        System.out.println(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureMinimumBuildThreadLimit(int minLimit) {
        if (this.buildThreadLimit.get() < minLimit) {
            Object object = this.buildThreadLock;
            synchronized (object) {
                this.buildThreadLimit.set(minLimit);
                ThreadPoolExecutor buildExecutor = this.executors.get((Object)TaskResult.ResultType.BUILD);
                buildExecutor.setMaximumPoolSize(minLimit);
                buildExecutor.setCorePoolSize(minLimit);
            }
        }
    }

    public synchronized CompilerResults process() {
        TreeSet<Throwable> exceptions = new TreeSet<Throwable>(new ThrowableComparator());
        long start = new Date().getTime();
        this.stats.setFileCount(this.files.size());
        if (this.options.xmlWriteEnabled || this.options.depWriteEnabled || this.options.forceBuild) {
            for (File f : this.files) {
                this.ccache.retrieve(f.getAbsolutePath(), false);
            }
        } else {
            for (File f : this.files) {
                this.ccache.compile(f.getAbsolutePath());
            }
        }
        while (this.remainingTasks.get() > 0) {
            try {
                Future<? extends TaskResult> future = this.resultsQueue.take();
                try {
                    this.stats.incrementFinishedTasks(future.get().type);
                }
                catch (ExecutionException ee) {
                    exceptions.add(ee.getCause());
                }
                this.remainingTasks.decrementAndGet();
                this.stats.updateMemoryInfo();
            }
            catch (InterruptedException consumed) {}
        }
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(new RuntimePermission("modifyThread"));
            }
            for (TaskResult.ResultType t : TaskResult.ResultType.values()) {
                this.executors.get((Object)t).shutdown();
            }
        }
        catch (SecurityException se) {
            System.err.println("WARNING: missing modifyThread permission");
        }
        long end = new Date().getTime();
        this.stats.setBuildTime(end - start);
        return new CompilerResults(this.stats, exceptions);
    }

    public CompileCache getCompileCache() {
        return this.ccache;
    }

    public BuildCache getBuildCache() {
        return this.bcache;
    }

    public Valid1Cache getValid1Cache() {
        return this.v1cache;
    }

    public Valid2Cache getValid2Cache() {
        return this.v2cache;
    }

    public SourceRepository getSourceRepository() {
        return this.options.sourceRepository;
    }

    public void submit(Task<? extends TaskResult> task) {
        this.remainingTasks.incrementAndGet();
        this.stats.incrementStartedTasks(task.resultType);
        this.executors.get((Object)task.resultType).submit(task);
        this.resultsQueue.add(task);
        this.stats.updateMemoryInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties defaults = new Properties();
        defaults.setProperty("version", "unknown");
        Properties values = new Properties(defaults);
        InputStream is = Compiler.class.getResourceAsStream("version.properties");
        try {
            values.load(is);
        }
        catch (IOException consumed) {
        }
        catch (NullPointerException consumed) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException consumed) {}
            }
        }
        version = values.getProperty("version");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThrowableComparator
    implements Serializable,
    Comparator<Throwable> {
        @Override
        public int compare(Throwable o1, Throwable o2) {
            int hc2;
            if (o1 == o2) {
                return 0;
            }
            int hc1 = System.identityHashCode(o1);
            if (hc1 < (hc2 = System.identityHashCode(o2))) {
                return 1;
            }
            return 0;
        }
    }
}

