/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.cache;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.quattor.pan.Compiler;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.utils.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCache<T extends TaskResult> {
    protected final Compiler compiler;
    private final ConcurrentHashMap<String, Task<T>> cache;

    protected AbstractCache(Compiler compiler, int size) {
        assert (compiler != null);
        assert (size > 0);
        this.compiler = compiler;
        this.cache = new ConcurrentHashMap(size);
    }

    public Future<T> retrieve(String key, boolean executeInline) {
        assert (key != null);
        boolean createdTask = false;
        Task<T> task = this.cache.get(key);
        if (task == null) {
            Task<T> newTask = this.createTask(key);
            Task<T> existingEntry = this.cache.putIfAbsent(key, newTask);
            if (existingEntry == null) {
                createdTask = true;
                task = newTask;
            } else {
                task = existingEntry;
            }
        }
        if (executeInline) {
            task.run();
        } else if (createdTask) {
            this.compiler.submit(task);
        }
        return task;
    }

    public T waitForResult(String key) throws RuntimeException, ValidationException {
        Future<T> future = this.retrieve(key, true);
        TaskResult result = null;
        try {
            result = (TaskResult)future.get();
        }
        catch (InterruptedException ie) {
            throw EvaluationException.create("MSG_INTERRUPTED_THREAD", key);
        }
        catch (CancellationException ce) {
            throw EvaluationException.create("MSG_CANCELLED_THREAD", key);
        }
        catch (ExecutionException ee) {
            throw ExceptionUtils.launder(ee);
        }
        return (T)result;
    }

    public Future<T> retrieve(String key) {
        assert (key != null);
        return this.cache.get(key);
    }

    protected abstract Task<T> createTask(String var1);

    protected abstract TaskResult.ResultType getExecutorQueueType();
}

