/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import java.io.ObjectStreamException;
import net.jcip.annotations.Immutable;
import org.quattor.pan.dml.data.Property;

@Immutable
public final class BooleanProperty
extends Property {
    public static final BooleanProperty TRUE = new BooleanProperty(true);
    public static final BooleanProperty FALSE = new BooleanProperty(false);

    private BooleanProperty(boolean value) {
        super(value ? Boolean.TRUE : Boolean.FALSE);
    }

    public static BooleanProperty getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static BooleanProperty getInstance(Boolean value) {
        assert (value != null);
        return value != false ? TRUE : FALSE;
    }

    public static BooleanProperty getInstance(String value) {
        assert (value != null);
        return Boolean.parseBoolean(value) ? TRUE : FALSE;
    }

    public Object readResolve() throws ObjectStreamException {
        return this.getValue() != false ? TRUE : FALSE;
    }

    public Boolean getValue() {
        return (Boolean)super.getValue();
    }

    public String getTypeAsString() {
        return "boolean";
    }
}

