/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import net.jcip.annotations.Immutable;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.DoubleProperty;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.PersistentElement;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.data.TransientElement;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;

@Immutable
public abstract class Element
implements Operation {
    public boolean exists() {
        return !(this instanceof Null);
    }

    public boolean defined() {
        return this.exists() && !(this instanceof Undef);
    }

    public boolean isProperty() {
        return this instanceof Property;
    }

    public boolean isLong() {
        return this instanceof LongProperty;
    }

    public boolean isDouble() {
        return this instanceof DoubleProperty;
    }

    public boolean isBoolean() {
        return this instanceof BooleanProperty;
    }

    public boolean isString() {
        return this instanceof StringProperty;
    }

    public boolean isResource() {
        return this instanceof Resource;
    }

    public boolean isNlist() {
        return this instanceof HashResource;
    }

    public boolean isList() {
        return this instanceof ListResource;
    }

    public boolean isPersistent() {
        return this instanceof PersistentElement;
    }

    public boolean isTransient() {
        return this instanceof TransientElement;
    }

    public String locateUndefinedElement() {
        return null;
    }

    public void checkRange(Range range) throws ValidationException {
        throw ValidationException.create("MSG_INVALID_RANGE_CHECK", this.getTypeAsString());
    }

    public Element execute(Context context) throws EvaluationException {
        return this;
    }

    public Element duplicate() {
        return this;
    }

    public Element writableCopy() {
        return this;
    }

    public void checkRestrictedContext() throws SyntaxException {
    }

    public void checkInvalidSelfContext() throws SyntaxException {
    }

    public boolean isProtected() {
        return false;
    }

    public void checkValidReplacement(Element newValue) throws EvaluationException {
        if (!(newValue instanceof Undef || newValue instanceof Null || this.getClass().isAssignableFrom(newValue.getClass()))) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_REPLACEMENT", this.getTypeAsString(), newValue.getTypeAsString()));
        }
    }

    public Element protect() {
        return this;
    }

    public Element rget(Term[] terms, int index, boolean protect, boolean lookupOnly) throws InvalidTermException {
        if (!lookupOnly) {
            throw new EvaluationException(MessageUtils.format("MSG_ILLEGAL_DEREFERENCE", this.getTypeAsString()));
        }
        return null;
    }

    public ListResource rgetList(Term[] terms, int index) throws InvalidTermException {
        throw new EvaluationException(MessageUtils.format("MSG_ILLEGAL_DEREFERENCE", this.getTypeAsString()));
    }

    public void rput(Term[] terms, int index, Element value) throws InvalidTermException {
        throw new EvaluationException(MessageUtils.format("MSG_CANNOT_ADD_CHILD", this.getTypeAsString()));
    }

    public abstract String getTypeAsString();

    public abstract String toString();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

