/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.ProtectedListResource;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListResource
extends Resource {
    private List<Element> list;

    public ListResource() {
        this.list = new ArrayList<Element>();
    }

    public ListResource(Element[] args) {
        this.list = new ArrayList<Element>();
        for (Element arg : args) {
            this.list.add(arg);
        }
    }

    private ListResource(List<Element> childrenList) {
        try {
            this.list = new ArrayList<Element>(childrenList.size());
            for (Element element : childrenList) {
                Element clone = element.duplicate();
                this.list.add(clone);
            }
        }
        catch (StackOverflowError e) {
            throw new EvaluationException("stack overflow; check for circular data structure");
        }
    }

    protected ListResource(ListResource source) {
        ArrayList<Element> alist = new ArrayList<Element>(source.list.size());
        for (Element e : source.list) {
            alist.add(e.protect());
        }
        alist.trimToSize();
        this.list = alist;
    }

    @Override
    public Element duplicate() {
        return new ListResource(this.list);
    }

    @Override
    public Element get(Term term) throws InvalidTermException {
        assert (term != null);
        Element value = null;
        int index = 0;
        try {
            index = term.getIndex();
            value = this.list.get(index);
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        return value;
    }

    @Override
    public Element put(Term term, Element value) throws InvalidTermException {
        assert (term != null);
        return this.put(term.getIndex(), value);
    }

    public Element put(int index, Element newValue) {
        Element oldValue = null;
        if (index < 0) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_LIST_INDEX", Integer.valueOf(index).toString()));
        }
        try {
            if (newValue != null && !(newValue instanceof Null)) {
                int size = this.list.size();
                if (index >= size) {
                    for (int i = 0; i < index - size; ++i) {
                        this.list.add(Undef.VALUE);
                    }
                    this.list.add(newValue);
                } else {
                    oldValue = this.list.set(index, newValue);
                    if (oldValue != null) {
                        oldValue.checkValidReplacement(newValue);
                    }
                }
            } else {
                try {
                    oldValue = this.list.remove(index);
                }
                catch (IndexOutOfBoundsException ioobe) {}
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new EvaluationException(MessageUtils.format("MSG_NONEXISTANT_LIST_ELEMENT", Integer.valueOf(index).toString()));
        }
        return oldValue;
    }

    public void append(Element e) {
        assert (e != null);
        this.list.add(e);
    }

    public void prepend(Element e) {
        assert (e != null);
        this.list.add(0, e);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Resource.Iterator iterator() {
        return new ListResourceIterator(this.list);
    }

    @Override
    public String locateUndefinedElement() {
        int nchild = this.list.size();
        for (int i = 0; i < nchild; ++i) {
            String rpath = this.list.get(i).locateUndefinedElement();
            if (rpath == null) continue;
            return !"".equals(rpath) ? i + "/" + rpath : Integer.toString(i);
        }
        return null;
    }

    @Override
    public void checkRange(Range range) throws ValidationException {
        if (!range.isInRange(this.list.size())) {
            throw ValidationException.create("MSG_LIST_SIZE_OUTSIDE_RANGE", this.list.size(), range.toString());
        }
    }

    @Override
    public void checkValidReplacement(Element newValue) throws EvaluationException {
        if (!(newValue instanceof Undef || newValue instanceof Null || newValue instanceof ListResource)) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_REPLACEMENT", this.getTypeAsString(), newValue.getTypeAsString()));
        }
    }

    @Override
    public Element protect() {
        return new ProtectedListResource(this);
    }

    @Override
    public String getTypeAsString() {
        return "list";
    }

    @Override
    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ListResource) {
            return ((Object)this.list).equals(((ListResource)o).list);
        }
        return false;
    }

    protected List<Element> getBackingList() {
        return this.list;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        String separator = "";
        for (Resource.Entry entry : this) {
            sb.append(separator);
            sb.append(((Element)entry.getValue()).toString());
            separator = ", ";
        }
        sb.append(" ]");
        return sb.toString();
    }

    private static class ListResourceEntry
    implements Resource.Entry {
        private final Property key;
        private final Element value;

        public ListResourceEntry(Property key, Element value) {
            assert (key != null);
            assert (value != null);
            this.key = key;
            this.value = value;
        }

        public Property getKey() {
            return this.key;
        }

        public Element getValue() {
            return this.value;
        }

        public Element setValue(Element value) {
            throw new UnsupportedOperationException("ListResourceEntry does not support setValue()");
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ListResourceEntry) {
                ListResourceEntry other = (ListResourceEntry)o;
                return this.key.equals(other.key) && this.value.equals(other.value);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListResourceIterator
    implements Resource.Iterator {
        private volatile int index;
        private final List<Element> backingList;

        public ListResourceIterator(List<Element> backingList) {
            assert (backingList != null);
            this.backingList = backingList;
            this.index = 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ListResourceIterator does not support remove()");
        }

        @Override
        public boolean hasNext() {
            return this.index < this.backingList.size();
        }

        @Override
        public Resource.Entry next() {
            ListResourceEntry entry = null;
            try {
                entry = new ListResourceEntry(LongProperty.getInstance(this.index), this.backingList.get(this.index));
                ++this.index;
            }
            catch (NoSuchElementException nsee) {
                throw new EvaluationException(MessageUtils.format("MSG_CONCURRENT_MODIFICATION", new Object[0]), null);
            }
            return entry;
        }
    }
}

